<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 2/16/2019
 * Time: 12:10 PM
 */

namespace App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class Admins extends Model
{
    use SoftDeletes;

    protected $fillable = ['id','user_name','password','token','created_at'];
    protected $table = 'admins';

    public static function verifyPassword($userName, $password)
    {
        $adminData = \DB::selectOne("SELECT id FROM admins WHERE user_name=? AND password=?", [$userName,$password]);

        if (!$adminData)
            return 'WRONGCREDENTIALS';

        $token = sha1($adminData->id . Str::random(20));
        \DB::update("UPDATE admins SET token=? WHERE id=?", [$token, $adminData->id]);
        return $token;
    }


    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('admins')
            ->select([
                '*'
            ])
            ->where('id', '=', $id);
    }

    public static function whereUserName($userName)
    {
        return \DB::table('admins')
            ->select([
                '*'
            ])
            ->where('user_name', '=', $userName);
    }

    public static function whereToken($token)
    {
        return \DB::table('admins')
            ->select([
                '*'
            ])
            ->where('token', '=', $token);
    }

    //</editor-fold>
}