<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 1/18/2019
 * Time: 6:16 PM
 */

namespace App;

use App\Systems;
use Illuminate\Database\Eloquent\Model;


class Brands extends model
{
    protected $table = 'brands';

    public static function getBrandBadges($supplierId)
    {
        return \DB::table('brands as b')
            ->select([
                'b.id',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",b.badge) AS badge')
            ])
            ->join('brand_systems as bs', 'bs.brand_id', '=', 'b.id')
            ->join('supplier_system as ss', 'ss.brand_system_id', '=', 'bs.id')
            ->where('ss.supplier_id','=',$supplierId)
            ->groupBy('b.id')
            ->get();
    }

    public static function getBrandsBySupplier($supplierId)
    {
        return \DB::table('brands as b')
            ->select([
                'b.id',
                'b.name',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",b.badge) AS badge')
            ])
            ->join('brand_systems as bs', 'bs.brand_id', '=', 'b.id')
            ->join('supplier_system as ss', 'ss.brand_system_id', '=', 'bs.id')
            ->where('ss.supplier_id','=',$supplierId)
            ->groupBy('b.id')
            ->get();
    }

    public static function getBrandsBySystem($systemId)
    {
        return \DB::table('brands as b')
            ->select([
                'b.id',
                'b.name',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",b.badge) AS badge')
            ])
            ->join('brand_systems as bs', 'bs.brand_id', '=', 'b.id')
            ->where('bs.system_id','=',$systemId)
            ->groupBy('b.id')
            ->get();
    }

    public static function addBrand($name,$badge)
    {
        return \DB::table('brands')
            ->insert(['name' => $name , 'badge'=> env('brandBadgesPath').$badge]);
    }

    public static function updateBrand($name,$badge,$brandId)
    {
        $brand = self::whereId($brandId)->first();

        if((basename($brand->badge) != basename($badge))) {

            if (Util::deleteFile($brand->badge)) {
                return \DB::table('brands')
                    ->where('id', '=', $brandId)
                    ->update(['name' => $name
                        , 'badge' => env('brandBadgesPath').basename($badge)]);
            } else {
                return false;
            }
        } else {
            return \DB::table('brands')
                ->where('id', '=', $brandId)
                ->update(['name' => $name
                    , 'badge' => env('brandBadgesPath').basename($badge)]);
        }
    }

    public static function getAllBrandsWithSystems()
    {
        $brands = \DB::table('brands as b')
            ->select([
                'b.id',
                'b.name',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",b.badge) AS badge')
            ])
            ->get();

        $output = [];
        foreach ($brands as $brand) {
            $brand->systems = Systems::getSystemsIdsForBrand($brand->id);
            $output[] = $brand;
        }
        return $brands;
    }

    public static function getAllBrands()
    {
        return \DB::table('brands as b')
            ->select([
                'b.id',
                'b.name'
            ])
            ->get();
    }

    public static function addSystemsForBrands($brandId,$addedBrandSystemsIds)
    {
        $currentBrandSystems = \DB::select("SELECT id,system_id FROM brand_systems 
            WHERE brand_id=?"
            , [$brandId]);

        $currentBrandSystemsIds = \DB::table('brand_systems')
            ->select(['system_id'])
            ->where('brand_id','=',$brandId)
            ->lists('system_id');

        foreach ($currentBrandSystems as $currentBrandSystem)
        {
            if (!in_array($currentBrandSystem->system_id, $addedBrandSystemsIds)) {
                \DB::table('brand_systems')
                    ->where('id', '=', $currentBrandSystem->id)
                    ->delete();
            }
        }

        foreach ($addedBrandSystemsIds as $addedBrandSystemId)
        {
            if (!in_array($addedBrandSystemId, $currentBrandSystemsIds)) {
                \DB::table('brand_systems')
                    ->insert(['brand_id' => $brandId , 'system_id'=> $addedBrandSystemId]);
            }
        }
        return true;
    }

    public static function deleteBrand($brandId)
    {
        $brand = self::whereId($brandId)->first();
        if (Util::deleteFile($brand->badge)) {
            return \DB::table('brands')
                ->where('id', '=', $brandId)
                ->delete();
        } else {
            return false;
        }

    }

    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('brands')
            ->select([
                '*'
            ])
            ->where('id', '=', $id);
    }

    public static function whereName($name)
    {
        return \DB::table('brands')
            ->select([
                '*'
            ])
            ->where('name', '=', $name);
    }

    //</editor-fold>
}