<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 2/16/2019
 * Time: 10:42 AM
 */

namespace App\Http\Controllers;

use App\RequestPremium;
use App\Service;
use App\SystemMessage;
use App\User as User;
use App\Admins;
use App\Util;
use App\mainCategory;
use App\Areas;
use App\Fields;
use App\Items;
use App\Suppliers;
use App\SubCategory;
use App\SubSubCategory;
use App\Brands;
use App\Systems;
use Illuminate\Http\Request;
use Carbon\Carbon;

class AdminController extends Controller
{
    private $ignoreVerifyAccess = array('login');
    private $requestVerifyAccess = array('addMainCategories','addSubCategory','addSubSubCategory'
    ,'getMainCategories','getSubCategories','getSubSubCategories','getAreas'
    ,'getFields','addArea','addField','addBrand','getBrands','uploadAttachmentArray'
    ,'uploadAttachmentSingle','getSystems','addSystem','getAllSuppliers','changeSupplierStatus'
    ,'getBrandsBySupplier','getSystemsByBrandForSupplier','getBrandsAndSystemsForSupplier'
    ,'updateMainCategories','updateSubCategory','updateSubSubCategory','updateBrand'
    ,'updateSystem','addSystemsForBrands','deleteMainCategories','deleteSubCategories'
    ,'deleteSubSubCategories','deleteBrand','deleteSystem','getSystemsForSubSubCategory'
    ,'addItem','updateItem','updateItemStatus','getSystemsForBrand','getAllUsers','getRequestPremium'
    ,'updateUserPremium','updateUserStatus');

    private $adminData;

    public function InternalDispatcher(Request $request, $requestedAPI = null)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), ['requestedAPI' => 'required']);
        $internalRequest = $requestedAPI ? $requestedAPI : $request->get('requestedAPI');

        if (!$internalRequest) {
            $output->msg = 'NOENDPOINT';
            $this->returnOutput($output);
        }
        try {
            \DB::connection()->getPdo()->beginTransaction();
            $output->msg = $this->verifyAccess($request);
            if ($output->msg == 'SUCCESS')
                $output = call_user_func([$this, $internalRequest], $request);
            \DB::connection()->getPdo()->commit();
            return $this->returnOutput($output);
        } catch (\PDOException $e) {
            \DB::connection()->getPdo()->rollBack();
            $output->msg = 'UNKNOWNERROR';
            $this->returnOutput($output);
        }
    }

    private function verifyAccess(Request $request)
    {
        if (in_array($request->requestedAPI, $this->ignoreVerifyAccess))
            return 'SUCCESS';
        if (!in_array($request->requestedAPI, $this->requestVerifyAccess))
            return 'UNAUTHORIZEDREQUEST';
        if(!$request->has('token'))
            return 'NOTOKEN';
        $this->adminData = Admins::whereToken($request->token)->first();
        if (!$this->adminData)
            return 'TOKENEXPIRED';
        return 'SUCCESS';
    }

    private function returnOutput(\stdClass $output)
    {
        if (empty($output->msg))
            $output->msg = 'SUCCESS';
        $system_message = SystemMessage::whereMsg($output->msg)->first();
        if ($system_message === null) {
            $output->code = '404';
            $output->message = 'Unknown error';
        } else {
            $output->code = $system_message->code;
            $output->message = $system_message->message;
        }

        return response()->json($output);
    }

    private function login(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), ['userName' => 'required', 'password' => 'required']);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $token = Admins::verifyPassword($request['userName'], $request['password']);
        if (in_array($token, ['WRONGCREDENTIALS', 'INACTIVEUSER','UNREGISTEREDEMAIL'])) {
            $output->msg = $token;

            return $output;
        }
        $output->token = $token;
        return $output;
    }

    public function getMainCategories(Request $request)
    {
        $output = new \stdClass;

        $output->mainCategories = mainCategory::getAllMainCategories();

        return $output;
    }

    public function getSubCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'mainCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->subCategories = SubCategory::getAllSubCategories($request->mainCategoryId);

        return $output;
    }

    public function getSubSubCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->subSubCategories = SubSubCategory::getAllSubSubCategories($request->subCategoryId);

        return $output;
    }

    public function addMainCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'mainCategory' => 'required',
            'attachment' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = mainCategory::addCategory($request->mainCategory,$request->attachment);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateMainCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'mainCategoryId' => 'required',
            'mainCategory' => 'required',
            'attachment' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $updated = mainCategory::updateCategory($request->mainCategoryId,$request->mainCategory,$request->attachment);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function deleteMainCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'mainCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $deleted = mainCategory::deleteMainCategory($request->mainCategoryId);

        if(!$deleted)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function addSubCategory(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'mainCategoryId' => 'required',
            'name' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = SubCategory::addSubCategory($request->mainCategoryId,$request->name);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateSubCategory(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'mainCategoryId' => 'required',
            'subCategoryId' => 'required',
            'name' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $updated = SubCategory::updateSubCategory($request->subCategoryId,$request->mainCategoryId
            ,$request->name);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function deleteSubCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $deleted = SubCategory::deleteSubCategory($request->subCategoryId);

        if(!$deleted)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function addSubSubCategory(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subCategoryId' => 'required',
            'name' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = SubSubCategory::addSubSubCategory($request->subCategoryId,$request->name);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateSubSubCategory(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subSubCategoryId' => 'required',
            'subCategoryId' => 'required',
            'name' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $updated = SubSubCategory::updateSubSubCategory($request->subSubCategoryId
            ,$request->subCategoryId
            ,$request->name);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function deleteSubSubCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subSubCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $deleted = SubSubCategory::deleteSubSubCategory($request->subSubCategoryId);

        if(!$deleted)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    private function uploadAttachmentArray(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'path' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $index = 0;
        $output->attachment = [];

        $attachments = $request->attachment;
        foreach ($request->attachment as $file) {
            $result = Util::uploadImg($request, 'attachment'
                , 'uploads/'.$request->path,$index);
            if ($result->msg != "SUCCESS") {
                $output->msg = $result->msg;
                return $output;
            }
            array_push($output->attachment,$result->file_name);
            $index++;
        }
        return $output;
    }

    private function uploadAttachmentSingle(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'path' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $result = Util::uploadImg2($request, 'attachment'
            , 'uploads/'.$request->path);
        if ($result->msg != "SUCCESS") {
            $output->msg = $result->msg;
            return $output;
        }
        $output->attachment=$result->file_name;
        $output->attachmentLink='http://'.$_SERVER["SERVER_NAME"].'/uploads/'.$request->path.'/'.$result->file_name;
        return $output;
    }

    public function getAreas(Request $request)
    {
        $output = new \stdClass;

        $output->areas = Areas::getAllAreas();

        return $output;
    }

    public function getFields(Request $request)
    {
        $output = new \stdClass;

        $output->fields = Fields::getAllFields();

        return $output;
    }

    public function addArea(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'area' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = Areas::addArea($request->area);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function addField(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'field' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = Fields::addField($request->field);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function addBrand(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'name' => 'required',
            'badge' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = Brands::addBrand($request->name,$request->badge);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateBrand(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'brandId' => 'required',
            'name' => 'required',
            'badge' => 'required',
            'systems' => ''
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        /*$brand = Brands::whereId($request->brandId)->first();
        $output->ss = basename($request->badge);
        return $output;*/

        Brands::updateBrand($request->name,$request->badge,$request->brandId);
        $added = Brands::addSystemsForBrands($request->brandId,$request->systems);

        if(!($added))
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function deleteBrand(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'brandId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $deleted = Brands::deleteBrand($request->brandId);

        if(!$deleted)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getBrands(Request $request)
    {
        $output = new \stdClass;

        $output->brands = Brands::getAllBrandsWithSystems();

        return $output;
    }

    public function addSystem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'name' => 'required',
            'description' => 'required',
            'subSubCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = Systems::addSystem($request->name,$request->description
            ,$request->subSubCategoryId,$request->catalog);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateSystem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'systemId' => 'required',
            'name' => 'required',
            'description' => 'required',
            'subSubCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $updated = Systems::updateSystem($request->name,$request->description
            ,$request->subSubCategoryId,$request->catalog,$request->systemId);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function deleteSystem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'systemId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $deleted = Systems::deleteSystem($request->systemId);

        if(!$deleted)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getSystems(Request $request)
    {
        $output = new \stdClass;

        $output->systems = Systems::getAllSystems();

        return $output;
    }

    /*public function addSystemsForBrands(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'brandId' => 'required',
            'systemsIds' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = Brands::addSystemsForBrands($request->brandId,$request->systemsIds);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }*/

    public function getAllSuppliers(Request $request)
    {
        $output = new \stdClass;

        $output->suppliers = Suppliers::getAllSuppliersAdmin();

        return $output;
    }

    public function changeSupplierStatus(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $updated = Suppliers::updateSupplierStatus($request->supplierId,$request->status);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getBrandsBySupplier(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->brands = Brands::getBrandsBySupplier($request->supplierId);

        return $output;
    }

    public function getSystemsByBrandForSupplier(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'brandId' => 'required',
            'supplierId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->systems = Systems::getSystemsByBrandForSupplierForAdmin($request->brandId,$request->supplierId);

        return $output;
    }

    public function getBrandsAndSystemsForSupplier(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->brands = Brands::getBrandsBySupplier($request->supplierId);
        $output->systems = Systems::getAllSystemsForSupplierForAdmin($request->supplierId);

        return $output;
    }

    public function getSystemsForSubSubCategory(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subSubCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->systems = Systems::getSystemsBySubSubCategory($request->subSubCategoryId);

        return $output;
    }

    public function addItem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'name' => 'required',
            'description' => 'required',
            'partNumber' => 'required',
            'image' => 'required',
            'pdfLink' => 'required',
            'supplierId' => 'required',
            'brandId' => 'required',
            'systemId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = Items::addItemForAdmin($request->name,$request->description,$request->partNumber
            ,$request->image,$request->pdfLink,$request->supplierId
            ,$request->brandId,$request->systemId);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateItem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'itemId' => 'required',
            'name' => 'required',
            'description' => 'required',
            'partNumber' => 'required',
            'image' => 'required',
            'pdfLink' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $updated = Items::updateItem($request->name,$request->description
            ,$request->partNumber,$request->image,$request->pdfLink,$request->itemId);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateItemStatus(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'itemId' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $deleted = Items::updateItemStatus($request->itemId,$request->status);

        if(!$deleted)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getSystemsForBrand(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'brandId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            $output->parameters = $validator->messages();
            return $output;
        }

        $output->systems = Systems::getSystemsByBrandForAdmin($request->brandId,$request->supplierId);

        return $output;
    }

    public function getAllUsers(Request $request)
    {
        $output = new \stdClass;

        $output->users = User::getUsers();

        return $output;
    }

    public function updateUserStatus(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'status' => 'required',
            'userId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            $output->parameters = $validator->messages();
            return $output;
        }

        $updated = User::updateUserStatus($request->status,$request->userId);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateUserPremium(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'premium' => 'required',
            'userId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            $output->parameters = $validator->messages();
            return $output;
        }

        $updated = User::updateUserPremium($request->premium,$request->userId);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getRequestPremium(Request $request)
    {
        $output = new \stdClass;

        $output->RequestedUsers = RequestPremium::getRequestedPremiumUsers();

        return $output;
    }

}