<?php

namespace App\Http\Controllers;

use Log;
use App\RequestPremium;
use App\Service;
use App\SystemMessage;
use App\User as User;
use App\Util;
use App\mainCategory;
use App\Areas;
use App\Fields;
use App\Suppliers;
use App\SubCategory;
use App\SubSubCategory;
use App\Brands;
use App\Items;
use App\Systems;
use Illuminate\Http\Request;
use Carbon\Carbon;

class ApiController extends Controller
{
    private $ignoreVerifyAccess = array('login','register','getMainCategories','getSubCategories'
    ,'getSubSubCategories','getAllSuppliers','getAllSubSubCategorySuppliers','getSupplierData'
    ,'getBrandsBySupplier','getSystemsByBrandForSupplier','getAreas','getFields'
    ,'getSuppliersByMainCategory','getSuppliersBySubCategory','getSupplierInformation'
    ,'getSuppliersBySystem','getBrandsAndSystemsForSupplier');
    private $requestVerifyAccess = array('updateUserData','getSystemsForPremium'
    ,'requestForQuotationToSuppliers','requestForQuotationToSupplierForSystem','requestForQuotationToSupplierForItem'
    ,'RequestPremium','getBrandsBySystem','getSuppliersByBrandAndSystem');

    private $userData;
    private $returnedResponse;
 
    public function InternalDispatcher(Request $request, $requestedAPI = null)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), ['requestedAPI' => 'required']);
        $internalRequest = $requestedAPI ? $requestedAPI : $request->get('requestedAPI');

        if (!$internalRequest) {
            $output->msg = 'NOENDPOINT';
            $this->returnOutput($output);
        }
        try {
            \DB::connection()->getPdo()->beginTransaction();
            $output->msg = $this->verifyAccess($request);
            if ($output->msg == 'SUCCESS')
                $output = call_user_func([$this, $internalRequest], $request);
            \DB::connection()->getPdo()->commit();

            $returnedData = $this->returnOutput($output);

            //----------------Log Data--------------
            //return self::get_client_ip();
            //return $_SERVER['HTTP_USER_AGENT'];

            $userId = $this->userData ? $this->userData->id : '';

            Log::info('user : '.$userId.' call '.$request->fullUrl().
                ' with parameters '.json_encode($request->all()). ' response : '
                .$this->returnedResponse->msg.','.$this->returnedResponse->code
                .','.$this->returnedResponse->message).'  from ip_address : '.Util::get_client_ip()
            .' and browser : '.$_SERVER['HTTP_USER_AGENT'];

            //----------------Log Data--------------

            return $returnedData;
        } catch (\PDOException $e) {
            \DB::connection()->getPdo()->rollBack();
            $output->msg = 'UNKNOWNERROR';

            $returnedData = $this->returnOutput($output);

            //----------------Log Data--------------

            $userId = $this->userData ? $this->userData->id : '';

            Log::error('user : '.$userId.' call '.$request->fullUrl().
                ' with parameters '.json_encode($request->all()). ' response : '
                .$this->returnedResponse->msg.','.$this->returnedResponse->code
                .','.$this->returnedResponse->message).'  from ip_address : '.Util::get_client_ip()
            .' and browser : '.$_SERVER['HTTP_USER_AGENT'];

            //----------------Log Data--------------

            return $returnedData;
        }
    }

    private function verifyAccess(Request $request)
    {
        if (in_array($request->requestedAPI, $this->ignoreVerifyAccess))
            return 'SUCCESS';
        if (!in_array($request->requestedAPI, $this->requestVerifyAccess))
            return 'UNAUTHORIZEDREQUEST';
        if(!$request->has('token'))
            return 'NOTOKEN';
        $this->userData = User::whereToken($request->token)->first();
        if (!$this->userData)
            return 'TOKENEXPIRED';
        return 'SUCCESS';
    }

    private function returnOutput(\stdClass $output)
    {
        if (empty($output->msg))
            $output->msg = 'SUCCESS';
        $system_message = SystemMessage::whereMsg($output->msg)->first();
        if ($system_message === null) {
            $output->code = '404';
            $output->message = 'Unknown error';
        } else {
            $output->code = $system_message->code;
            $output->message = $system_message->message;
        }

        $this->returnedResponse = $output; //----------------Log Data--------------

        return response()->json($output);
    }

    /**
     * @param Request $request
     * @return \stdClass
     */
    private function login(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), ['userName' => 'required', 'password' => 'required']);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $token = User::verifyPassword($request['userName'], $request['password']);
        if (in_array($token, ['WRONGCREDENTIALS', 'INACTIVEUSER','UNREGISTEREDEMAIL'])) {
            $output->msg = $token;

            return $output;
        }
        $output->userData = User::whereUserName($request['userName'])->first();
        $output->token = $token;
        return $output;
    }

    public function register(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'userName' => 'required',
            'password' => 'required',
            'firstName' => 'required',
            'lastName' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'fax' => '',
            'companyName' => 'required',
            'areaId' => 'required',
            'fieldId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $checkIfUserNameExist = User::whereUserName($request['userName'])->first();
        if(!$checkIfUserNameExist)
        {
            $isInserted = User::createUser($request);

            if(!$isInserted)
            {
                $output->msg = 'INVALIDPARAMETER';
                return $output;
            }
            /*$output->mailSent = Util::sendSystemMail([
                'name' => $request->admin_name,
                'password' =>$request->admin_password,
                'email' =>$request->admin_email,
                'subject' => 'Welcome Email'
            ],"Welcome_mail");*/
        } else {
            $output->msg = 'DUPLICATEDEMAIL';
            return $output;
        }

        return $output;
    }

    public function getMainCategories(Request $request)
    {
        $output = new \stdClass;

        $output->mainCategories = mainCategory::getAllMainCategories();

        return $output;
    }

    public function getSubCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'mainCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->subCategories = SubCategory::getAllSubCategories($request->mainCategoryId);

        return $output;
    }

    public function getSubSubCategories(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->subSubCategories = SubSubCategory::getAllSubSubCategories($request->subCategoryId);

        return $output;
    }

    public function getAllSuppliers(Request $request)
    {
        $output = new \stdClass;

        $output->suppliers = Suppliers::getAllSuppliers();

        return $output;
    }

    public function getSuppliersByMainCategory(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'mainCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->suppliers = Suppliers::getAllMainCategorySuppliers($request->mainCategoryId);

        return $output;
    }

    public function getSuppliersBySubCategory(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->suppliers = Suppliers::getAllSubCategorySuppliers($request->subCategoryId);

        return $output;
    }

    public function getSuppliersBySystem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'systemId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->suppliers = Suppliers::getAllSystemSuppliers($request->systemId);

        return $output;
    }

    public function getAllSubSubCategorySuppliers(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'subSubCategoryId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->subSubCategorySuppliers = Suppliers::getAllSubSubCategorySuppliers($request->subSubCategoryId);

        return $output;
    }

    public function getSupplierData(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->supplier = Suppliers::getSupplierDetails($request->supplierId);

        return $output;
    }

    public function getBrandsBySupplier(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->brands = Brands::getBrandsBySupplier($request->supplierId);

        return $output;
    }

    public function getSystemsByBrandForSupplier(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'brandId' => 'required',
            'supplierId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->systems = Systems::getSystemsByBrandForSupplier($request->brandId,$request->supplierId);

        return $output;
    }

    public function getBrandsAndSystemsForSupplier(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->brands = Brands::getBrandsBySupplier($request->supplierId);
        $output->systems = Systems::getAllSystemsForSupplier($request->supplierId);

        return $output;
    }

    /*public function getSupplierInformation(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->supplierInformation = Suppliers::getSupplierInformation($request->supplierId);

        return $output;
    }*/

    public function getAreas(Request $request)
    {
        $output = new \stdClass;

        $output->areas = Areas::getAllAreas();

        return $output;
    }

    public function getFields(Request $request)
    {
        $output = new \stdClass;

        $output->fields = Fields::getAllFields();

        return $output;
    }

    public function updateUserData(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'userName' => 'required',
            'password' => 'required',
            'firstName' => 'required',
            'lastName' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'fax' => '',
            'companyName' => 'required',
            'areaId' => 'required',
            'fieldId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            $output->parameters = $validator->messages();
            return $output;
        }

        $updated = User::updateUserData($request,$this->userData->id);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getSystemsForPremium(Request $request)
    {
        $output = new \stdClass;

        if($this->userData->premium)
            $output->systems = Systems::getAllSystems();
        else
            $output->msg = 'DISALLOWEDACTION';

        return $output;
    }

    public function requestForQuotationToSuppliers(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierIds' => 'required',
            'systemId' => 'required',
            'brandId' => 'required',
            'comment' => ''
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            $output->parameters = $validator->messages();
            return $output;
        }

        if(!$this->userData->premium)
        {
            $output->msg = 'DISALLOWEDACTION';
            return $output;
        }

        $systemObject = Systems::whereId($request->systemId)->first();

        $brandObject = Brands::whereId($request->brandId)->first();

        $mailname = $systemObject->name.' for this brand ' . $brandObject->name;

        foreach ($request->supplierIds as $supplierId) {

            $supplierObject = Suppliers::getSupplierData($supplierId);

            $mailSent = Util::sendSystemMail([
                'type' => 'system',
                'name' => $mailname,
                'thePartNumber' => '',
                'partNumber' => '',
                'comment' => $request->comment,
                'userEmail' => $this->userData->email,
                'email' => $supplierObject->email,
                'subject' => 'Request For Quotation'
            ], "request_for_quotation");

            if(!$mailSent) {
                $output->msg = 'SENDINGERROR';
                return $output;
            }
        }

        return $output;
    }

    public function requestForQuotationToSupplierForSystem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required',
            'brandId' => 'required',
            'systemId' => 'required',
            'comment' => ''
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            $output->parameters = $validator->messages();
            return $output;
        }

        if(!$this->userData->premium)
        {
            $output->msg = 'DISALLOWEDACTION';
            return $output;
        }

        $systemObject = Systems::whereId($request->systemId)->first();

        $brandObject = Brands::whereId($request->brandId)->first();

        $supplierObject = Suppliers::getSupplierData($request->supplierId);

        $mailname = $systemObject->name.' for this brand ' . $brandObject->name;

        $mailSent = Util::sendSystemMail([
            'type' => 'system',
            'name' => $mailname,
            'thePartNumber' => '',
            'partNumber' => '',
            'comment' => $request->comment,
            'userEmail' => $this->userData->email,
            'email' => $supplierObject->email,
            'subject' => 'Request For Quotation'
        ], "request_for_quotation");

        if(!$mailSent) {
            $output->msg = 'SENDINGERROR';
            return $output;
        }


        return $output;
    }

    public function requestForQuotationToSupplierForItem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierId' => 'required',
            'itemId' => 'required',
            'comment' => ''
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            $output->parameters = $validator->messages();
            return $output;
        }

        if(!$this->userData->premium)
        {
            $output->msg = 'DISALLOWEDACTION';
            return $output;
        }

        $itemObject = Items::whereId($request->itemId)->first();

        $supplierObject = Suppliers::getSupplierData($request->supplierId);

        $mailSent = Util::sendSystemMail([
            'type' => 'item',
            'name' => $itemObject->name,
            'thePartNumber' => 'Part Number',
            'partNumber' => $itemObject->part_number,
            'comment' => $request->comment,
            'userEmail' => $this->userData->email,
            'email' => $supplierObject->email,
            'subject' => 'Request For Quotation'
        ], "request_for_quotation");

        if(!$mailSent) {
            $output->msg = 'SENDINGERROR';
            return $output;
        }


        return $output;
    }



    public function getUserData(Request $request)
    {
        $output = new \stdClass;

        $output->user = $this->userData;

        return $output;
    }

    public function RequestPremium(Request $request)
    {
        $output = new \stdClass;

        if(RequestPremium::whereUserId($this->userData->id)->first())
        {
            $output->msg = 'ALREADYREQUEST';
            return $output;
        }

        $added = RequestPremium::RequestToBePremium($this->userData->id);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getBrandsBySystem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'systemId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        if(!$this->userData->premium)
        {
            $output->msg = 'DISALLOWEDACTION';
            return $output;
        }

        $output->brands = Brands::getBrandsBySystem($request->systemId);

        return $output;
    }

    public function getSuppliersByBrandAndSystem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'systemId' => 'required',
            'brandId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->suppliers = Suppliers::getSuppliersBySystemAndBrand($request->systemId,$request->brandId);

        return $output;
    }

    public function contactUs(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'name' => 'required',
            'phone' => 'required',
            'email' => 'required',
            'message' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            $output->parameters = $validator->messages();
            return $output;
        }

        $mailSent = Util::sendSystemMail([
            'message' => $request->message,
            'name' => $request->name,
            'phone' => $request->phone,
            'userEmail' => $request->email,
            'email' => '',
            'subject' => 'ContactUs'
        ], "contact_us");

        if(!$mailSent) {
            $output->msg = 'SENDINGERROR';
            return $output;
        }


        return $output;
    }

}
