<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 3/5/2019
 * Time: 11:23 AM
 */

namespace App\Http\Controllers;

use App\Service;
use App\SystemMessage;
use App\User as User;
use App\Admins;
use App\Util;
use App\mainCategory;
use App\Areas;
use App\Fields;
use App\Items;
use App\Suppliers;
use App\SubCategory;
use App\SubSubCategory;
use App\Brands;
use App\Requests;
use App\Systems;
use Illuminate\Http\Request;
use Carbon\Carbon;

class SupplierController extends Controller
{
    private $ignoreVerifyAccess = array('login','register','getAreas','getFields');
    private $requestVerifyAccess = array('addRequest','uploadAttachmentArray'
    ,'uploadAttachmentSingle','getBrands','getSystemsByBrand','addBrandAndSystemForSupplier'
    ,'getSystemsAssignedToSupplier','deleteSystemsAssignedToSupplier','addItem','updateItem'
    ,'updateItemStatus','getSupplierData','getItemBySupplierSystem','updateSupplierData'
    );

    private $supplierData;

    public function InternalDispatcher(Request $request, $requestedAPI = null)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), ['requestedAPI' => 'required']);
        $internalRequest = $requestedAPI ? $requestedAPI : $request->get('requestedAPI');

        if (!$internalRequest) {
            $output->msg = 'NOENDPOINT';
            $this->returnOutput($output);
        }
        try {
            \DB::connection()->getPdo()->beginTransaction();
            $output->msg = $this->verifyAccess($request);
            if ($output->msg == 'SUCCESS')
                $output = call_user_func([$this, $internalRequest], $request);
            \DB::connection()->getPdo()->commit();
            return $this->returnOutput($output);
        } catch (\PDOException $e) {
            \DB::connection()->getPdo()->rollBack();
            $output->msg = 'UNKNOWNERROR';
            $this->returnOutput($output);
        }
    }

    private function verifyAccess(Request $request)
    {
        if (in_array($request->requestedAPI, $this->ignoreVerifyAccess))
            return 'SUCCESS';
        if (!in_array($request->requestedAPI, $this->requestVerifyAccess))
            return 'UNAUTHORIZEDREQUEST';
        if (!$request->has('token'))
            return 'NOTOKEN';
        $this->supplierData = Suppliers::whereToken($request->token)->first();
        if (!$this->supplierData)
            return 'TOKENEXPIRED';
        return 'SUCCESS';
    }

    private function returnOutput(\stdClass $output)
    {
        if (empty($output->msg))
            $output->msg = 'SUCCESS';
        $system_message = SystemMessage::whereMsg($output->msg)->first();
        if ($system_message === null) {
            $output->code = '404';
            $output->message = 'Unknown error';
        } else {
            $output->code = $system_message->code;
            $output->message = $system_message->message;
        }

        return response()->json($output);
    }

    private function login(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), ['userName' => 'required', 'password' => 'required']);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $token = Suppliers::verifyPassword($request['userName'], $request['password']);
        if (in_array($token, ['WRONGCREDENTIALS', 'INACTIVEUSER', 'UNREGISTEREDEMAIL'])) {
            $output->msg = $token;

            return $output;
        }
        $output->token = $token;
        return $output;
    }

    public function register(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'userName' => 'required',
            'password' => 'required',
            'firstName' => 'required',
            'lastName' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'fax' => '',
            'companyName' => 'required',
            'areaId' => 'required',
            'fieldId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $checkIfUserNameExist = Suppliers::getSupplierByUserName($request['userName']);
        if(!$checkIfUserNameExist)
        {
            $isInserted = Suppliers::createSupplier($request);

            if(!$isInserted)
            {
                $output->msg = 'INVALIDPARAMETER';
                return $output;
            }
            /*$output->mailSent = Util::sendSystemMail([
                'name' => $request->admin_name,
                'password' =>$request->admin_password,
                'email' =>$request->admin_email,
                'subject' => 'Welcome Email'
            ],"Welcome_mail");*/
        } else {
            $output->msg = 'DUPLICATEDEMAIL';
            return $output;
        }

        return $output;
    }

    public function addRequest(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'request' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = Requests::addRequest($this->supplierData->id,$request->request);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    private function uploadAttachmentArray(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'path' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $index = 0;
        $output->attachment = [];

        $attachments = $request->attachment;
        foreach ($request->attachment as $file) {
            $result = Util::uploadImg($request, 'attachment'
                , 'uploads/'.$request->path,$index);
            if ($result->msg != "SUCCESS") {
                $output->msg = $result->msg;
                return $output;
            }
            array_push($output->attachment,$result->file_name);
            $index++;
        }
        return $output;
    }

    private function uploadAttachmentSingle(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'path' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $result = Util::uploadImg2($request, 'attachment'
            , 'uploads/'.$request->path);
        if ($result->msg != "SUCCESS") {
            $output->msg = $result->msg;
            return $output;
        }
        $output->attachment=$result->file_name;
        $output->attachmentLink='http://'.$_SERVER["SERVER_NAME"].'/uploads/'.$request->path.'/'.$result->file_name;
        return $output;
    }

    public function getBrands(Request $request)
    {
        $output = new \stdClass;

        $output->brands = Brands::getAllBrands();

        return $output;
    }

    public function getSystemsByBrand(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'brandId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->systems = Systems::getSystemsByBrand($request->brandId,$this->supplierData->id);

        return $output;
    }

    public function addBrandAndSystemForSupplier(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'brandId' => 'required',
            'systemId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $added = Suppliers::addBrandsAndSystemsForSupplier($request->brandId
            ,$request->systemId,$this->supplierData->id);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getSystemsAssignedToSupplier(Request $request)
    {
        $output = new \stdClass;

        $output->systems = Systems::getSystemsAssignedToSupplier($this->supplierData->id);

        return $output;
    }

    public function deleteSystemsAssignedToSupplier(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierSystemId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $deleted = Suppliers::deleteSystemsAssignedToSupplier($request->supplierSystemId);

        if(!$deleted)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function addItem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'name' => 'required',
            'description' => 'required',
            'partNumber' => 'required',
            'image' => 'required',
            'pdfLink' => 'required',
            'supplierSystemId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $added = Items::addItemForSupplier($request->name,$request->description,$request->partNumber
            ,$request->image,$request->pdfLink,$request->supplierSystemId);

        if(!$added)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateItem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'itemId' => 'required',
            'name' => 'required',
            'description' => 'required',
            'partNumber' => 'required',
            'image' => 'required',
            'pdfLink' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $updated = Items::updateItem($request->name,$request->description
            ,$request->partNumber,$request->image,$request->pdfLink,$request->itemId);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function updateItemStatus(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'itemId' => 'required',
            'status' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $deleted = Items::updateItemStatus($request->itemId,$request->status);

        if(!$deleted)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getItemBySupplierSystem(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'supplierSystemId' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }

        $output->items = Items::getItemBySupplierSystemIdForSupplier($request->supplierSystemId);

        return $output;
    }

    public function getSupplierData(Request $request)
    {
        $output = new \stdClass;

        $output->supplier = Suppliers::getSupplierData($this->supplierData->id);

        return $output;
    }

    public function updateSupplierData(Request $request)
    {
        $output = new \stdClass;
        $validator = \Validator::make($request->all(), [
            'firstName' => 'required',
            'lastName' => 'required',
            'companyName' => 'required',
            'userName' => 'required',
            'password' => 'required',
            'email' => 'required',
            'phone' => 'required',
            'logo' => 'required',
            'description' => 'required',
            'address' => 'required',
            'fax' => 'required',
            'areaId' => 'required',
            'fieldId' => 'required',
            'pdfLink' => 'required',
            'banner' => 'required'
        ]);
        if ($validator->fails()) {
            $output->msg = 'MISSINGPARAMETER';
            return $output;
        }
        $updated = Suppliers::updateSupplier($request,$this->supplierData->id);

        if(!$updated)
        {
            $output->msg = 'INVALIDPARAMETER';
            return $output;
        }

        return $output;
    }

    public function getAreas(Request $request)
    {
        $output = new \stdClass;

        $output->areas = Areas::getAllAreas();

        return $output;
    }

    public function getFields(Request $request)
    {
        $output = new \stdClass;

        $output->fields = Fields::getAllFields();

        return $output;
    }
}