<?php

namespace App\Http\Middleware;

use Closure;
use Faker\Provider\bn_BD\Company;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;

class DomainMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $company = $request->route('company');
        if (!\App\Company::checkDomainExists($company))
            return view('login-using-company');
        if (!\Session::has('company') || (\Session::has('company') && \Session::get('company') != $company)) {
            \Session::put('company', $company);
            \Session::save();
        }
        return $next($request);
    }
}
