<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 1/18/2019
 * Time: 6:21 PM
 */

namespace App;

use Illuminate\Database\Eloquent\Model;

class Items extends model
{
    protected $table = 'items';

    public static function getItemsBySystemAndSupplier($systemId,$brandId,$supplierId)
    {
        $brandSystemId = self::getBrandSystemId($brandId,$systemId);

        $supplierSystemId = self::getSupplierBrandSystemId($brandSystemId,$supplierId);

        return \DB::table('items as i')
            ->select([
                'i.id',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",i.image) AS image'),
                'i.name as item_name',
                'i.description',
                'i.part_number',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",i.pdf_link) AS pdf_link')
            ])
            ->where('i.supplier_system_id','=',$supplierSystemId)
            ->whereNull('i.deleted_at')
            ->get();
    }

    public static function getItemsBySystemAndSupplierForAdmin($systemId,$brandId,$supplierId)
    {
        $brandSystemId = self::getBrandSystemId($brandId,$systemId);

        $supplierSystemId = self::getSupplierBrandSystemId($brandSystemId,$supplierId);

        return \DB::table('items as i')
            ->select([
                'i.id',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",i.image) AS image'),
                'i.name as item_name',
                'i.description',
                'i.part_number',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",i.pdf_link) AS pdf_link'),
                \DB::raw('CASE WHEN i.deleted_at IS NULL THEN TRUE ELSE FALSE END AS active')
            ])
            ->where('i.supplier_system_id','=',$supplierSystemId)
            ->get();
    }

    public static function addItemForAdmin($name,$desc,$partNumber,$image,$pdfLink
        ,$supplierId,$brandId,$systemId)
    {
        $brandSystemId = self::getBrandSystemId($brandId,$systemId);

        $supplierSystemId = self::getSupplierBrandSystemId($brandSystemId,$supplierId);

        return \DB::table('items')
            ->insert(['name' => $name , 'description' => $desc, 'part_number' => $partNumber
                , 'image'=> env('itemImagePath').$image
                , 'supplier_system_id'=> $supplierSystemId
                , 'pdf_link'=> env('itemPDFPath').$pdfLink]);
    }

    public static function addItemForSupplier($name,$desc,$partNumber,$image,$pdfLink
        ,$supplierSystemId)
    {

        return \DB::table('items')
            ->insert(['name' => $name , 'description' => $desc, 'part_number' => $partNumber
                , 'image'=> env('itemImagePath').$image
                , 'supplier_system_id'=> $supplierSystemId
                , 'pdf_link'=> env('itemPDFPath').$pdfLink]);
    }

    public static function updateItem($name,$desc,$partNumber,$image,$pdfLink,$itemId)
    {
        $item = self::whereId($itemId)->first();

        $canDelete = true;
        if(basename($item->image) != basename($image))
        {
            $canDelete = Util::deleteFile($item->image);
        }

        if(basename($item->pdf_link) != basename($pdfLink))
        {
            $canDelete = Util::deleteFile($item->pdf_link);
        }
        if($canDelete) {
            return \DB::table('items')
                ->where('id', '=', $itemId)
                ->update(['name' => $name, 'description' => $desc, 'part_number' => $partNumber
                    , 'image' => env('itemImagePath') . basename($image)
                    , 'pdf_link' => env('itemPDFPath') . basename($pdfLink)]);
        } else {
            return false;
        }
    }

    public static function updateItemStatus($itemId,$status)
    {
        return \DB::table('items')
            ->where('id', '=', $itemId)
            ->update(['deleted_at' => $status == true ? null : date('Y-m-d')]);
    }

    public static function  getBrandSystemId($brandId,$systemId)
    {
        return \DB::selectOne("SELECT id FROM brand_systems WHERE brand_id=? AND system_id=?"
            , [$brandId,$systemId])->id;
    }

    public static function  getSupplierBrandSystemId($brandSystemId,$supplierId)
    {
        return \DB::selectOne("SELECT id FROM supplier_system WHERE brand_system_id=? AND supplier_id=?"
            , [$brandSystemId, $supplierId])->id;
    }

    public static function getItemBySupplierSystemIdForSupplier($supplierSystemId)
    {
        return \DB::table('items as i')
            ->select([
                'i.id',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",i.image) AS image'),
                'i.name as item_name',
                'i.description',
                'i.part_number',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",i.pdf_link) AS pdf_link'),
                \DB::raw('CASE WHEN i.deleted_at IS NULL THEN TRUE ELSE FALSE END AS active')
            ])
            ->where('i.supplier_system_id','=',$supplierSystemId)
            ->get();
    }

    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('items')
            ->select([
                '*'
            ])
            ->where('id', '=', $id)
            ->whereNull('deleted_at');
    }

    public static function wherePartNumber($partNumber)
    {
        return \DB::table('items')
            ->select([
                '*'
            ])
            ->where('part_number', '=', $partNumber)
            ->whereNull('deleted_at');
    }

    public static function whereSupplierSystemId($supplierSystemId)
    {
        return \DB::table('items')
            ->select([
                '*'
            ])
            ->where('supplier_system_id', '=', $supplierSystemId)
            ->whereNull('deleted_at');
    }

    //</editor-fold>
}