<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class RequestPremium extends Model
{
    public static function getRequestedPremiumUsers()
    {
        return \DB::table('request_premium')
            ->select([
                '*'
            ])
            ->join('users as u', 'request_premium.user_id', '=', 'u.id')
            ->get();
    }

    public static function RequestToBePremium($userId)
    {
        return \DB::table('request_premium')->insert([
            'user_id' => $userId
        ]);
    }

    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('request_premium')
            ->select([
                '*'
            ])
            ->where('id', '=', $id);
    }

    public static function whereUserId($userId)
    {
        return \DB::table('request_premium')
            ->select([
                '*'
            ])
            ->where('user_id', '=', $userId);
    }

    //</editor-fold>
}
