<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 3/16/2019
 * Time: 12:17 PM
 */

namespace App;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;


class Requests extends Model
{
    protected $table = 'request';

    public static function addRequest($supplierId,$request)
    {
        return \DB::table('request')
            ->insert(['supplier_id' => $supplierId, 'request' => $request]);
    }

    public static function getAllRequests()
    {
        return \DB::table('request as r')
            ->select([
                'r.id',
                's.companyName',
                'r.request'
            ])
            ->join('suppliers as s', 's.id', '=', 'r.supplier_id')
            ->get();
    }

    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('request')
            ->select([
                '*'
            ])
            ->where('id', '=', $id);
    }

    public static function whereSupplierId($supplierId)
    {
        return \DB::table('request')
            ->select([
                '*'
            ])
            ->where('supplier_id', '=', $supplierId);
    }

    //</editor-fold>

}