<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 1/18/2019
 * Time: 6:41 PM
 */

namespace App;

use Illuminate\Database\Eloquent\Model;


class SubCategory extends model
{
    protected $table = 'sub_category';

    public static function getAllSubCategories($mainCategoryId)
    {
        return \DB::table('sub_category')
            ->select([
                'id',
                'name',
                'created_at'
            ])
            ->where('main_category_id','=',$mainCategoryId)
            ->get();
    }

    public static function addSubCategory($mainCategoryId,$name)
    {
        return \DB::table('sub_category')
            ->insert(['main_category_id' => $mainCategoryId, 'name' => $name]);
    }

    public static function updateSubCategory($subCategoryId,$mainCategoryId,$name)
    {
        return \DB::table('sub_category')
            ->where('id', '=', $subCategoryId)
            ->update(['main_category_id' => $mainCategoryId
                , 'name' => $name]);
    }

    public static function deleteSubCategory($subCategoryId)
    {
        return \DB::table('sub_category')
            ->where('id', '=', $subCategoryId)
            ->delete();
    }

    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('sub_category')
            ->select([
                '*'
            ])
            ->where('id', '=', $id);
    }

    public static function whereName($subCategory)
    {
        return \DB::table('sub_category')
            ->select([
                '*'
            ])
            ->where('name', '=', $subCategory);
    }

    public static function whereMainCategoryId($mainCategoryId)
    {
        return \DB::table('sub_category')
            ->select([
                '*'
            ])
            ->where('main_category_id', '=', $mainCategoryId);
    }

    //</editor-fold>
}