<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 2/1/2019
 * Time: 9:03 PM
 */

namespace App;

use Illuminate\Database\Eloquent\Model;

class SubSubCategory extends model
{
    protected $table = 'sub_sub_category';

    public static function getAllSubSubCategories($subCategoryId)
    {
        return \DB::table('sub_sub_category')
            ->select([
                'id',
                'name',
                'created_at'
            ])
            ->where('sub_category_id','=',$subCategoryId)
            ->get();
    }

    public static function addSubSubCategory($subCategoryId,$name)
    {
        return \DB::table('sub_sub_category')
            ->insert(['sub_category_id' => $subCategoryId, 'name' => $name]);
    }

    public static function updateSubSubCategory($subSubCategoryId,$subCategoryId,$name)
    {
        return \DB::table('sub_sub_category')
            ->where('id', '=', $subSubCategoryId)
            ->update(['sub_category_id' => $subCategoryId
                , 'name' => $name]);
    }

    public static function deleteSubSubCategory($subSubCategoryId)
    {
        return \DB::table('sub_sub_category')
            ->where('id', '=', $subSubCategoryId)
            ->delete();
    }

    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('sub_sub_category')
            ->select([
                '*'
            ])
            ->where('id', '=', $id);
    }

    public static function whereName($subCategory)
    {
        return \DB::table('sub_sub_category')
            ->select([
                '*'
            ])
            ->where('name', '=', $subCategory);
    }

    public static function whereSubCategoryId($subCategoryId)
    {
        return \DB::table('sub_sub_category')
            ->select([
                '*'
            ])
            ->where('sub_category_id', '=', $subCategoryId);
    }

    //</editor-fold>
}