<?php
/**
 * Created by PhpStorm.
 * User: foda
 * Date: 2/12/2019
 * Time: 8:34 PM
 */

namespace App;

use Illuminate\Database\Eloquent\Model;

class Systems extends model
{
    protected $table = 'systems';

    public static function getSystemsByBrandForSupplier($brandId,$supplierId)
    {
        $systems = \DB::table('systems as s')
            ->select([
                's.id',
                'bs.brand_id',
                's.name',
                's.description',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",s.catalog) AS catalog')
            ])
            ->join('brand_systems as bs', 'bs.system_id', '=', 's.id')
            ->join('supplier_system as ss', 'ss.brand_system_id', '=', 'bs.id')
            ->where('bs.brand_id','=',$brandId)
            ->where('ss.supplier_id','=',$supplierId)
            ->get();

        $output = [];
        foreach ($systems as $system) {
            $system->items = Items::getItemsBySystemAndSupplier($system->id,$system->brand_id,$supplierId);
            $output[] = $system;
        }

        return $output;
    }

    public static function getSystemsByBrandForSupplierForAdmin($brandId,$supplierId)
    {
        $systems = \DB::table('systems as s')
            ->select([
                's.id',
                'bs.brand_id',
                's.name',
                's.description',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",s.catalog) AS catalog')
            ])
            ->join('brand_systems as bs', 'bs.system_id', '=', 's.id')
            ->join('supplier_system as ss', 'ss.brand_system_id', '=', 'bs.id')
            ->where('bs.brand_id','=',$brandId)
            ->where('ss.supplier_id','=',$supplierId)
            ->get();

        $output = [];
        foreach ($systems as $system) {
            $system->items = Items::getItemsBySystemAndSupplierForAdmin($system->id,$system->brand_id,$supplierId);
            $output[] = $system;
        }

        return $output;
    }

    public static function getSystemsByBrand($brandId,$supplierId)
    {
        return \DB::table('systems as s')
            ->select([
                's.id',
                's.name',
                'ssc.name as sub_sub_category_name',
                'sc.name as sub_category_name',
                'mc.name as main_category_name',
                \DB::raw('(select count(id) as countId from supplier_system where supplier_id = '.$supplierId.'
                and brand_system_id = bs.id) as added')
            ])
            ->join('brand_systems as bs', 'bs.system_id', '=', 's.id')
            ->join('sub_sub_category as ssc', 's.sub_sub_category_id', '=', 'ssc.id')
            ->join('sub_category as sc', 'ssc.sub_category_id', '=', 'sc.id')
            ->join('main_category as mc', 'sc.main_category_id', '=', 'mc.id')
            ->where('bs.brand_id','=',$brandId)
            ->get();
    }

    public static function getSystemsAssignedToSupplier($supplierId)
    {
        return \DB::table('systems as s')
            ->select([
                'ss.id',
                's.name',
                'b.name as brand_name',
                'ssc.name as sub_sub_category_name',
                'sc.name as sub_category_name',
                'mc.name as main_category_name'
            ])
            ->join('brand_systems as bs', 'bs.system_id', '=', 's.id')
            ->join('brands as b', 'bs.brand_id', '=', 'b.id')
            ->join('supplier_system as ss', 'ss.brand_system_id', '=', 'bs.id')
            ->join('sub_sub_category as ssc', 's.sub_sub_category_id', '=', 'ssc.id')
            ->join('sub_category as sc', 'ssc.sub_category_id', '=', 'sc.id')
            ->join('main_category as mc', 'sc.main_category_id', '=', 'mc.id')
            ->where('ss.supplier_id','=',$supplierId)
            ->get();
    }

    public static function getAllSystemsForSupplier($supplierId)
    {
        $systems = \DB::table('systems as s')
            ->select([
                's.id',
                'bs.brand_id',
                's.name',
                's.description',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",s.catalog) AS catalog')
            ])
            ->join('brand_systems as bs', 'bs.system_id', '=', 's.id')
            ->join('supplier_system as ss', 'ss.brand_system_id', '=', 'bs.id')
            ->where('ss.supplier_id','=',$supplierId)
            ->get();

        $output = [];
        foreach ($systems as $system) {
            $system->items = Items::getItemsBySystemAndSupplier($system->id,$system->brand_id,$supplierId);
            $output[] = $system;
        }
        return $output;
    }

    public static function getAllSystemsForSupplierForAdmin($supplierId)
    {
        $systems = \DB::table('systems as s')
            ->select([
                's.id',
                'bs.brand_id',
                's.name',
                's.description',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",s.catalog) AS catalog')
            ])
            ->join('brand_systems as bs', 'bs.system_id', '=', 's.id')
            ->join('supplier_system as ss', 'ss.brand_system_id', '=', 'bs.id')
            ->where('ss.supplier_id','=',$supplierId)
            ->get();

        $output = [];
        foreach ($systems as $system) {
            $system->items = Items::getItemsBySystemAndSupplierForAdmin($system->id,$system->brand_id,$supplierId);
            $output[] = $system;
        }
        return $output;
    }

    public static function addSystem($name,$desc,$subSubCategoryId,$catalog)
    {
        return \DB::table('systems')
            ->insert(['name' => $name , 'description' => $desc, 'sub_sub_category_id' => $subSubCategoryId
                , 'catalog'=> env('systemCatalogPath').$catalog]);
    }

    public static function updateSystem($name,$desc,$subSubCategoryId,$catalog,$systemId)
    {
        $system = self::whereId($systemId)->first();

        if((basename($system->catalog) != basename($catalog))) {

            if (Util::deleteFile($system->catalog)) {
                return \DB::table('systems')
                    ->where('id', '=', $systemId)
                    ->update(['name' => $name , 'description' => $desc, 'sub_sub_category_id' => $subSubCategoryId
                        , 'catalog'=> env('systemCatalogPath').basename($catalog)]);
            } else {
                return false;
            }
        } else {
            return \DB::table('systems')
                ->where('id', '=', $systemId)
                ->update(['name' => $name , 'description' => $desc, 'sub_sub_category_id' => $subSubCategoryId
                    , 'catalog'=> env('systemCatalogPath').basename($catalog)]);
        }
    }

    public static function deleteSystem($systemId)
    {
        $system = self::whereId($systemId)->first();
        if (Util::deleteFile($system->catalog)) {
            return \DB::table('systems')
                ->where('id', '=', $systemId)
                ->delete();
        } else {
            return false;
        }

    }

    public static function getAllSystems()
    {
        return \DB::table('systems as s')
            ->select([
                's.id',
                's.name',
                's.description',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",s.catalog) AS catalog')
            ])
            ->get();
    }

    public static function getSystemsIdsForBrand($brandId)
    {
        return \DB::table('systems as s')
            ->select([
                's.id'
            ])
            ->join('brand_systems as bs', 'bs.system_id', '=', 's.id')
            ->where('bs.brand_id','=',$brandId)
            ->lists('s.id');
    }

    public static function getSystemsBySubSubCategory($subSubCategoryId)
    {
        return \DB::table('systems as s')
            ->select([
                's.id',
                's.name',
                's.description',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",s.catalog) AS catalog')
            ])
            ->where('sub_sub_category_id', '=', $subSubCategoryId)
            ->get();
    }

    public static function getSystemsByBrandForAdmin($brandId)
    {
        return \DB::table('systems as s')
            ->select([
                's.id',
                's.name',
                's.description',
                \DB::raw('CONCAT("http://'.$_SERVER["SERVER_NAME"].'/",s.catalog) AS catalog')
            ])
            ->join('brand_systems as bs', 'bs.system_id', '=', 's.id')
            ->where('bs.brand_id','=',$brandId)
            ->get();
    }

    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('systems')
            ->select([
                '*'
            ])
            ->where('id', '=', $id);
    }

    public static function whereName($name)
    {
        return \DB::table('systems')
            ->select([
                '*'
            ])
            ->where('name', '=', $name);
    }

    public static function whereSubSubCategoryId($subSubCategoryId)
    {
        return \DB::table('systems')
            ->select([
                '*'
            ])
            ->where('sub_sub_category_id', '=', $subSubCategoryId);
    }

    //</editor-fold>
}