<?php
/**
 * Created by PhpStorm.
 * User: Saruti
 * Date: 10/22/2015
 * Time: 12:53 PM
 */
namespace App\Templater;

use Illuminate\Database\Eloquent\Model as Model;
use Illuminate\Support\Str;
use File as File;

/**
 * Class Templater
 * @package App
 */
class Templater extends StorageManager
{
    /**
     * @var array
     */
    public $attributes;
    /**
     * @string Model
     */
    private $model;


    /**
     * @param string $model
     */
    public function __construct($model)
    {
        parent::__construct();
        $this->model = $model;
    }

    /**
     * @param $operation
     * @param null $action
     * @return mixed
     */
    public function render($operation, $action = null, array $specific = null)
    {
        $template = $this->template(null, null, $specific);
        ($action) ? $template->action = $action : '#';
        switch ($operation) {
            case 'create' || 0:
                return view('templater.create')->withTemplate($template);
                break;
            case 'edit' || 1:
                return view('templater.edit')->withTemplate($template);
                break;
            case 'show' || 2:
                return view('templater.show')->withTemplate($template);
                break;
        }
    }

    public function renderExcept($operation, array $excluded, $action = null, array $specific = null)
    {
        $template = $this->template('except', $excluded, $specific);
        ($action) ? $template->action = $action : '#';
        switch ($operation) {
            case 'create' || 0:
                return view('templater.create')->withTemplate($template);
                break;
            case 'edit' || 1:
                return view('templater.edit')->withTemplate($template);
                break;
            case 'show' || 2:
                return view('templater.show')->withTemplate($template);
                break;
        }
    }

    public function renderOnly($operation, array $included, $action = null, array $specific = null)
    {
        $template = $this->template('only', $included, $specific);
        ($action) ? $template->action = $action : '#';
        switch ($operation) {
            case 'create' || 0:
                return view('templater.create')->withTemplate($template);
                break;
            case 'edit' || 1:
                return view('templater.edit')->withTemplate($template);
                break;
            case 'show' || 2:
                return view('templater.show')->withTemplate($template);
                break;
        }
    }

    private function template($array_operation = null, array $extra_array = null, array $specific = null)
    {
        $template = $this->getModel($this->model);
        $template->properties = (array)$template->properties;
        switch ($array_operation) {
            case 'only':
                $template->properties = array_intersect($template->properties, $extra_array);
                break;
            case 'except':
                $template->properties = array_diff($template->properties, $extra_array);
                break;
            case null:
                break;
        }
//       dd($template);
//        dd($specific);
        if($specific != null)
        foreach ($specific as $key => $value) {
//            dd($value);
            $template->properties[$key]->type = $value['type'];
            $template->properties[$key]->extras = $value['extras'];
        }
        $template->properties = array_except($template->properties, ['id', 'created_at', 'updated_at']);
//        $template->properties
        $template->action = "#";
        $template->method = 'post';
        return $template;
    }
}