<?php
/**
 * Copyright (c) 2016.
 * This file is part of Islam Al-Rayan work, NgageU Company.
 * Don't forget you need to run the following SQL to set the privileges correctly.
 * INSERT INTO `hrflo`.`roles` (`id`, `name`) VALUES (NULL, 'Employee'), (NULL, 'HRAdmin'), (NULL, 'CompanyAdmin'), (NULL, 'SuperAdmin');
 */

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

/**
 * App\users
 *
 * @property integer $id
 * @property string $firstName
 * @property string $lastName
 * @property string $email
 * @property string $phone
 * @property string $fax
 * @property string $companyName
 * @property integer $area_id
 * @property integer $field_id
 * @property string $userName
 * @property string $password
 * @property string $token
 * @property \Carbon\Carbon $created_at
 */

class User extends Model
{
    use SoftDeletes;

    protected $fillable = ['id','userName','password','email','firstName'
        ,'lastName','email','phone','fax','companyName','area_id','field_id','status','token'
        ,'created_at'];
    protected $table = 'users';

    public static function verifyPassword($userName, $password)
    {
        $userData = \DB::selectOne("SELECT id,status FROM users WHERE userName=? AND password=?", [$userName,$password]);

        if (!$userData)
            return 'WRONGCREDENTIALS';

        if ($userData->status != "Active")
            return 'INACTIVEUSER';

        $token = sha1($userData->id . Str::random(20));
        \DB::update("UPDATE users SET token=? WHERE id=?", [$token, $userData->id]);
        return $token;
    }

    public static function createUser($request)
    {
        return \DB::table('users')->insert([
            'userName' => $request['userName'],
            'password' => $request['password'],
            'firstName' => $request['firstName'],
            'lastName' => $request['lastName'],
            'email' => $request['email'],
            'phone' => $request['phone'],
            'fax' => $request['fax'],
            'companyName' => $request['companyName'],
            'area_id' => $request['areaId'],
            'field_id' => $request['fieldId'],
            'status' => 'Active'
        ]);
    }

    public static function updateUserData($request,$userId)
    {
        return \DB::table('users')
            ->where('id', '=', $userId)
            ->update([
                'userName' => $request['userName'],
                'password' => $request['password'],
                'firstName' => $request['firstName'],
                'lastName' => $request['lastName'],
                'email' => $request['email'],
                'phone' => $request['phone'],
                'fax' => $request['fax'],
                'companyName' => $request['companyName'],
                'area_id' => $request['areaId'],
                'field_id' => $request['fieldId']
            ]);
    }

    public static function updateUserStatus($status,$userId)
    {
        return \DB::table('users')
            ->where('id', '=', $userId)
            ->update([
                'status' => $status == true ? 'Active' : 'Deactivate'
            ]);
    }

    public static function updateUserPremium($premium, $userId)
    {
        \DB::table('request_premium')
            ->where('user_id', '=', $userId)
            ->delete();

        return \DB::table('users')
            ->where('id', '=', $userId)
            ->update([
                'premium' => $premium
            ]);
    }

    public static function getUsers()
    {
        return \DB::table('users')
            ->select([
                '*'
            ])
            ->get();
    }


    //<editor-fold defaultstate="collapsed" desc="table structure">

    public static function whereId($id)
    {
        return \DB::table('users')
            ->select([
                '*'
            ])
            ->where('id', '=', $id);
    }

    public static function whereUserName($userName)
    {
        return \DB::table('users')
            ->select([
                '*'
            ])
            ->where('userName', '=', $userName);
    }

    public static function whereToken($token)
    {
        return \DB::table('users')
            ->select([
                '*'
            ])
            ->where('token', '=', $token);
    }

    //</editor-fold>
}
