<?php
namespace App;

/**
 * Created by PhpStorm.
 * User: Ryan
 * Date: 9/1/2015
 * Time: 12:56 AM
 */
use Carbon\Carbon;
use Illuminate\Mail\Message;
use Illuminate\Support\Facades\URL;
use Psy\Util\Str;

class crumb
{
    public $name;
    public $uri;

    /**
     * crumb constructor.
     */
    public function __construct($name, $action, $params = null)
    {
        $this->name = $name;
        $this->uri = action($action, $params);
    }
}

class Util
{

    private $countries = [
        'AF' => 'Afghanistan'
        , 'AX' => '�land Islands'
        , 'AL' => 'Albania'
        , 'DZ' => 'Algeria'
        , 'AS' => 'American Samoa'
        , 'AD' => 'Andorra'
        , 'AO' => 'Angola'
        , 'AI' => 'Anguilla'
        , 'AQ' => 'Antarctica'
        , 'AG' => 'Antigua and Barbuda'
        , 'AR' => 'Argentina'
        , 'AM' => 'Armenia'
        , 'AW' => 'Aruba'
        , 'AU' => 'Australia'
        , 'AT' => 'Austria'
        , 'AZ' => 'Azerbaijan'
        , 'BS' => 'Bahamas'
        , 'BH' => 'Bahrain'
        , 'BD' => 'Bangladesh'
        , 'BB' => 'Barbados'
        , 'BY' => 'Belarus'
        , 'BE' => 'Belgium'
        , 'BZ' => 'Belize'
        , 'BJ' => 'Benin'
        , 'BM' => 'Bermuda'
        , 'BT' => 'Bhutan'
        , 'BO' => 'Bolivia, Plurinational State of'
        , 'BQ' => 'Bonaire, Sint Eustatius and Saba'
        , 'BA' => 'Bosnia and Herzegovina'
        , 'BW' => 'Botswana'
        , 'BV' => 'Bouvet Island'
        , 'BR' => 'Brazil'
        , 'IO' => 'British Indian Ocean Territory'
        , 'BN' => 'Brunei Darussalam'
        , 'BG' => 'Bulgaria'
        , 'BF' => 'Burkina Faso'
        , 'BI' => 'Burundi'
        , 'KH' => 'Cambodia'
        , 'CM' => 'Cameroon'
        , 'CA' => 'Canada'
        , 'CV' => 'Cape Verde'
        , 'KY' => 'Cayman Islands'
        , 'CF' => 'Central African Republic'
        , 'TD' => 'Chad'
        , 'CL' => 'Chile'
        , 'CN' => 'China'
        , 'CX' => 'Christmas Island'
        , 'CC' => 'Cocos (Keeling) Islands'
        , 'CO' => 'Colombia'
        , 'KM' => 'Comoros'
        , 'CG' => 'Congo'
        , 'CD' => 'Congo, the Democratic Republic of the'
        , 'CK' => 'Cook Islands'
        , 'CR' => 'Costa Rica'
        , 'CI' => 'C�te d\'Ivoire'
        , 'HR' => 'Croatia'
        , 'CU' => 'Cuba'
        , 'CW' => 'Cura�ao'
        , 'CY' => 'Cyprus'
        , 'CZ' => 'Czech Republic'
        , 'DK' => 'Denmark'
        , 'DJ' => 'Djibouti'
        , 'DM' => 'Dominica'
        , 'DO' => 'Dominican Republic'
        , 'EC' => 'Ecuador'
        , 'EG' => 'Egypt'
        , 'SV' => 'El Salvador'
        , 'GQ' => 'Equatorial Guinea'
        , 'ER' => 'Eritrea'
        , 'EE' => 'Estonia'
        , 'ET' => 'Ethiopia'
        , 'FK' => 'Falkland Islands (Malvinas)'
        , 'FO' => 'Faroe Islands'
        , 'FJ' => 'Fiji'
        , 'FI' => 'Finland'
        , 'FR' => 'France'
        , 'GF' => 'French Guiana'
        , 'PF' => 'French Polynesia'
        , 'TF' => 'French Southern Territories'
        , 'GA' => 'Gabon'
        , 'GM' => 'Gambia'
        , 'GE' => 'Georgia'
        , 'DE' => 'Germany'
        , 'GH' => 'Ghana'
        , 'GI' => 'Gibraltar'
        , 'GR' => 'Greece'
        , 'GL' => 'Greenland'
        , 'GD' => 'Grenada'
        , 'GP' => 'Guadeloupe'
        , 'GU' => 'Guam'
        , 'GT' => 'Guatemala'
        , 'GG' => 'Guernsey'
        , 'GN' => 'Guinea'
        , 'GW' => 'Guinea-Bissau'
        , 'GY' => 'Guyana'
        , 'HT' => 'Haiti'
        , 'HM' => 'Heard Island and McDonald Islands'
        , 'VA' => 'Holy See (Vatican City State)'
        , 'HN' => 'Honduras'
        , 'HK' => 'Hong Kong'
        , 'HU' => 'Hungary'
        , 'IS' => 'Iceland'
        , 'IN' => 'India'
        , 'ID' => 'Indonesia'
        , 'IR' => 'Iran, Islamic Republic of'
        , 'IQ' => 'Iraq'
        , 'IE' => 'Ireland'
        , 'IM' => 'Isle of Man'
        , 'IL' => 'Israel'
        , 'IT' => 'Italy'
        , 'JM' => 'Jamaica'
        , 'JP' => 'Japan'
        , 'JE' => 'Jersey'
        , 'JO' => 'Jordan'
        , 'KZ' => 'Kazakhstan'
        , 'KE' => 'Kenya'
        , 'KI' => 'Kiribati'
        , 'KP' => 'Korea, Democratic People\'s Republic of'
        , 'KR' => 'Korea, Republic of'
        , 'KW' => 'Kuwait'
        , 'KG' => 'Kyrgyzstan'
        , 'LA' => 'Lao People\'s Democratic Republic'
        , 'LV' => 'Latvia'
        , 'LB' => 'Lebanon'
        , 'LS' => 'Lesotho'
        , 'LR' => 'Liberia'
        , 'LY' => 'Libya'
        , 'LI' => 'Liechtenstein'
        , 'LT' => 'Lithuania'
        , 'LU' => 'Luxembourg'
        , 'MO' => 'Macao'
        , 'MK' => 'Macedonia, the former Yugoslav Republic of'
        , 'MG' => 'Madagascar'
        , 'MW' => 'Malawi'
        , 'MY' => 'Malaysia'
        , 'MV' => 'Maldives'
        , 'ML' => 'Mali'
        , 'MT' => 'Malta'
        , 'MH' => 'Marshall Islands'
        , 'MQ' => 'Martinique'
        , 'MR' => 'Mauritania'
        , 'MU' => 'Mauritius'
        , 'YT' => 'Mayotte'
        , 'MX' => 'Mexico'
        , 'FM' => 'Micronesia, Federated States of'
        , 'MD' => 'Moldova, Republic of'
        , 'MC' => 'Monaco'
        , 'MN' => 'Mongolia'
        , 'ME' => 'Montenegro'
        , 'MS' => 'Montserrat'
        , 'MA' => 'Morocco'
        , 'MZ' => 'Mozambique'
        , 'MM' => 'Myanmar'
        , 'NA' => 'Namibia'
        , 'NR' => 'Nauru'
        , 'NP' => 'Nepal'
        , 'NL' => 'Netherlands'
        , 'NC' => 'New Caledonia'
        , 'NZ' => 'New Zealand'
        , 'NI' => 'Nicaragua'
        , 'NE' => 'Niger'
        , 'NG' => 'Nigeria'
        , 'NU' => 'Niue'
        , 'NF' => 'Norfolk Island'
        , 'MP' => 'Northern Mariana Islands'
        , 'NO' => 'Norway'
        , 'OM' => 'Oman'
        , 'PK' => 'Pakistan'
        , 'PW' => 'Palau'
        , 'PS' => 'Palestinian Territory, Occupied'
        , 'PA' => 'Panama'
        , 'PG' => 'Papua New Guinea'
        , 'PY' => 'Paraguay'
        , 'PE' => 'Peru'
        , 'PH' => 'Philippines'
        , 'PN' => 'Pitcairn'
        , 'PL' => 'Poland'
        , 'PT' => 'Portugal'
        , 'PR' => 'Puerto Rico'
        , 'QA' => 'Qatar'
        , 'RE' => 'R�union'
        , 'RO' => 'Romania'
        , 'RU' => 'Russian Federation'
        , 'RW' => 'Rwanda'
        , 'BL' => 'Saint Barth�lemy'
        , 'SH' => 'Saint Helena, Ascension and Tristan da Cunha'
        , 'KN' => 'Saint Kitts and Nevis'
        , 'LC' => 'Saint Lucia'
        , 'MF' => 'Saint Martin (French part)'
        , 'PM' => 'Saint Pierre and Miquelon'
        , 'VC' => 'Saint Vincent and the Grenadines'
        , 'WS' => 'Samoa'
        , 'SM' => 'San Marino'
        , 'ST' => 'Sao Tome and Principe'
        , 'SA' => 'Saudi Arabia'
        , 'SN' => 'Senegal'
        , 'RS' => 'Serbia'
        , 'SC' => 'Seychelles'
        , 'SL' => 'Sierra Leone'
        , 'SG' => 'Singapore'
        , 'SX' => 'Sint Maarten (Dutch part)'
        , 'SK' => 'Slovakia'
        , 'SI' => 'Slovenia'
        , 'SB' => 'Solomon Islands'
        , 'SO' => 'Somalia'
        , 'ZA' => 'South Africa'
        , 'GS' => 'South Georgia and the South Sandwich Islands'
        , 'SS' => 'South Sudan'
        , 'ES' => 'Spain'
        , 'LK' => 'Sri Lanka'
        , 'SD' => 'Sudan'
        , 'SR' => 'Suriname'
        , 'SJ' => 'Svalbard and Jan Mayen'
        , 'SZ' => 'Swaziland'
        , 'SE' => 'Sweden'
        , 'CH' => 'Switzerland'
        , 'SY' => 'Syrian Arab Republic'
        , 'TW' => 'Taiwan, Province of China'
        , 'TJ' => 'Tajikistan'
        , 'TZ' => 'Tanzania, United Republic of'
        , 'TH' => 'Thailand'
        , 'TL' => 'Timor-Leste'
        , 'TG' => 'Togo'
        , 'TK' => 'Tokelau'
        , 'TO' => 'Tonga'
        , 'TT' => 'Trinidad and Tobago'
        , 'TN' => 'Tunisia'
        , 'TR' => 'Turkey'
        , 'TM' => 'Turkmenistan'
        , 'TC' => 'Turks and Caicos Islands'
        , 'TV' => 'Tuvalu'
        , 'UG' => 'Uganda'
        , 'UA' => 'Ukraine'
        , 'AE' => 'United Arab Emirates'
        , 'GB' => 'United Kingdom'
        , 'US' => 'United States'
        , 'UM' => 'United States Minor Outlying Islands'
        , 'UY' => 'Uruguay'
        , 'UZ' => 'Uzbekistan'
        , 'VU' => 'Vanuatu'
        , 'VE' => 'Venezuela, Bolivarian Republic of'
        , 'VN' => 'Viet Nam'
        , 'VG' => 'Virgin Islands, British'
        , 'VI' => 'Virgin Islands, U.S.'
        , 'WF' => 'Wallis and Futuna'
        , 'EH' => 'Western Sahara'
        , 'YE' => 'Yemen'
        , 'ZM' => 'Zambia'
        , 'ZW' => 'Zimbabwe'
    ];
    private static $currencies = [
        "AFN",
        "DZD",
        "USD",
        "EUR",
        "AOA",
        "XCD",
        "ARP",
        "AMD",
        "AWG",
        "AUD",
        "AZN",
        "BSD",
        "BHD",
        "BDT",
        "BBD",
        "BYR",
        "BZD",
        "XOF",
        "BMD",
        "BTN",
        "BOV",
        "BAM",
        "BWP",
        "NOK",
        "BRL",
        "BND",
        "BGL",
        "BIF",
        "KHR",
        "XAF",
        "CAD",
        "CVE",
        "KYD",
        "CLF",
        "CNY",
        "COU",
        "KMF",
        "CDF",
        "NZD",
        "CRC",
        "HRK",
        "CUP",
        "CZK",
        "CSJ",
        "DKK",
        "DJF",
        "DOP",
        "EGP",
        "EQE",
        "ERN",
        "EEK",
        "ETB",
        "FKP",
        "FJD",
        "FIM",
        "XFO",
        "XPF",
        "GMD",
        "GEL",
        "DDM",
        "GHC",
        "GIP",
        "GRD",
        "GTQ",
        "GNE",
        "GWP",
        "GYD",
        "HNL",
        "HKD",
        "HUF",
        "ISJ",
        "INR",
        "IDR",
        "IRR",
        "ILS",
        "ITL",
        "JMD",
        "JPY",
        "JOD",
        "KZT",
        "KES",
        "KPW",
        "KRW",
        "KWD",
        "KGS",
        "LAJ",
        "LVL",
        "LBP",
        "ZAR",
        "LRD",
        "LYD",
        "CHF",
        "LTL",
        "LUF",
        "MOP",
        "MKN",
        "MGF",
        "MWK",
        "MYR",
        "MVR",
        "MAF",
        "MTL",
        "MRO",
        "MUR",
        "MXV",
        "MDL",
        "MCF",
        "MNT",
        "MAD",
        "MZM",
        "MMK",
        "NPR",
        "NLG",
        "ANG",
        "NIO",
        "NGN",
        "OMR",
        "PKR",
        "PGK",
        "PYG",
        "YDD",
        "PEH",
        "PHP",
        "PLN",
        "TPE",
        "QAR",
        "ROK",
        "RUB",
        "RWF",
        "SHP",
        "WST",
        "STD",
        "SAR",
        "CSD",
        "SCR",
        "SLL",
        "SGD",
        "SKK",
        "SIT",
        "SBD",
        "SOS",
        "ZAL",
        "ESB",
        "LKR",
        "SDG",
        "SRG",
        "SZL",
        "SEK",
        "CHW",
        "SYP",
        "TWD",
        "TJR",
        "TZS",
        "THB",
        "TOP",
        "TTD",
        "TND",
        "TRL",
        "TMM",
        "SUR",
        "UGS",
        "UAK",
        "AED",
        "GBP",
        "USS",
        "UYI",
        "UZS",
        "VUV",
        "VEB",
        "VNC",
        "YER",
        "YUM",
        "ZRZ",
        "ZMK",
        "ZWC",
    ];

    public static function getCurrencies()
    {
        return Util::$currencies;
    }


    public static function uploadImg(\Illuminate\Http\Request $request, $file, $path_from_public,$index)
    {
        $result = new \stdClass;
        if (!$request->hasFile($file) || !$request->file($file)[$index]->isValid()) {
            $result->msg = "MISSINGPARAMETER";
            return $result;
        }
        $validator = \Validator::make($request->all(), ['attachment' => 'required']);
        if ($validator->fails()) {
            $result->msg = "INVALIDPARAMETER";
            return $result;
        }
        $result->file_name = md5($request->file($file)[$index]->getClientOriginalName() . csrf_token() . Carbon::now()->toDateTimeString() . rand(1, 100)) . '.' . $request->file($file)[$index]->guessExtension();
        $request->file($file)[$index]->move(public_path($path_from_public), $result->file_name);
        $result->msg = "SUCCESS";
        return $result;
    }

    public static function uploadImg2(\Illuminate\Http\Request $request, $file, $path_from_public)
    {
        $result = new \stdClass;
        if (!$request->hasFile($file) || !$request->file($file)->isValid()) {
            $result->msg = "MISSINGPARAMETER";
            return $result;
        }
        $validator = \Validator::make($request->all(), ['attachment' => 'required']);
        if ($validator->fails()) {
            $result->msg = "INVALIDPARAMETER";
            return $result;
        }
        $result->file_name = md5($request->file($file)->getClientOriginalName() . csrf_token() . Carbon::now()->toDateTimeString() . rand(1, 100)) . '.' . $request->file($file)->guessExtension();
        $request->file($file)->move(public_path($path_from_public), $result->file_name);
        $result->msg = "SUCCESS";
        return $result;
    }

    public static function deleteFile($filePath)
    {
        if(!$filePath)
            return true;

        if(\File::exists(public_path($filePath))) {

            if (\File::delete(public_path($filePath))) {
                return true;
            } else {
                return false;
            }
        } else {
            return true;
        }

    }
	
	public static function sendSystemMail($data,$mailtype)
    {
		if($mailtype == "request_for_quotation")
			$message = self::requestForQuotation($data);
		//else if($mailtype == "contact_us")
            //$message = self::requestForQuotation($data); 
			
		
		// Always set content-type when sending HTML email
		$headers = "MIME-Version: 1.0" . "\r\n";
		$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
		$headers .= 'From: <supplygates-support@supplygates.com>' . "\r\n";

		if(mail($data['email'],$data['subject'],$message,$headers))
			return true;
		else
			return false;
    }
	
	private static function requestForQuotation($data)
	{
		return "
                    <html xmlns='http://www.w3.org/1999/xhtml' xmlns:o='urn:schemas-microsoft-com:office:office' xmlns:v='urn:schemas-microsoft-com:vml'>
                    <head>
                    <meta content='text/html; charset=utf-8' http-equiv='Content-Type'/>
                    <meta content='width=device-width' name='viewport'/>
                    <meta content='IE=edge' http-equiv='X-UA-Compatible'/>
                    </head>
                    <body class='clean-body' style='margin: 0; padding: 0; -webkit-text-size-adjust: 100%; background-color: #FFFFFF;'>
                    <table bgcolor='#FFFFFF' cellpadding='0' cellspacing='0' class='nl-container' role='presentation' style='table-layout: fixed; vertical-align: top; min-width: 320px; Margin: 0 auto; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; background-color: #FFFFFF; width: 100%;' valign='top' width='100%'>
                    <tbody>
                    <tr style='vertical-align: top;' valign='top'>
                    <td style='word-break: break-word; vertical-align: top; border-collapse: collapse;' valign='top'>
                    <div style='background-color:#FFFFFF;'>
                    <div class='block-grid mixed-two-up' data-body-width-father='650px' rel='col-num-container-box-father' style='Margin: 0 auto; min-width: 320px; max-width: 650px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
                    <div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
                    <div class='col num4' data-body-width-son='216' rel='col-num-container-box-son' style='display: table-cell; vertical-align: top; max-width: 320px; min-width: 216px;'>
                    <div style='width:100% !important;'>
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:25px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
                    <div align='center' class='img-container center autowidth fullwidth' style='padding-right: 0px;padding-left: 0px;'>
                    <div style='font-size:1px;line-height:15px'> </div><a href='http://supplygates.com/' target='_blank'> <img align='center' alt='Image' border='0' class='center autowidth fullwidth' src='http://".$_SERVER["SERVER_NAME"]."/images/logo-sup2.png' style='outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; clear: both; height: auto; float: none; border: none; width: 100%; max-width: 216px; display: block;' title='Image' width='216'/></a>
                    </div>
                    </div>
                    </div>
                    </div>
                    
                    </div>
                    </div>
                    </div>
                    <div style='background-color:#1f3379;'>
                    <div class='block-grid' data-body-width-father='650px' rel='col-num-container-box-father' style='Margin: 0 auto; min-width: 320px; max-width: 650px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
                    <div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
                    <!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#1f3379;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:650px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
                    <!--[if (mso)|(IE)]><td align='center' width='650' style='background-color:transparent;width:650px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:55px; padding-bottom:5px;'><![endif]-->
                    <div class='col num12' data-body-width-son='650' rel='col-num-container-box-son' style='min-width: 320px; max-width: 650px; display: table-cell; vertical-align: top;'>
                    <div style='width:100% !important;'>
                    <!--[if (!mso)&(!IE)]><!-->
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:55px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
                    <!--<![endif]-->
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 10px; padding-left: 10px; padding-top: 0px; padding-bottom: 10px; font-family: Trebuchet MS, Tahoma, sans-serif'><![endif]-->
                    <div style='color:#FFFFFF;font-family:Oxygen, Trebuchet MS, Lucida Grande, Lucida Sans Unicode, Lucida Sans, Tahoma, sans-serif;line-height:150%;padding-top:0px;padding-right:10px;padding-bottom:10px;padding-left:10px;'>
                    <div style='line-height: 18px; font-family: Oxygen, Trebuchet MS, Lucida Grande, Lucida Sans Unicode, Lucida Sans, Tahoma, sans-serif; font-size: 12px; color: #FFFFFF;'>
                    <p style='line-height: 18px; text-align: center; font-size: 12px; margin: 0;'><strong><span style='font-size: 24px; line-height: 36px;'>Dear Sir,</span></strong><br/><strong><span style='font-size: 24px; line-height: 36px;'>You are kindly requested to send us your best technical and commercial quotation relevant to the above mentioned project for the following ".$data['type'].".</span></strong></p>
                    </div>
                    </div>
                    <!--[if mso]></td></tr></table><![endif]-->
                    <!--[if (!mso)&(!IE)]><!-->
                    </div>
                    <!--<![endif]-->
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
                    </div>
                    </div>
                    </div>
                    <div style='background-image:url(http://".$_SERVER["SERVER_NAME"]."/images/traccia_verticale.png);background-position:top center;background-repeat:no-repeat;background-color:#F2F2F2;'>
                    <div class='block-grid' data-body-width-father='650px' rel='col-num-container-box-father' style='Margin: 0 auto; min-width: 320px; max-width: 650px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
                    <div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
                    <!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-image:url(images/traccia_verticale.png);background-position:top center;background-repeat:no-repeat;background-color:#F2F2F2;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:650px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
                    <!--[if (mso)|(IE)]><td align='center' width='650' style='background-color:transparent;width:650px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:0px;'><![endif]-->
                    <div class='col num12' data-body-width-son='650' rel='col-num-container-box-son' style='min-width: 320px; max-width: 650px; display: table-cell; vertical-align: top;'>
                    <div style='width:100% !important;'>
                    <!--[if (!mso)&(!IE)]><!-->
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:0px; padding-right: 0px; padding-left: 0px;'>
                    <!--<![endif]-->
                    <div align='center' class='img-container center autowidth fullwidth' style='padding-right: 0px;padding-left: 0px;'>
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr style='line-height:0px'><td style='padding-right: 0px;padding-left: 0px;' align='center'><![endif]--><img align='center' alt='Image' border='0' class='center autowidth fullwidth' src='http://".$_SERVER["SERVER_NAME"]."/images/rounded_top.png' style='outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; clear: both; border: 0; height: auto; float: none; width: 100%; max-width: 650px; display: block;' title='Image' width='650'/>
                    <!--[if mso]></td></tr></table><![endif]-->
                    </div>
                    <!--[if (!mso)&(!IE)]><!-->
                    </div>
                    <!--<![endif]-->
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
                    </div>
                    </div>
                    </div>
                    <div style='background-color:#F2F2F2;'>
                    <div class='block-grid mixed-two-up' data-body-width-father='650px' rel='col-num-container-box-father' style='Margin: 0 auto; min-width: 320px; max-width: 650px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: #FFFFFF;'>
                    <div style='border-collapse: collapse;display: table;width: 100%;background-color:#FFFFFF;'>
                    <!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#F2F2F2;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:650px'><tr class='layout-full-width' style='background-color:#FFFFFF'><![endif]-->
                    <!--[if (mso)|(IE)]><td align='center' width='216' style='background-color:#FFFFFF;width:216px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 1px solid #DDDDDD;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;'><![endif]-->
                    <div class='col num4' data-body-width-son='215' rel='col-num-container-box-son' style='display: table-cell; vertical-align: top; max-width: 320px; min-width: 216px;'>
                    <div style='width:100% !important;'>
                    <!--[if (!mso)&(!IE)]><!-->
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:1px solid #DDDDDD; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
                    <!--<![endif]-->
                    <div align='center' class='img-container center fixedwidth' style='padding-right: 0px;padding-left: 15px;'>
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr style='line-height:0px'><td style='padding-right: 0px;padding-left: 15px;' align='center'><![endif]--><img align='center' alt='Image' border='0' class='center fixedwidth' src='http://".$_SERVER["SERVER_NAME"]."/images/tick.png' style='outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; clear: both; border: 0; height: auto; float: none; width: 100%; max-width: 53px; display: block;' title='Image' width='53'/>
                    <!--[if mso]></td></tr></table><![endif]-->
                    </div>
                    <!--[if (!mso)&(!IE)]><!-->
                    </div>
                    <!--<![endif]-->
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    <!--[if (mso)|(IE)]></td><td align='center' width='433' style='background-color:#FFFFFF;width:433px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;'><![endif]-->
                    <div class='col num8' data-body-width-son='433' rel='col-num-container-box-son' style='display: table-cell; vertical-align: top; min-width: 320px; max-width: 432px;'>
                    <div style='width:100% !important;'>
                    <!--[if (!mso)&(!IE)]><!-->
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
                    <!--<![endif]-->
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 10px; padding-left: 10px; padding-top: 0px; padding-bottom: 3px; font-family: Trebuchet MS, Tahoma, sans-serif'><![endif]-->
                    <div style='color:#1f3379;font-family:Oxygen, Trebuchet MS, Lucida Grande, Lucida Sans Unicode, Lucida Sans, Tahoma, sans-serif;line-height:120%;padding-top:0px;padding-right:10px;padding-bottom:3px;padding-left:10px;'>
                    <div style='font-size: 12px; line-height: 14px; font-family: Oxygen, Trebuchet MS, Lucida Grande, Lucida Sans Unicode, Lucida Sans, Tahoma, sans-serif; color: #1f3379;'>
                    <p style='font-size: 14px; line-height: 21px; margin: 0;'><span style='font-size: 18px;'><strong>".$data['name']."</strong></span></p>
                    </div>
                    </div>
                    <!--[if mso]></td></tr></table><![endif]-->
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 25px; padding-left: 10px; padding-top: 0px; padding-bottom: 0px; font-family: Trebuchet MS, Tahoma, sans-serif'><![endif]-->
                    <div style='color:#60B2E1;font-family:Oxygen, Trebuchet MS, Lucida Grande, Lucida Sans Unicode, Lucida Sans, Tahoma, sans-serif;line-height:120%;padding-top:0px;padding-right:25px;padding-bottom:0px;padding-left:10px;'>
                    <div style='font-size: 12px; line-height: 14px; font-family: Oxygen, Trebuchet MS, Lucida Grande, Lucida Sans Unicode, Lucida Sans, Tahoma, sans-serif; color: #60B2E1;'>
                    <p style='font-size: 14px; line-height: 16px; margin: 0;'><strong><span style='font-size: 13px; line-height: 15px; mso-ansi-font-size: 14px;'>".$data['thePartNumber']."</span></strong></p>
                    </div>
                    </div>
                    <!--[if mso]></td></tr></table><![endif]-->
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 25px; padding-left: 10px; padding-top: 0px; padding-bottom: 0px; font-family: Trebuchet MS, sans-serif'><![endif]-->
                    <div style='color:#555555;font-family:Raleway, Trebuchet MS, Helvetica, sans-serif;line-height:120%;padding-top:0px;padding-right:25px;padding-bottom:0px;padding-left:10px;'>
                    <div style='font-size: 12px; line-height: 14px; font-family: Raleway, Trebuchet MS, Helvetica, sans-serif; color: #555555;'>
                    <p style='font-size: 14px; line-height: 15px; margin: 0;'><span style='font-size: 13px; mso-ansi-font-size: 14px;'>".$data['partNumber']."</span></p>
                    </div>
                    </div>
                    <!--[if mso]></td></tr></table><![endif]-->
                    <!--[if (!mso)&(!IE)]><!-->
                    </div>
                    <!--<![endif]-->
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
                    </div>
                    </div>
                    </div>
                    <div style='background-image:url(http://".$_SERVER["SERVER_NAME"]."/images/traccia_verticale.png);background-position:top center;background-repeat:no-repeat;background-color:#F2F2F2;'>
                    <div class='block-grid' data-body-width-father='650px' rel='col-num-container-box-father' style='Margin: 0 auto; min-width: 320px; max-width: 650px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
                    <div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
                    <!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-image:url(images/traccia_verticale.png);background-position:top center;background-repeat:no-repeat;background-color:#F2F2F2;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:650px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
                    <!--[if (mso)|(IE)]><td align='center' width='650' style='background-color:transparent;width:650px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:0px; padding-bottom:5px;'><![endif]-->
                    <div class='col num12' data-body-width-son='650' rel='col-num-container-box-son' style='min-width: 320px; max-width: 650px; display: table-cell; vertical-align: top;'>
                    <div style='width:100% !important;'>
                    <!--[if (!mso)&(!IE)]><!-->
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:0px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
                    <!--<![endif]-->
                    <div align='center' class='img-container center autowidth fullwidth' style='padding-right: 0px;padding-left: 0px;'>
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr style='line-height:0px'><td style='padding-right: 0px;padding-left: 0px;' align='center'><![endif]--><img align='center' alt='Image' border='0' class='center autowidth fullwidth' src='http://".$_SERVER["SERVER_NAME"]."/images/rounded_bottom.png' style='outline: none; text-decoration: none; -ms-interpolation-mode: bicubic; clear: both; border: 0; height: auto; float: none; width: 100%; max-width: 650px; display: block;' title='Image' width='650'/>
                    <!--[if mso]></td></tr></table><![endif]-->
                    </div>
                    <!--[if (!mso)&(!IE)]><!-->
                    </div>
                    <!--<![endif]-->
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
                    </div>
                    </div>
                    </div>
                    
                    <div style='background-image:url(http://".$_SERVER["SERVER_NAME"]."/images/traccia_verticale.png);background-position:top center;background-repeat:no-repeat;background-color:#F2F2F2;'>
                    <div class='block-grid' data-body-width-father='650px' rel='col-num-container-box-father' style='Margin: 0 auto; min-width: 320px; max-width: 650px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
                    <div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
                    <!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-image:url(images/traccia_verticale.png);background-position:top center;background-repeat:no-repeat;background-color:#F2F2F2;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:650px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
                    <!--[if (mso)|(IE)]><td align='center' width='650' style='background-color:transparent;width:650px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;'><![endif]-->
                    <div class='col num12' data-body-width-son='650' rel='col-num-container-box-son' style='min-width: 320px; max-width: 650px; display: table-cell; vertical-align: top;'>
                    <div style='width:100% !important;'>
                    <!--[if (!mso)&(!IE)]><!-->
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
                    <!--<![endif]-->
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px; font-family: Trebuchet MS, sans-serif'><![endif]-->
                    <div style='color:#555555;font-family:Raleway, Trebuchet MS, Helvetica, sans-serif;line-height:120%;padding-top:10px;padding-right:10px;padding-bottom:10px;padding-left:10px;'>
                    <div style='font-family: Raleway, Trebuchet MS, Helvetica, sans-serif; font-size: 12px; line-height: 14px; color: #555555;'>
                    <p style='font-size: 14px; line-height: 21px; margin: 0;'><span style='font-size: 18px;'>Appreciate your quick response as soon as possible including the following:</span></p>
                    <ol>
                    <li style='font-size: 14px; line-height: 16px;'><span style='font-size: 18px; line-height: 21px;'>Commercial offer with unit &amp; total prices.</span></li>
                    <li style='font-size: 14px; line-height: 16px;'><span style='font-size: 18px; line-height: 21px;'>Technical offer including selection and complete catalogues.</span></li>
                    <li style='font-size: 14px; line-height: 16px;'><span style='font-size: 18px; line-height: 21px;'>Terms of payment.</span></li>
                    <li style='font-size: 14px; line-height: 16px;'><span style='font-size: 18px; line-height: 21px;'>Delivery time and location.</span></li>
                    </ol>
                    <p style='font-size: 12px; line-height: 14px; margin: 0;'> </p>
                    <p style='font-size: 12px; line-height: 14px; margin: 0;'> </p>
                    <p style='font-size: 12px; line-height: 20px; margin: 0;'><span style='font-size: 17px; mso-ansi-font-size: 18px;'>Kindly confirm receipt of the email and your interest to present the quotation as soon as you receive it.</span></p>
                    <p dir='ltr' style='font-size: 12px; line-height: 19px; text-align: center; margin: 0;'><span style='font-size: 16px;'>Awaiting your reply on,</span></p>
                    <p dir='ltr' style='font-size: 12px; line-height: 19px; text-align: center; margin: 0;'><span style='font-size: 16px;'>".$data['userEmail']."</span></p>
                    <p dir='ltr' style='font-size: 12px; line-height: 19px; text-align: center; margin: 0;'><span style='font-size: 16px;'>Best Regards.</span></p>
                    </div>
                    </div>
                    <!--[if mso]></td></tr></table><![endif]-->
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px; font-family: Trebuchet MS, sans-serif'><![endif]-->
                    <div style='color:#555555;font-family:Raleway, Trebuchet MS, Helvetica, sans-serif;line-height:120%;padding-top:10px;padding-right:10px;padding-bottom:10px;padding-left:10px;'>
                    <div style='font-family: Raleway, Trebuchet MS, Helvetica, sans-serif; line-height: 14px; font-size: 12px; color: #555555;'>
                    <p style='font-size: 14px; line-height: 16px; margin: 0;'><strong><span style='font-size: 24px; line-height: 28px;'>Additional comment</span></strong></p>
                    <p style='font-size: 14px; line-height: 16px; margin: 0;'><span style='font-size: 14px; line-height: 16px;'><strong><span style='line-height: 16px; font-size: 14px;'>- ".$data['comment']."</span></strong></span></p>
                    </div>
                    </div>
                    <!--[if mso]></td></tr></table><![endif]-->
                    <table border='0' cellpadding='0' cellspacing='0' class='divider' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;' valign='top' width='100%'>
                    <tbody>
                    <tr style='vertical-align: top;' valign='top'>
                    <td class='divider_inner' style='word-break: break-word; vertical-align: top; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; padding-top: 10px; padding-right: 10px; padding-bottom: 10px; padding-left: 10px; border-collapse: collapse;' valign='top'>
                    <table align='center' border='0' cellpadding='0' cellspacing='0' class='divider_content' height='25' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; border-top: 0px solid transparent; height: 25px;' valign='top' width='100%'>
                    <tbody>
                    <tr style='vertical-align: top;' valign='top'>
                    <td height='25' style='word-break: break-word; vertical-align: top; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; border-collapse: collapse;' valign='top'><span></span></td>
                    </tr>
                    </tbody>
                    </table>
                    </td>
                    </tr>
                    </tbody>
                    </table>
                    <!--[if (!mso)&(!IE)]><!-->
                    </div>
                    <!--<![endif]-->
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
                    </div>
                    </div>
                    </div>
                    
                    <div style='background-color:#14396e;'>
                    <div class='block-grid' data-body-width-father='650px' rel='col-num-container-box-father' style='Margin: 0 auto; min-width: 320px; max-width: 650px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
                    <div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
                    <!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#14396e;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:650px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
                    <!--[if (mso)|(IE)]><td align='center' width='650' style='background-color:transparent;width:650px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:0px; padding-bottom:5px;'><![endif]-->
                    <div class='col num12' data-body-width-son='650' rel='col-num-container-box-son' style='min-width: 320px; max-width: 650px; display: table-cell; vertical-align: top;'>
                    <div style='width:100% !important;'>
                    <!--[if (!mso)&(!IE)]><!-->
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:0px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
                    <!--<![endif]-->
                    <!--[if mso]><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 10px; padding-left: 10px; padding-top: 10px; padding-bottom: 10px; font-family: Trebuchet MS, sans-serif'><![endif]-->
                    <div style='color:#F0F0F0;font-family:Raleway, Trebuchet MS, Helvetica, sans-serif;line-height:120%;padding-top:10px;padding-right:10px;padding-bottom:10px;padding-left:10px;'>
                    <div style='font-size: 12px; line-height: 14px; font-family: Raleway, Trebuchet MS, Helvetica, sans-serif; color: #F0F0F0;'>
                    <p style='font-size: 14px; line-height: 16px; margin: 0;'>© 2019 Supply Gates All rights reserved. Developed with ❤By SOLUOO Software House.</p>
                    </div>
                    </div>
                    <!--[if mso]></td></tr></table><![endif]-->
                    <!--[if (!mso)&(!IE)]><!-->
                    </div>
                    <!--<![endif]-->
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
                    </div>
                    </div>
                    </div>
                    <div style='background-color:#14396e;'>
                    <div class='block-grid' data-body-width-father='650px' rel='col-num-container-box-father' style='Margin: 0 auto; min-width: 320px; max-width: 650px; overflow-wrap: break-word; word-wrap: break-word; word-break: break-word; background-color: transparent;'>
                    <div style='border-collapse: collapse;display: table;width: 100%;background-color:transparent;'>
                    <!--[if (mso)|(IE)]><table width='100%' cellpadding='0' cellspacing='0' border='0' style='background-color:#14396e;'><tr><td align='center'><table cellpadding='0' cellspacing='0' border='0' style='width:650px'><tr class='layout-full-width' style='background-color:transparent'><![endif]-->
                    <!--[if (mso)|(IE)]><td align='center' width='650' style='background-color:transparent;width:650px; border-top: 0px solid transparent; border-left: 0px solid transparent; border-bottom: 0px solid transparent; border-right: 0px solid transparent;' valign='top'><table width='100%' cellpadding='0' cellspacing='0' border='0'><tr><td style='padding-right: 0px; padding-left: 0px; padding-top:5px; padding-bottom:5px;'><![endif]-->
                    <div class='col num12' data-body-width-son='650' rel='col-num-container-box-son' style='min-width: 320px; max-width: 650px; display: table-cell; vertical-align: top;'>
                    <div style='width:100% !important;'>
                    <!--[if (!mso)&(!IE)]><!-->
                    <div style='border-top:0px solid transparent; border-left:0px solid transparent; border-bottom:0px solid transparent; border-right:0px solid transparent; padding-top:5px; padding-bottom:5px; padding-right: 0px; padding-left: 0px;'>
                    <!--<![endif]-->
                    <table border='0' cellpadding='0' cellspacing='0' class='divider' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%;' valign='top' width='100%'>
                    <tbody>
                    <tr style='vertical-align: top;' valign='top'>
                    <td class='divider_inner' style='word-break: break-word; vertical-align: top; min-width: 100%; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; padding-top: 10px; padding-right: 10px; padding-bottom: 10px; padding-left: 10px; border-collapse: collapse;' valign='top'>
                    <table align='center' border='0' cellpadding='0' cellspacing='0' class='divider_content' height='0' role='presentation' style='table-layout: fixed; vertical-align: top; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; width: 100%; border-top: 0px solid transparent; height: 0px;' valign='top' width='100%'>
                    <tbody>
                    <tr style='vertical-align: top;' valign='top'>
                    <td height='0' style='word-break: break-word; vertical-align: top; -ms-text-size-adjust: 100%; -webkit-text-size-adjust: 100%; border-collapse: collapse;' valign='top'><span></span></td>
                    </tr>
                    </tbody>
                    </table>
                    </td>
                    </tr>
                    </tbody>
                    </table>
                    <!--[if (!mso)&(!IE)]><!-->
                    </div>
                    <!--<![endif]-->
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    <!--[if (mso)|(IE)]></td></tr></table></td></tr></table><![endif]-->
                    </div>
                    </div>
                    </div>
                    <!--[if (mso)|(IE)]></td></tr></table><![endif]-->
                    </td>
                    </tr>
                    </tbody>
                    </table>
                    <!--[if (IE)]></div><![endif]-->
                    </body>
                    </html>

		";
	}

    /*
     * Code converted by Saleh Jamal (@salehjamal)
     */
    public static function get_client_ip() {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }
}
