<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/
    

Route::group(['domain'=>'www.'.env('DOMAIN')],function(){
    Route::get('',function(){
        return redirect()->away('http://'. env('DOMAIN'));
    });
});

Route::group(['domain'=>'backend.'.env('DOMAIN')],function(){
	Route::post('remote/mob', 'RemoteController@Mob');
    Route::post('remote/mob/{requestedAPI}', 'RemoteController@Mob');
    //Route::get('api/v2/{requestedAPI}', 'ApiController@InternalDispatcher');
    Route::post('api/v2', 'ApiController@InternalDispatcher');
    Route::post('api/v2/{requestedAPI}', 'ApiController@InternalDispatcher');
    Route::get('/', function () {
        if (Auth::check()) {
            if (\Session::has('SuperMode'))
                return redirect(action('CompaniesController@getList'));
            return redirect(action('UserController@getDashboard'));
        }
        return view('login-using-company');
    });
    Route::post('/', function (\Illuminate\Http\Request $request) {
        $validation = Validator::make($request->all(), ['company' => 'required']);
        if ($validation->failed())
            return redirect()->back()->withErrors($validation);
        $company = $request->get('company');
        if (!\App\Company::checkDomainExists($company))
            return redirect()->back()->withErrors(['Looks like the company you specified isn\'t registered with HRFlo']);
        if (!\Session::has('company') || (\Session::has('company') && \Session::get('company') != $company)) {
            \Session::put('company', $company);
            \Session::save();
        }
        return redirect()->away('http://' . $company . '.' . env('DOMAIN'));

    });

  
});

Route::group(['domain' => 'super.'.env('DOMAIN')], function () {
    Route::post('super', 'Auth\AuthController@postSuperLogin');
    Route::get('super', 'Auth\AuthController@getSuperLogin');
    //Super Admin Routes
    Route::group(['prefix' => 'dashboard', 'middleware' => ['auth', '\App\Http\Middleware\SuperAdminMiddleware']], function () {
        Route::get('list', 'CompaniesController@getList');
        Route::get('access/{id}', 'CompaniesController@getAccessAsAdmin');
        Route::get('create', 'CompaniesController@getAddCompany');
        Route::get('edit/{id}', 'CompaniesController@getEditTransaction');
        Route::get('create-transaction/{id}', 'CompaniesController@getAddTransaction');
        Route::get('details/{id}', 'CompaniesController@getDetails');
        Route::post('create', 'CompaniesController@postCreate');
        Route::post('create-transaction', 'CompaniesController@postCreateTransaction');
        Route::post('delete-transaction', 'CompaniesController@postDeleteTransaction');
        Route::post('resend-activation-email', 'CompaniesController@postResendActivationEmail');
        Route::post('update-transaction', 'CompaniesController@postUpdateTransaction');
        Route::post('update-details', 'CompaniesController@postUpdateDetails');
        Route::post('update-email', 'CompaniesController@postUpdateEmail');
        Route::post('update-admin-capacity', 'CompaniesController@postUpdateHRAdminCapacity');
        Route::post('active-status', 'CompaniesController@postChangeActiveStatus');
    });


    Route::get('/', function () {
        if (Auth::check()) {
            if (\Session::has('SuperMode'))
                return redirect(action('CompaniesController@getList'));
            return redirect(action('UserController@getDashboard'));
        }
        return view('login-using-company');
    });
    Route::post('/', function (\Illuminate\Http\Request $request) {
        $validation = Validator::make($request->all(), ['company' => 'required']);
        if ($validation->failed())
            return redirect()->back()->withErrors($validation);
        $company = $request->get('company');
        if (!\App\Company::checkDomainExists($company))
            return redirect()->back()->withErrors(['Looks like the company you specified isn\'t registered with HRFlo']);
        if (!\Session::has('company') || (\Session::has('company') && \Session::get('company') != $company)) {
            \Session::put('company', $company);
            \Session::save();
        }
        return redirect()->away('http://' . $company . '.' . env('DOMAIN'));

    });
    Route::get('logout', 'Auth\AuthController@getLogout');


//APIs Routes


    Route::post('secure', function () {
        return \Auth::check() ? 1 : 0;
    });

    Route::get('session-expired', function () {
        return \Auth::check() ? redirect()->back() : view('errors.session-expired');
    });
});

Route::group(['domain' => '{company}.' . env('DOMAIN'), 'middleware' => ['\App\Http\Middleware\DomainMiddleware']], function () {
    Route::get('admin', 'Auth\AuthController@getAdminLogin');
    Route::post('admin', 'Auth\AuthController@postAdminLogin');

    //Admin Routes
    Route::group(['prefix' => 'dashboard', 'middleware' => ['auth', '\App\Http\Middleware\HRAdminMiddleware']], function () {
        //Dashboard Post
        Route::get('', 'UserController@getDashboard');
        Route::post('', 'UserController@postDashboard');

        //Database
        Route::group(['prefix' => 'database'], function () {
            Route::group(['prefix' => 'users'], function () {
                Route::get('list', 'UsersController@getList');
                Route::get('edit/{id}', 'UsersController@getEdit');
                Route::post('leave-balances', 'UsersController@postUpdateLeaveBalances');
                Route::post('compensation-balances', 'UsersController@postUpdateCompensationBalance');
                Route::post('user-details', 'UsersController@postUpdateUserDetails');
                Route::post('handling-details', 'UsersController@postUpdateUserHandlingDetails');
                Route::post('add-family', 'UsersController@postAddFamily');
                Route::post('edit-family', 'UsersController@postEditFamily');
                Route::post('remove-family', 'UsersController@postRemoveFamily');
                Route::post('active-status', 'UsersController@postChangeActiveStatus');
                Route::post('user-role', 'UsersController@postChangeUserRole');
                Route::post('create-user', 'UsersController@postCreateUser');
                Route::post('custom-policies', 'UsersController@postUpdateCustomPolicies');
            });
            Route::group(['prefix' => 'departments'], function () {
                Route::get('list', 'DepartmentsController@getList');
                Route::get('edit/{id}', 'DepartmentsController@getEdit');
                Route::get('create', 'DepartmentsController@getCreate');
                Route::post('create', 'DepartmentsController@postCreate');
                Route::post('update', 'DepartmentsController@postUpdate');
                Route::post('delete', 'DepartmentsController@postDelete');
                Route::post('custom-policies', 'DepartmentsController@postUpdateCustomPolicies');
                Route::post('add-user', 'DepartmentsController@postAddUser');
                Route::post('remove-user', 'DepartmentsController@postRemoveUser');
            });
            Route::group(['prefix' => 'groups'], function () {
                Route::get('list', 'GroupsController@getList');
                Route::get('edit/{id}', 'GroupsController@getEdit');
                Route::get('create', 'GroupsController@getCreate');
                Route::post('create', 'GroupsController@postCreate');
                Route::post('update', 'GroupsController@postUpdate');
                Route::post('delete', 'GroupsController@postDelete');
                Route::post('custom-policies', 'GroupsController@postUpdateCustomPolicies');
                Route::post('add-user', 'GroupsController@postAddUser');
                Route::post('remove-user', 'GroupsController@postRemoveUser');
            });
            Route::group(['prefix' => 'exchange'], function () {
                Route::post('export', 'ExchangeController@postExportUsers');
                Route::post('import', 'ExchangeController@postImportUsers');
            });

        });

        //Settings
        Route::group(['prefix' => 'settings'], function () {
            Route::group(['prefix' => 'policies'], function () {
                Route::get('{type}/list', 'PolicyController@get');
                Route::get('{type}/create', 'PolicyController@getCreate');
                Route::get('{type}/edit/{id}', 'PolicyController@getUpdatePolicy');
                Route::post('create', 'PolicyController@postCreate');
                Route::post('specifics', 'PolicyController@postPolicySpecificsJson');
                Route::post('update', 'PolicyController@postUpdatePolicy');
                Route::post('active-status', 'PolicyController@postActivatePolicy');
            });
            Route::group(['prefix' => 'compensations'], function () {
                Route::get('list', 'CompensationController@getList');
                Route::get('edit/{id}', 'CompensationController@getEditCompensation');
                Route::get('create', 'CompensationController@getAddCompensation');
                Route::post('create', 'CompensationController@postAddCompensation');
                Route::post('update', 'CompensationController@postEditCompensation');
                Route::post('change-currency', 'CompensationController@postChangeCurrency');
                Route::post('delete', 'CompensationController@postDeleteCompensation');
            });
            Route::group(['prefix' => 'religions'], function () {
                Route::get('list', 'ReligionController@getList');
                Route::get('create', 'ReligionController@getAddReligion');
                Route::get('edit/{id}', 'ReligionController@getEditReligion');
                Route::post('create', 'ReligionController@postAddReligion');
                Route::post('update', 'ReligionController@postEditReligion');
                Route::post('delete', 'ReligionController@postDeleteReligion');
            });
            Route::group(['prefix' => 'locations'], function () {
                Route::get('list', 'LocationController@getList');
                Route::get('create', 'LocationController@getAddLocation');
                Route::get('edit/{id}', 'LocationController@getEditLocation');
                Route::post('create', 'LocationController@postAddLocation');
                Route::post('update', 'LocationController@postEditLocation');
                Route::post('delete', 'LocationController@postDeleteLocation');
            });
            Route::group(['prefix' => 'announcements'], function () {
                Route::get('list', 'AnnouncementController@getList');
                Route::post('create', 'AnnouncementController@postAddAnnouncement');
                Route::post('targets', 'AnnouncementController@postGetTargets');
                Route::post('edit', 'AnnouncementController@postEditAnnouncement');
            });
            Route::group(['prefix' => 'general'], function () {
                Route::get('', 'SettingsController@getIndex');
                Route::post('update', 'SettingsController@postUpdate');
            });
        });

        //Logs
        Route::group(['prefix' => 'logs'], function () {
            Route::get('requests', ['as' => 'logs.requests', 'uses' => 'LogsController@getRequests']);
            Route::get('request', ['as' => 'logs.request', 'uses' => 'LogsController@getRequestDetails']);
        });
    });

    //Employee Routes
    Route::group(['prefix' => 'dashboard', 'middleware' => ['auth', '\App\Http\Middleware\EmployeeMiddleware']], function () {
        Route::get('', 'UserController@getDashboard');
        Route::get('incoming-requests/{type}', 'UserController@getIncomingRequests');
        Route::get('outgoing-requests', 'UserController@getMyRequests');
        Route::get('add/{id}', 'UserController@getAddRequest');
        Route::get('details/{id}', 'UserController@getRequestDetails');
        Route::get('profile', 'UserController@getProfile');
        Route::get('change-password', 'UserController@getChangePassword');
        Route::post('action', 'UserController@postRequestAction');
        Route::post('cancel', 'UserController@postCancelRequest');
        Route::post('save', 'UserController@postSaveRequest');
        Route::post('change-password', 'UserController@postChangePassword');
        Route::get('announcements', 'UserController@Announcements');
    });

//Login/ Logout routes
    Route::get('logout', 'Auth\AuthController@getLogout');
    Route::get('access-company/{access}', 'Auth\AuthController@getAccessedAs');
    Route::get('reset-password', 'Auth\AuthController@getResetPassword');
    Route::post('reset-password', 'Auth\AuthController@postResetPassword');
    Route::get('login', 'Auth\AuthController@getLogin');
    Route::get('/', function ($company) {
        if (Auth::check()) {
            $path = action('UserController@getDashboard');
            if (\Session::has('SuperMode')) {
                $path = action('CompaniesController@getList');
            }
            return redirect($path);
        }
        return redirect(action('Auth\AuthController@getLogin'));
    });
    Route::post('login', 'Auth\AuthController@postLogin');
});



// Notifications
//Route::get('push-to/{email}', function ($email) {
//    $userId = \App\User::getUserIdByCompanyEmail($email);
//    if (!$userId) {
//        return "Incorrect Parameter";
//    }
//    $pushInformation = \App\User::getPushInformation($userId);
//    if (!$pushInformation || !array_key_exists('token', $pushInformation))
//        return "User has no registered devices";
//    $messages = ['approve', 'deny', 'review'];
//    $data = \App\PushNotifications::send(
//        $pushInformation['token'],
//        $pushInformation['type'],
//        $messages[rand(0, 2)],
//        ['unseen_count' => rand(2, 20)]
//    );
//
//    echo "Notification sent Here's a snapshot of the body";
//    dd($data);
//});