@extends('layout')
@section('actions')
    <div class="btn-group">
        <a href="{{ URL::action('DepartmentsController@getCreate') }}" class="btn btn-dark">
            Add a Department
        </a>
    </div>
@endsection
@section('title')
    <i class="icon icon-department"></i> Departmentss Control
@endsection
@section('content')
    <div class="table-responsive">
        <table class="table hr-table table-hover">
            <thead>
            <tr>
                <th> #</th>
                <th> Department</th>
                <th> Scope</th>
                <th> Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php $index = 1; ?>
            @foreach($page['departments'] as $department)
                <tr>
                    <td> {{ $index++ }}</td>
                    <td> {{ $department->name }}</td>
                    <td>
                        <span class="label label-default" data-toggle="tooltip" title="Policies: {{ $department->policies_count }}">P:{{ $department->policies_count }}</span>
                        <span class="label label-primary" data-toggle="tooltip" title="Members: {{ $department->users_count }}">M:{{ $department->users_count }}</span>
                    </td>
                    <td>
                        <div class="hr-actions-cell">
                            <a href="{{ URL::action('DepartmentsController@getEdit',['id'=>$department->id]) }}"
                               class="btn btn-dark">
                                Edit
                            </a>
                            <button data-toggle="collapse" data-target="#department_users_{{$department->id}}"
                                    class="btn btn-dark">
                                Members
                            </button>
                            <button data-target="#delete_department_{{$department->id}}" data-toggle="modal"
                                    class="btn btn-red">
                                Delete
                            </button>
                            <div class="modal fade" id="delete_department_{{$department->id}}">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <form class="form" method="post"
                                                  action="{{ URL::action('DepartmentsController@postDelete') }}">
                                                {!! csrf_field() !!}
                                                <div class="help-block">
                                                    Are you sure you want to delete the Department "{{ $department->name }}"
                                                </div>
                                                <input type="hidden" name="department_id" value="{{$department->id}}">
                                                <div class="form-actions">
                                                    <button type="submit" class="btn btn-red">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                        Back to safety
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="collapse" id="department_users_{{$department->id}}">
                    <td colspan="4">
                        @if(count($department->unassigned_users))
                            <form class="form-horizontal" method="post"
                                  action="{{ URL::action('DepartmentsController@postAddUser') }}">
                                {!! csrf_field() !!}
                                <input type="hidden" value="{{ $department->id }}" name="department_id">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Add a user:</label>
                                    <div class="col-md-4">
                                        <select name="user_id" class="form-control col-md-4">
                                            @foreach($department->unassigned_users as $user)
                                                <option value="{{$user->id}}">{{$user->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <button type="submit" role="button" class="btn btn-green">
                                            Add
                                        </button>
                                    </div>
                                </div>
                            </form>
                        @endif
                        <ul class="list-group">
                            @foreach($department->users as $user)
                                <li class="list-group-item list-group-item-default contains-member">
                                    <div class="member-header">
                                        <span class="label label-info">ID: {{$user->employee_id}}</span>
                                        <strong>{{$user->name }}</strong>
                                        <div class="btn-group">
                                            <a href="#" class="btn btn-red btn-sm"
                                               onclick="$('#remove_user{{$user->id}}').submit()">
                                                Remove
                                            </a>
                                            <a href="{{URL::action('UsersController@getEdit',['id'=>$user->id])}}"
                                               class="btn btn-green btn-sm">
                                                View
                                            </a>

                                            <form method="post" id="remove_user{{$user->id}}"
                                                  action="{{ URL::action('DepartmentsController@postRemoveUser') }}">
                                                {!! csrf_field() !!}
                                                <input type="hidden" name="user_id" value="{{ $user->id }}">
                                                <input type="hidden" name="department_id" value="{{ $department->id }}">
                                            </form>
                                            <form method="post" id="view_user{{$user->id}}"
                                                  action="{{ URL::action('UsersController@getEdit',['id'=>$user->id]) }}">
                                            </form>
                                        </div>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection