@extends('layout')
@section('pageScripts')
    @include('admin.database.scripts.custom_policies')
@endsection
@section('title')
    Add a new Group
@endsection
@section('content')
    <form action="{{ URL::action('GroupsController@postCreate') }}" method="POST">
        {!! csrf_field() !!}
        <div class="form-group">
            <label class="control-label">
                Group name
            </label>
            <input type="text" class="form-control " name="name" placeholder="Group name...">
        </div>
        <hr>
        <div class="form-group" data-contains="custom-policies">
            <div class="col-xs-12 col-md-6">
                <div class="form-group">
                    <label class="control-label">
                        Custom Policies
                    </label>
                    <select data-change="show-specifics" class="form-control">
                        <option>Select</option>
                        <optgroup label="HR Policies">
                            @foreach($page->hrPolicies as $policy)
                                <option data-type="hr" value="{{$policy->id}}">{{$policy->name}}</option>
                            @endforeach
                        </optgroup>
                        <optgroup label="Leave Policies">
                            @foreach($page->leavePolicies as $policy)
                                <option data-type="leave" value="{{$policy->id}}">{{$policy->name}}</option>
                            @endforeach
                        </optgroup>
                    </select>
                </div>
                <div class="form-group">
                    <!-- HR Specifics Holder -->
                    <div class="col-xs-12 collapse" data-contains="hr-specifics">
                        <div class="form-group">
                            <label class="control-label">Applicants</label>
                            <select class="form-control" data-var="applicants">
                                <option value="all">All</option>
                                <option value="male">Male</option>
                                <option value="female">Female</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Service Level Agreement</label>
                            <input type="number" class="form-control"
                                   data-var="sla"
                                   placeholder="Service level agreement...">
                        </div>
                        <div class="form-group">
                            <label class="control-label">Available After</label>
                            <div class="input-group">
                                <input type="number" class="form-control"
                                       data-var="available-after"
                                       placeholder="Available After..">
                                <div class="input-group-addon">
                                    Months
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Line Managers</label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    Authority
                                </div>
                                <select data-contains="line-manager-authority" class="form-control">
                                    <option value="approve">Approve</option>
                                    <option value="review">Review</option>
                                </select>
                                <div class="input-group-btn">
                                    <button type="button" role="button" class="btn btn-dark" data-click="add-line-manager">Add</button>
                                </div>
                            </div>
                            <ul data-contains="line-managers" class="list-group collapse">
                            </ul>
                        </div>
                        <div class="form-group">
                            <button type="button" role="button" data-click="add-specifics" data-click-param="hr"
                                    class="btn btn-dark">Add Policy
                            </button>
                        </div>
                    </div>
                    <!-- Leave Specifics Holder -->
                    <div class="col-xs-12 collapse" data-contains="leave-specifics">
                        <div class="form-group">
                            <label class="control-label">Applicants</label>
                            <select class="form-control" data-var="applicants">
                                <option value="all">All</option>
                                <option value="male">Male</option>
                                <option value="female">Female</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Allowed Days</label>

                            <input type="number" class="form-control"
                                   data-var="allowed-days"
                                   placeholder="Allowed days..">
                        </div>
                        <div class="form-group">
                            <label class="control-label">Days Type</label>

                            <select class="form-control" data-var="days-type">
                                <option value="calender" selected>Calender</option>
                                <option value="working">Working</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="deductible" class="control-label">Deductible</label>
                            <input type="checkbox"
                                   data-var="deductible">
                        </div>
                        <div class="form-group">
                            <label for="hides_balance" class="control-label">Balance hidden in profile</label>
                            <input type="checkbox"
                                   data-var="hides_balance">
                        </div>
                        <div class="form-group">
                            <label class="control-label">Available After</label>
                            <div class="input-group">
                                <input type="number"
                                       class="form-control"
                                       data-var="available-after" placeholder="Available After..">
                                <div class="input-group-addon">
                                    Months
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label">Line Managers</label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    Authority
                                </div>
                                <select data-contains="line-manager-authority" class="form-control">
                                    <option value="approve">Approve</option>
                                    <option value="review">Review</option>
                                </select>
                                <div class="input-group-btn">
                                    <button type="button" role="button" class="btn btn-dark" data-click="add-line-manager">Add</button>
                                </div>
                            </div>
                            <ul data-contains="line-managers" class="list-group collapse">
                            </ul>
                        </div>
                        <div class="form-group">
                            <button type="button" role="button" data-click="add-specifics"
                                    data-click-param="leave"
                                    class="btn btn-dark">Add Policy
                            </button>
                        </div>
                    </div>
                </div>
                <div class="alert alert-warning" data-contains="alarm" style="display:none;">
                    This custom policy is already added.
                </div>
            </div>
            <div class="col-xs-12 col-md-6">
                <ul class="list-group" data-contains="specifics" style="margin-top:20px;">
                </ul>
            </div>
            <div class="col-xs-12 alert alert-success" data-contains="success" style="display:none;">
                Successfully added the custom policy, you can edit or delete it from the right panel.
            </div>
        </div>
        <div class="form-actions col-md-12">
            <button type="submit" class="btn btn-green">
                Create Group
            </button>
        </div>
    </form>

@endsection