@extends('layout')
@section('pageScripts')
    @include('admin.database.scripts.custom_policies')
@endsection
@section('title')
    Edit {{$group->name}}
@endsection
@section('content')
    <div class="col-md-3">
        <ul class="nav nav-pills-stacked margin-bottom-10">
            <li class="active">
                <a data-toggle="tab" href="#tab_1">
                    <i class="fa fa-picture-o"></i> Details </a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab_2">
                    <i class="fa fa-cog"></i> Custom Policies </a>
            </li>
        </ul>
    </div>
    <div class="col-md-9">
        <div class="tab-content">
            <div id="tab_1" class="tab-pane active">
                <div class="form">
                    <form action="{{ URL::action('GroupsController@postUpdate') }}" class="form-horizontal"
                          id="submit_form" method="POST">
                        {!! csrf_field() !!}
                        <input type="hidden" value="{{ $group->id }}" name="group_id">

                        <div class="form-group">
                            <label class="control-label">
                                Group name
                            </label>
                            <input value="{{$group->name}}" type="text" class="form-control " name="group_name"
                                   placeholder="Name...">
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="btn btn-success">
                                Update {{ $group->name }}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <div class="tab-pane" id="tab_2">

                <div class="form" data-contains="custom-policies">
                    <!-- Select Specifics -->
                    <div class="form-group" >
                        <select data-change="show-specifics" class="form-control">
                            <option>Select</option>
                            <optgroup label="HR Policies">
                                @foreach($page->hrPolicies as $policy)
                                    <option data-type="hr" value="{{$policy->id}}">{{$policy->name}}</option>
                                @endforeach
                            </optgroup>
                            <optgroup label="Leave Policies">
                                @foreach($page->leavePolicies as $policy)
                                    <option data-type="leave" value="{{$policy->id}}">{{$policy->name}}</option>
                                @endforeach
                            </optgroup>
                        </select>
                    </div>
                    <div class="form-group">
                        <!-- HR Specifics Holder -->
                        <div class="collapse" data-contains="hr-specifics">
                            <div class="form-group">
                                <label class="control-label">Applicants</label>
                                <select class="form-control" data-var="applicants">
                                    <option value="all">All</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Service Level Agreement</label>
                                <input type="number" class="form-control"
                                       data-var="sla"
                                       placeholder="Service level agreement...">
                            </div>
                            <div class="form-group">
                                <label class="control-label">Available After</label>
                                <div class="input-group">
                                    <input type="number" class="form-control"
                                           data-var="available-after"
                                           placeholder="Available After..">
                                    <div class="input-group-addon">
                                        Months
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Line Managers</label>
                                <div class="input-group">
                                    <div class="input-group-addon">
                                        Authority
                                    </div>
                                    <select data-contains="line-manager-authority" class="form-control">
                                        <option value="approve">Approve</option>
                                        <option value="review">Review</option>
                                    </select>
                                    <div class="input-group-btn">
                                        <button type="button" role="button" class="btn btn-dark"
                                                data-click="add-line-manager">Add
                                        </button>
                                    </div>
                                </div>
                                <ul data-contains="line-managers" class="list-group collapse">
                                </ul>
                            </div>
                            <div class="form-group">
                                <button type="button" role="button" data-click="add-specifics" data-click-param="hr"
                                        class="btn btn-dark">Add Policy
                                </button>
                            </div>
                        </div>
                        <!-- Leave Specifics Holder -->
                        <div class="collapse" data-contains="leave-specifics">
                            <div class="form-group">
                                <label class="control-label">Applicants</label>
                                <select class="form-control" data-var="applicants">
                                    <option value="all">All</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Allowed Days</label>

                                <input type="number" class="form-control"
                                       data-var="allowed-days"
                                       placeholder="Allowed days..">
                            </div>
                            <div class="form-group">
                                <label class="control-label">Days Type</label>

                                <select class="form-control" data-var="days-type">
                                    <option value="calender" selected>Calender</option>
                                    <option value="working">Working</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="deductible" class="control-label">Deductible</label>
                                <input type="checkbox"
                                       data-var="deductible">
                            </div>
                            <div class="form-group">
                                <label for="hides_balance" class="control-label">Balance hidden in profile</label>
                                <input type="checkbox"
                                       data-var="hides_balance">
                            </div>
                            <div class="form-group">
                                <label class="control-label">Available After</label>
                                <div class="input-group">
                                    <input type="number"
                                           class="form-control"
                                           data-var="available-after" placeholder="Available After..">
                                    <div class="input-group-addon">
                                        Months
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Line Managers</label>
                                <div class="input-group">
                                    <div class="input-group-addon">
                                        Authority
                                    </div>
                                    <select data-contains="line-manager-authority" class="form-control">
                                        <option value="approve">Approve</option>
                                        <option value="review">Review</option>
                                    </select>
                                    <div class="input-group-btn">
                                        <button type="button" role="button" class="btn btn-dark"
                                                data-click="add-line-manager">Add
                                        </button>
                                    </div>
                                </div>
                                <ul data-contains="line-managers" class="list-group collapse">
                                </ul>
                            </div>
                            <div class="form-group">
                                <button type="button" role="button" data-click="add-specifics"
                                        data-click-param="leave"
                                        class="btn btn-dark">Add Policy
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-warning" data-contains="alarm" style="display:none;">
                        This custom policy is already added.
                    </div>
                    <hr>
                    <form method="post" action="{{ URL::action('GroupsController@postUpdateCustomPolicies')}}">
                        {!! csrf_field() !!}
                        <input type="hidden" name="group_id" value="{{$group->id}}">
                        <ul class="list-group" data-contains="specifics">
                            @foreach($group->custom_policies as $customPolicy)
                                <li class="list-group-item">
                                    <strong>{{$customPolicy->name}}</strong>
                                    <a data-removes="#custom_policies_{{$customPolicy->policy_id}}"
                                       class="btn btn-xs btn-red pull-right"
                                       role="button">Delete</a>
                                    <a href="#custom_policies_{{$customPolicy->policy_id}}"
                                       data-toggle="collapse"
                                       class="btn btn-xs btn-dark pull-right"
                                       role="button">Edit</a>
                                    <div class="collapse" id="custom_policies_{{$customPolicy->policy_id}}">
                                        <hr>
                                        @if($customPolicy->type == 'leave')
                                            <div class="form-group">
                                                <label class="control-label">Applicants</label>
                                                <select class="form-control" data-var="applicants" name="customPolicies[{{$customPolicy->policy_id}}][applicants]">
                                                    @foreach(['all','male','female'] as $opt)
                                                        <option value="{{$opt}}" {{($opt==$customPolicy->applicants)?"selected":""}}>{{ucfirst($opt)}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Allowed Days</label>

                                                <input type="number" class="form-control"
                                                       data-var="allowed-days"
                                                       placeholder="Allowed days.."
                                                       name="customPolicies[{{$customPolicy->policy_id}}][allowed_days]"
                                                       value="{{$customPolicy->days}}">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Days Type</label>
                                                <select class="form-control" data-var="days-type"
                                                        name="customPolicies[{{$customPolicy->policy_id}}][days_type]">
                                                    <option value="calender" {{$customPolicy->days_type == 'calender'?'selected':''}}>
                                                        Calender
                                                    </option>
                                                    <option value="working" {{$customPolicy->days_type == 'calender'?'selected':''}}>
                                                        Working
                                                    </option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="deductible" class="control-label">Deductible</label>
                                                <input type="checkbox" name="customPolicies[{{$customPolicy->policy_id}}][deductible]"
                                                       data-var="deductible" {{$customPolicy->deductible == 1?'checked':''}}>
                                            </div>
                                            <div class="form-group">
                                                <label for="hides_balance" class="control-label">Balance hidden in profile</label>
                                                <input type="checkbox" name="customPolicies[{{$customPolicy->policy_id}}][hides_balance]"
                                                       data-var="hides_balance" {{$customPolicy->hides_balance == 1?'checked':''}}>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Available After</label>
                                                <div class="input-group">
                                                    <input type="number"
                                                           class="form-control"
                                                           data-var="available-after" placeholder="Available After.."
                                                           name="customPolicies[{{$customPolicy->policy_id}}][available_after]"
                                                           value="{{$customPolicy->available_after}}">
                                                    <div class="input-group-addon">
                                                        Months
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Line Managers</label>
                                                <div class="input-group">
                                                    <div class="input-group-addon">
                                                        Authority
                                                    </div>
                                                    <select data-contains="line-manager-authority" class="form-control">
                                                        <option value="approve">Approve</option>
                                                        <option value="review">Review</option>
                                                    </select>
                                                    <div class="input-group-btn">
                                                        <button type="button" role="button" class="btn btn-dark"
                                                                data-click="add-line-manager">Add
                                                        </button>
                                                    </div>
                                                </div>
                                                <ul data-contains="line-managers" class="list-group">
                                                    <?php $currentIndex = 1;?>
                                                    @foreach(explode(',',$customPolicy->line_managers) as $lineManager)
                                                        @if(in_array($lineManager,['hr_review','hr_approve']))
                                                            <li class="list-group-item">
                                                                <input name="customPolicies[{{$customPolicy->policy_id}}][line_managers][]"
                                                                       data-var="line-managers" value="{{$lineManager}}"
                                                                       type="hidden">
                                                        <span class="badge badge-active"
                                                              style="float:none;">{{$currentIndex++}}</span>
                                                                HR Administrator
                                                                <select data-changes="authority">
                                                                    <option value="review" {{($lineManager == 'hr_review')?"selected":""}}>
                                                                        Review
                                                                    </option>
                                                                    <option value="approve" {{($lineManager == 'hr_approve')?"selected":""}}>
                                                                        Approve
                                                                    </option>
                                                                </select>
                                                            </li>
                                                        @else
                                                            <li class="list-group-item">
                                                                <input name="customPolicies[{{$customPolicy->policy_id}}][line_managers][]"
                                                                       data-var="line-managers" value="{{$lineManager}}"
                                                                       type="hidden">
                                                                <span class="badge badge-active"
                                                                       style="float:none;">{{ $currentIndex++ }}</span>
                                                                Line Manager: {{ $lineManager }}
                                                                <a id="lm_{{($currentIndex -1)}}"
                                                                   data-removes="#lm_{{($currentIndex -1)}}"
                                                                   class="btn btn-xs btn-red pull-right">Remove</a>
                                                            </li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @else
                                            <div class="form-group">
                                                <label class="control-label">Applicants</label>
                                                <select class="form-control" data-var="applicants" name="customPolicies[{{$customPolicy->policy_id}}][applicants]">
                                                    @foreach(['all','male','female'] as $opt)
                                                        <option value="{{$opt}}" {{($opt==$customPolicy->applicants)?"selected":""}}>{{ucfirst($opt)}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Service Level Agreement</label>
                                                <input type="number" class="form-control"
                                                       data-var="sla"
                                                       name="customPolicies[{{$customPolicy->policy_id}}][sla]"
                                                       placeholder="Service level agreement..."
                                                       value="{{$customPolicy->sla}}">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Available After</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control"
                                                           data-var="available-after"
                                                           name="customPolicies[{{$customPolicy->policy_id}}][available_after]"
                                                           placeholder="Available After.."
                                                           value="{{$customPolicy->available_after}}">
                                                    <div class="input-group-addon">
                                                        Months
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Line Managers</label>
                                                <div class="input-group">
                                                    <div class="input-group-addon">
                                                        Authority
                                                    </div>
                                                    <select data-contains="line-manager-authority" class="form-control">
                                                        <option value="approve">Approve</option>
                                                        <option value="review">Review</option>
                                                    </select>
                                                    <div class="input-group-btn">
                                                        <button type="button" role="button" class="btn btn-dark"
                                                                data-click="add-line-manager">Add
                                                        </button>
                                                    </div>
                                                </div>
                                                <ul data-contains="line-managers" class="list-group">
                                                    <?php $currentIndex = 1;?>
                                                    @foreach(explode(',',$customPolicy->line_managers) as $lineManager)
                                                        @if(in_array($lineManager,['hr_review','hr_approve']))
                                                            <li class="list-group-item">
                                                                <input name="customPolicies[{{$customPolicy->policy_id}}][line_managers][]"
                                                                       data-var="line-managers" value="{{$lineManager}}"
                                                                       type="hidden">
                                                        <span class="badge badge-active"
                                                              style="float:none;">{{$currentIndex++}}</span>
                                                                HR Administrator
                                                                <select data-changes="authority">
                                                                    <option value="review" {{($lineManager == 'hr_review')?"selected":""}}>
                                                                        Review
                                                                    </option>
                                                                    <option value="approve" {{($lineManager == 'hr_approve')?"selected":""}}>
                                                                        Approve
                                                                    </option>
                                                                </select>
                                                            </li>
                                                        @else
                                                            <li class="list-group-item">
                                                                <input name="customPolicies[{{$customPolicy->policy_id}}][line_managers][]"
                                                                       data-var="line-managers" value="{{$lineManager}}"
                                                                       type="hidden">
                                                        <span class="badge badge-active"
                                                              style="float:none;">{{ $currentIndex++ }}</span>
                                                                Line Manager: {{ $lineManager }}
                                                                <a id="lm_{{($currentIndex -1)}}"
                                                                   data-removes="#lm_{{($currentIndex -1)}}"
                                                                   class="btn btn-xs btn-red pull-right">Remove</a>
                                                            </li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                    </div>
                                </li>

                            @endforeach

                        </ul>
                        <div class="form-actions">
                            <button type="submit" class="btn btn-green">
                                Update {{ $group->name }} Custom Policies
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


@endsection