@extends('layout')
@section('actions')
    <div class="btn-group">
        <a href="{{ URL::action('GroupsController@getCreate') }}" class="btn btn-dark">
            Add a Group
        </a>
    </div>
@endsection
@section('title')
    <i class="icon icon-house"></i> Groups Control
@endsection
@section('content')
    <div class="table-responsive">
        <table class="table hr-table table-hover">
            <thead>
            <tr>
                <th> #</th>
                <th> Group</th>
                <th> Scope</th>
                <th> Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php $index = 1; ?>
            @foreach($page['groups'] as $group)
                <tr>
                    <td> {{ $index++ }}</td>
                    <td> {{ $group->name }}</td>
                    <td>
                        <span class="label label-default" data-toggle="tooltip" title="Policies: {{ $group->policies_count }}">P:{{ $group->policies_count }}</span>
                        <span class="label label-primary" data-toggle="tooltip" title="Members: {{ $group->users_count }}">M:{{ $group->users_count }}</span>
                    </td>
                    <td>
                        <div class="hr-actions-cell">
                            <a href="{{ URL::action('GroupsController@getEdit',['id'=>$group->id]) }}"
                               class="btn btn-dark">
                                Edit
                            </a>
                            <button data-toggle="collapse" data-target="#group_users_{{$group->id}}"
                                    class="btn btn-dark">
                                Members
                            </button>
                            <button data-target="#delete_group_{{$group->id}}" data-toggle="modal"
                                    class="btn btn-red">
                                Delete
                            </button>
                            <div class="modal fade" id="delete_group_{{$group->id}}">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-body">
                                            <form class="form" method="post"
                                                  action="{{ URL::action('GroupsController@postDelete') }}">
                                                {!! csrf_field() !!}
                                                <div class="help-block">
                                                    Are you sure you want to delete the Group "{{ $group->name }}"
                                                </div>
                                                <input type="hidden" name="group_id" value="{{$group->id}}">
                                                <div class="form-actions">
                                                    <button type="submit" class="btn btn-red">
                                                        Delete
                                                    </button>
                                                    <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                        Back to safety
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="collapse" id="group_users_{{$group->id}}">
                    <td colspan="4">
                        @if(count($group->unassigned_users))
                            <form class="form-horizontal" method="post"
                                  action="{{ URL::action('GroupsController@postAddUser') }}">
                                {!! csrf_field() !!}
                                <input type="hidden" value="{{ $group->id }}" name="group_id">
                                <div class="form-group">
                                    <label class="control-label col-md-3">Add a user:</label>
                                    <div class="col-md-4">
                                        <select name="user_id" class="form-control col-md-4">
                                            @foreach($group->unassigned_users as $user)
                                                <option value="{{$user->id}}">{{$user->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-md-2">
                                        <button type="submit" role="button" class="btn btn-green">
                                            Add
                                        </button>
                                    </div>
                                </div>
                            </form>
                        @endif
                        <ul class="list-group">
                            @foreach($group->users as $user)
                                <li class="list-group-item list-group-item-default contains-member">
                                    <div class="member-header">
                                        <span class="label label-info">ID: {{$user->employee_id}}</span>
                                        <strong>{{$user->name }}</strong>
                                        <div class="btn-group">
                                            <a href="#" class="btn btn-red btn-sm"
                                               onclick="$('#remove_user{{$user->id}}').submit()">
                                                Remove
                                            </a>
                                            <a href="{{URL::action('UsersController@getEdit',['id'=>$user->id])}}"
                                               class="btn btn-green btn-sm">
                                                View
                                            </a>

                                            <form method="post" id="remove_user{{$user->id}}"
                                                  action="{{ URL::action('GroupsController@postRemoveUser') }}">
                                                {!! csrf_field() !!}
                                                <input type="hidden" name="user_id" value="{{ $user->id }}">
                                                <input type="hidden" name="group_id" value="{{ $group->id }}">
                                            </form>
                                            <form method="post" id="view_user{{$user->id}}"
                                                  action="{{ URL::action('UsersController@getEdit',['id'=>$user->id]) }}">
                                            </form>
                                        </div>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection