@extends('layout')
@section('pageCss')
    <link rel="stylesheet" type="text/css" href="{{ URL::asset('assets/css/vendor/select2/select2.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ URL::asset('assets/css/vendor/international.phones.css') }}">
    <script src="{{ URL::asset('assets/js/countries.js') }}" type="text/javascript"></script>
@endsection
@section('pageScripts')
    <script src="{{ URL::asset('assets/js/vendor/international.phones.min.js') }}"></script>
    <script src="{{ URL::asset('assets/js/vendor/international.phones.utility.js') }}"></script>
    <script src="http://maps.googleapis.com/maps/api/js?sensor=false&libraries=places"></script>
    <script src="{{ URL::asset('assets/js/vendor/geocomplete.js') }}"></script>
    <script>
        $('input[type="tel"]').intlTelInput({
            separateDialCode: true
        });
        $('#company_phone').change(function () {
            $('input[name="company_phone"]').val($("#company_phone").intlTelInput("getNumber"));
        });
        $('#home_country_contact_number').change(function () {
            $('input[name="home_country_contact_number"]').val($("#home_country_contact_number").intlTelInput("getNumber"));
        });
    </script>
    @include('admin.database.users.scripts.edit')
    @include('admin.database.scripts.custom_policies')
@endsection
@section('title')
    {{$user->name}}
@endsection
@section('content')
    <div class="col-md-3">
        <ul class="nav nav-pills-stacked margin-bottom-10">
            <li class="active">
                <a data-toggle="tab" href="#tab-login">
                    <i class="fa fa-key"></i> Login Details
                </a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab-personal">
                    <i class="fa fa-user"></i> Personal Information
                </a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab-details">
                    <i class="fa fa-briefcase"></i> Employee Details
                </a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab-job">
                    <i class="fa fa-suitcase"></i> Job Information
                </a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab-managers">
                    <i class="fa fa-users"></i> Line Managers
                </a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab-compensations">
                    <i class="fa fa-money"></i> Compensation and Benefits
                </a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab-leaves">
                    <i class="fa fa-sign-out"></i> Leave Balances
                </a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab-policies">
                    <i class="fa fa-cogs"></i> Custom Policies
                </a>
            </li>
        </ul>
    </div>
    <div class="col-md-9">
        <div class="tab-content">
            <div id="tab-login" class="tab-pane active">
                <form role="form" method="post" action="{{ URL::action('UsersController@postUpdateUserDetails')}}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    <input type="hidden" name="case" value="login_email">
                    <div class="form-group">
                        <label class="control-label">Company Email</label>
                        <div class="input-group">
                            <input name="company_email" type="text" placeholder="Company Email..."
                                   value="{{ $user->company_email }}" class="form-control"/>
                            <div class="input-group-btn">
                                <button type="submit" class="btn btn-green">Update Email</button>
                            </div>
                        </div>
                    </div>
                </form>
                <form role="form" method="post" action="{{ URL::action('UsersController@postUpdateUserDetails')}}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    <input type="hidden" name="case" value="login_password">
                    <div class="form-group">
                        <label class="control-label">Password</label>
                        <div class="input-group">
                            <input name="password" type="password" placeholder="********" class="form-control"/>
                            <div class="input-group-btn">
                                <button type="submit" class="btn btn-green">Update Password</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div id="tab-details" class="tab-pane">
                <form role="form" method="post" action="{{ URL::action('UsersController@postUpdateUserDetails')}}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    <input type="hidden" name="case" value="general">
                    <div class="form-group">
                        <label class="control-label">Name</label>
                        <input name="name" type="text" placeholder="Name..." value="{{ $user->name }}"
                               class="form-control"/>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Employee ID</label>
                        <input name="employee_id" type="text" placeholder="Employee ID..."
                               value="{{ $user->employee_id }}"
                               class="form-control"/>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Company Contact Number</label>
                        <input id="company_phone" type="tel" class="form-control"
                               value="{{ $user->company_phone }}"/>
                        <input type="hidden" name="company_phone" value="{{ $user->company_phone }}">
                    </div>
                    <div class="form-group">
                        <label class="control-label">Company P.O. Box</label>
                        <input name="company_po_box" type="text" placeholder="Company P.O. Box"
                               value="{{ $user->company_po_box }}"
                               class="form-control"/>
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn btn-green">
                            Update Employee Details
                        </button>
                    </div>
                </form>
            </div>
            <div id="tab-personal" class="tab-pane">
                <form method="post" action="{{ URL::action('UsersController@postUpdateUserDetails')}}" role="form">
                    {!! csrf_field()!!}
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    <input type="hidden" name="case" value="personal">

                    <div class="form-group">
                        <label class="control-label">Gender</label>
                        <select name="gender" class="form-control" name="select">
                            @foreach(['male','female'] as $sel_opt)
                                @if($user->gender == $sel_opt)
                                    <option value="{{ $sel_opt }}"
                                            selected>{{ \Illuminate\Support\Str::studly($sel_opt) }}
                                    </option>
                                @else
                                    <option value="{{ $sel_opt }}">{{ \Illuminate\Support\Str::studly($sel_opt) }}
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Email</label>
                        <input name="email" type="email" placeholder="Personal Email..." value="{{ $user->email }}"
                               class="form-control"/>
                    </div>
                    <div class="form-group">
                        <label for="religion" class="control-label">Religion
                        </label>
                        <select class="form-control" name="religion" id="religion">
                            @foreach($page->religions as $sel_opt)
                                @if($sel_opt->id == $user->religion_id)
                                    <option value="{{$sel_opt->id}}" selected>{{$sel_opt->name}}</option>
                                @else
                                    <option value="{{$sel_opt->id}}">{{$sel_opt->name}}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group geo-container">
                        <label for="current_address" class="control-label">
                            Current Address
                        </label>
                        <input type="text" name="current_address" class="form-control" id="geo-current-country"
                               value="{{$user->current_address}}">

                        <div class="geo-current-map-canvas"></div>
                    </div>
                    <div class="form-group geo-container">
                        <label class="control-label">Home Country Address</label>
                        <input type="text" name="home_country_address" placeholder="Home Country Address..."
                               value="{{ $user->home_country_address }}" class="form-control"
                               id="geo-home-country"/>

                        <div class="geo-home-map-canvas"></div>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Home Country Contact Number</label>
                        <input id="home_country_contact_number" type="tel"
                               value="{{ $user->home_country_contact_number }}" class="form-control"/>
                        <input type="hidden" name="home_country_contact_number"
                               value="{{ $user->home_country_contact_number }}">
                    </div>
                    <div class="form-group">
                        <label class="control-label">Home Country P.O. Box</label>
                        <input type="text" name="original_po_box"
                               placeholder="Home Country P.O. Box..."
                               value="{{ $user->original_po_box }}" class="form-control"/>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Nationality</label>
                        <select class="form-control" id="nationality" name="nationality">
                        </select>
                        <script>
                            populateCountries('nationality', null, '{{ $user->nationality }}');
                        </script>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Marital Status</label>
                        <select class="form-control" name="marital_status">
                            @foreach(['single','married','separated','divorced','widowed'] as $sel_opt)
                                @if($user->marital_status == $sel_opt)
                                    <option value="{{ $sel_opt }}"
                                            selected>{{ \Illuminate\Support\Str::studly($sel_opt) }}
                                    </option>
                                @else
                                    <option value="{{ $sel_opt }}">{{ \Illuminate\Support\Str::studly($sel_opt) }}
                                    </option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Visa Expiry Date</label>
                        <input type="text" name="visa_expiry_date"
                               placeholder="Visa Expiry Date"
                               value="{{ $user->visa_expiry_date }}" class="form-control has-date-picker"/>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Medical Insurance Expiry date</label>
                        <input type="text" name="medical_insurance_expiry_date"
                               placeholder="Medical Insurance Expiry Date"
                               value="{{ $user->medical_insurance_expiry_date }}"
                               class="form-control has-date-picker"/>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn btn-green">
                            Update Personal Information
                        </button>
                    </div>
                </form>
            </div>
            <div id="tab-job" class="tab-pane">
                <form method="post" action="{{ URL::action('UsersController@postUpdateUserDetails')}}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    <input type="hidden" name="case" value="job">
                    <div class="form-group">
                        <label class="control-label">Department</label>
                        <select class="form-control" name="department_id">
                            <option value="-1">Not Assigned</option>
                            @foreach($page->departments as $sel_opt)
                                @if($user->department_id == $sel_opt->id)
                                    <option value="{{ $sel_opt->id }}" selected>{{ $sel_opt->name }}</option>
                                @else
                                    <option value="{{ $sel_opt->id }}">{{ $sel_opt->name }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Group</label>
                        <select class="form-control" name="group_id">
                            <option value="-1">Not Assigned</option>
                            @foreach($page->groups as $sel_opt)
                                @if($user->group_id == $sel_opt->id)
                                    <option value="{{ $sel_opt->id }}" selected>{{ $sel_opt->name }}</option>
                                @else
                                    <option value="{{ $sel_opt->id }}">{{ $sel_opt->name }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Title</label>
                        <input type="text" name="title" placeholder="Title..." value="{{ $user->title }}"
                               class="form-control"/>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Join Date</label>
                        <input type="text" name="join_date" value="{{ $user->join_date }}"
                               class="form-control has-date-picker"/>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Project/ Location</label>
                        <select name="location_id" class="form-control">
                            @foreach($page->locations as $sel_opt)
                                @if($user->location_id == $sel_opt->id)
                                    <option value="{{$sel_opt->id}}" selected>{{ $sel_opt->name }}</option>
                                @else
                                    <option value="{{$sel_opt->id}}">{{ $sel_opt->name }}</option>
                                @endif
                            @endforeach
                        </select>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn btn-green">
                            Update Job Information
                        </button>
                    </div>
                </form>
            </div>
            <div id="tab-managers" class="tab-pane">
                <form method="post" action="{{URL::action('UsersController@postUpdateUserHandlingDetails')}}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    <div class="col-md-4">
                        <div class="portal">
                            <div class="portal-title">
                                <div class="caption">Select a User</div>
                            </div>
                            <div class="portal-body" id="add_handling_routine_selections">
                                <label class="control-label">User</label>
                                <label for="user_sel"></label>
                                <select class="form-control clearfix" id="user_sel" name="user_sel">
                                    @foreach($page->users as $item)
                                        @if($user->id != $item->id)
                                            <option value="{{$item->id}}">{{$item->name}}</option>
                                        @endif
                                    @endforeach
                                </select>
                                <div class="form-actions">
                                    <a href="#" onclick="AddHandlingRoutine();" style="margin-top:10px;"
                                       class="btn btn-dark" id="add_handling_routine">Add</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="portal contain_routines">
                            <div class="portal-title">
                                <div class="caption">Manage Order</div>
                            </div>
                            <div class="portal-body">
                                <ul class="list-group" id="handling_routines">
                                    @if(isset($user->managers) && is_array($user->managers))
                                        <?php $i = 1; ?>
                                        @foreach($user->managers as $manager)
                                            <li class="list-group-item">
                                                <span class="label label-info">Line Manager#:{{ ($i) }} </span>
                                                <span class="label label-primary"> {{ $manager->name }}</span>
                                                <button role="button" type="button"
                                                        class="btn pull-right btn-xs btn-danger"
                                                        data-removes="li">
                                                    <i class="fa fa-minus"></i>
                                                    Remove
                                                </button>
                                                <input type="hidden"
                                                       name="manager[{{$i}}]"
                                                       value="{{$manager->id}}">
                                            </li>
                                            <?php $i++;?>
                                        @endforeach
                                    @endif
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="form-actions col-md-12">
                        <button type="submit" class="btn btn-green">
                            Update Line Managers
                        </button>
                    </div>
                </form>
            </div>
            <div id="tab-leaves" class="tab-pane">
                <form method="post" class="form-horizontal"
                      action="{{ URL::action('UsersController@postUpdateLeaveBalances')}}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    @foreach($user->leave_balances as $leave)
                        <div class="form-group">
                            <label class="control-label col-md-3">{{$leave->name}}</label>
                            <div class="col-md-4">
                                <div class="input-group">
                                    <input type="number" name="leave_balance[{{$leave->id}}]"
                                           class="form-control" value="{{ $leave->value }}">
                                    <div class="input-group-addon">Days</div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    <div class="form-actions">
                        <button type="submit" class="btn btn-green">
                            Update Leave Balance
                        </button>
                    </div>
                </form>
            </div>
            <div id="tab-compensations" class="tab-pane">
                <form method="post" class="form-horizontal"
                      action="{{ URL::action('UsersController@postUpdateCompensationBalance')}}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="user_id" value="{{$user->id}}">
                    @foreach($user->compensations as $compensation)
                        <div class="form-group">
                            <label class="control-label col-md-3">{{$compensation->name}}</label>

                            <div class="col-md-4">
                                <div class="input-group">
                                    <input type="number" name="compensations[{{$compensation->id}}]"
                                           class="form-control" value="{{ $compensation->value }}">
                                    <div class="input-group-addon">{{$page->currency}}</div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    <div class="form-actions">
                        <button type="submit" class="btn btn-green">
                            Update Compensations and Benefits
                        </button>
                    </div>
                </form>
            </div>
            <div id="tab-policies" class="tab-pane">
                <div class="form" data-contains="custom-policies">
                    <!-- Select Specifics -->
                    <div class="form-group">
                        <select data-change="show-specifics" class="form-control">
                            <option>Select</option>
                            <optgroup label="HR Policies">
                                @foreach($page->hrPolicies as $policy)
                                    <option data-type="hr" value="{{$policy->id}}">{{$policy->name}}</option>
                                @endforeach
                            </optgroup>
                            <optgroup label="Leave Policies">
                                @foreach($page->leavePolicies as $policy)
                                    <option data-type="leave" value="{{$policy->id}}">{{$policy->name}}</option>
                                @endforeach
                            </optgroup>
                        </select>
                    </div>
                    <div class="form-group">
                        <!-- HR Specifics Holder -->
                        <div class="collapse" data-contains="hr-specifics">
                            <div class="form-group">
                                <label class="control-label">Applicants</label>
                                <select class="form-control" data-var="applicants">
                                    <option value="all">All</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Service Level Agreement</label>
                                <input type="number" class="form-control"
                                       data-var="sla"
                                       placeholder="Service level agreement...">
                            </div>
                            <div class="form-group">
                                <label class="control-label">Available After</label>
                                <div class="input-group">
                                    <input type="number" class="form-control"
                                           data-var="available-after"
                                           placeholder="Available After..">
                                    <div class="input-group-addon">
                                        Months
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Line Managers</label>
                                <div class="input-group">
                                    <div class="input-group-addon">
                                        Authority
                                    </div>
                                    <select data-contains="line-manager-authority" class="form-control">
                                        <option value="approve">Approve</option>
                                        <option value="review">Review</option>
                                    </select>
                                    <div class="input-group-btn">
                                        <button type="button" role="button" class="btn btn-dark"
                                                data-click="add-line-manager">Add
                                        </button>
                                    </div>
                                </div>
                                <ul data-contains="line-managers" class="list-group collapse">
                                </ul>
                            </div>
                            <div class="form-group">
                                <button type="button" role="button" data-click="add-specifics" data-click-param="hr"
                                        class="btn btn-dark">Add Policy
                                </button>
                            </div>
                        </div>
                        <!-- Leave Specifics Holder -->
                        <div class="collapse" data-contains="leave-specifics">
                            <div class="form-group">
                                <label class="control-label">Applicants</label>
                                <select class="form-control" data-var="applicants">
                                    <option value="all">All</option>
                                    <option value="male">Male</option>
                                    <option value="female">Female</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Allowed Days</label>

                                <input type="number" class="form-control"
                                       data-var="allowed-days"
                                       placeholder="Allowed days..">
                            </div>
                            <div class="form-group">
                                <label class="control-label">Days Type</label>

                                <select class="form-control" data-var="days-type">
                                    <option value="calender" selected>Calender</option>
                                    <option value="working">Working</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="deductible" class="control-label">Deductible</label>
                                <input type="checkbox"
                                       data-var="deductible">
                            </div>
                            <div class="form-group">
                                <label for="hides_balance" class="control-label">Balance hidden in profile</label>
                                <input type="checkbox"
                                       data-var="hides_balance">
                            </div>
                            <div class="form-group">
                                <label class="control-label">Available After</label>
                                <div class="input-group">
                                    <input type="number"
                                           class="form-control"
                                           data-var="available-after" placeholder="Available After..">
                                    <div class="input-group-addon">
                                        Months
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label">Line Managers</label>
                                <div class="input-group">
                                    <div class="input-group-addon">
                                        Authority
                                    </div>
                                    <select data-contains="line-manager-authority" class="form-control">
                                        <option value="approve">Approve</option>
                                        <option value="review">Review</option>
                                    </select>
                                    <div class="input-group-btn">
                                        <button type="button" role="button" class="btn btn-dark"
                                                data-click="add-line-manager">Add
                                        </button>
                                    </div>
                                </div>
                                <ul data-contains="line-managers" class="list-group collapse">
                                </ul>
                            </div>
                            <div class="form-group">
                                <button type="button" role="button" data-click="add-specifics"
                                        data-click-param="leave"
                                        class="btn btn-dark">Add Policy
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-warning" data-contains="alarm" style="display:none;">
                        This custom policy is already added.
                    </div>
                    <hr>
                    <form method="post" action="{{ URL::action('UsersController@postUpdateCustomPolicies')}}">
                        {!! csrf_field() !!}
                        <input type="hidden" name="user_id" value="{{$user->id}}">
                        <ul class="list-group" data-contains="specifics">
                            @foreach($user->custom_policies as $customPolicy)
                                <li class="list-group-item">
                                    <strong>{{$customPolicy->name}}</strong>
                                    <a data-removes="#custom_policies_{{$customPolicy->policy_id}}"
                                       class="btn btn-xs btn-red pull-right"
                                       role="button">Delete</a>
                                    <a href="#custom_policies_{{$customPolicy->policy_id}}"
                                       data-toggle="collapse"
                                       class="btn btn-xs btn-dark pull-right"
                                       role="button">Edit</a>
                                    <div class="collapse" id="custom_policies_{{$customPolicy->policy_id}}">
                                        <hr>
                                        @if($customPolicy->type == 'leave')
                                            <div class="form-group">
                                                <label class="control-label">Applicants</label>
                                                <select class="form-control" data-var="applicants"
                                                        name="customPolicies[{{$customPolicy->policy_id}}][applicants]">
                                                    @foreach(['all','male','female'] as $opt)
                                                        <option value="{{$opt}}" {{($opt==$customPolicy->applicants)?"selected":""}}>{{ucfirst($opt)}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Allowed Days</label>

                                                <input type="number" class="form-control"
                                                       data-var="allowed-days"
                                                       placeholder="Allowed days.."
                                                       name="customPolicies[{{$customPolicy->policy_id}}][allowed_days]"
                                                       value="{{$customPolicy->days}}">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Days Type</label>
                                                <select class="form-control" data-var="days-type"
                                                        name="customPolicies[{{$customPolicy->policy_id}}][days_type]">
                                                    <option value="calender" {{$customPolicy->days_type == 'calender'?'selected':''}}>
                                                        Calender
                                                    </option>
                                                    <option value="working" {{$customPolicy->days_type == 'calender'?'selected':''}}>
                                                        Working
                                                    </option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="deductible" class="control-label">Deductible</label>
                                                <input type="checkbox" name="customPolicies[{{$customPolicy->policy_id}}][deductible]"
                                                       data-var="deductible" {{$customPolicy->deductible == 1?'checked':''}}>
                                            </div>
                                            <div class="form-group">
                                                <label for="hides_balance" class="control-label">Balance hidden in profile</label>
                                                <input type="checkbox" name="customPolicies[{{$customPolicy->policy_id}}][hides_balance]"
                                                       data-var="hides_balance" {{$customPolicy->hides_balance == 1?'checked':''}}>
                                            </div>
                                            <div class="form-group">
                                                <label for="hides_balance" class="control-label">Balance hidden in profile</label>
                                                <input type="checkbox"
                                                       data-var="hides_balance" {{$customPolicy->hides_balance == 1?'checked':''}}>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Available After</label>
                                                <div class="input-group">
                                                    <input type="number"
                                                           class="form-control"
                                                           data-var="available-after" placeholder="Available After.."
                                                           name="customPolicies[{{$customPolicy->policy_id}}][available_after]"
                                                           value="{{$customPolicy->available_after}}">
                                                    <div class="input-group-addon">
                                                        Months
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Line Managers</label>
                                                <div class="input-group">
                                                    <div class="input-group-addon">
                                                        Authority
                                                    </div>
                                                    <select data-contains="line-manager-authority" class="form-control">
                                                        <option value="approve">Approve</option>
                                                        <option value="review">Review</option>
                                                    </select>
                                                    <div class="input-group-btn">
                                                        <button type="button" role="button" class="btn btn-dark"
                                                                data-click="add-line-manager">Add
                                                        </button>
                                                    </div>
                                                </div>
                                                <ul data-contains="line-managers" class="list-group">
                                                    <?php $currentIndex = 1;?>
                                                    @foreach(explode(',',$customPolicy->line_managers) as $lineManager)
                                                        @if(in_array($lineManager,['hr_review','hr_approve']))
                                                            <li class="list-group-item">
                                                                <input name="customPolicies[{{$customPolicy->policy_id}}][line_managers][]"
                                                                       data-var="line-managers" value="{{$lineManager}}"
                                                                       type="hidden">
                                                        <span class="badge badge-active"
                                                              style="float:none;">{{$currentIndex++}}</span>
                                                                HR Administrator
                                                                <select data-changes="authority">
                                                                    <option value="review" {{($lineManager == 'hr_review')?"selected":""}}>
                                                                        Review
                                                                    </option>
                                                                    <option value="approve" {{($lineManager == 'hr_approve')?"selected":""}}>
                                                                        Approve
                                                                    </option>
                                                                </select>
                                                            </li>
                                                        @else
                                                            <li class="list-group-item">
                                                                <input name="customPolicies[{{$customPolicy->policy_id}}][line_managers][]"
                                                                       data-var="line-managers" value="{{$lineManager}}"
                                                                       type="hidden">
                                                                <span class="badge badge-active"
                                                                      style="float:none;">{{ $currentIndex++ }}</span>
                                                                Line Manager: {{ $lineManager }}
                                                                <a id="lm_{{($currentIndex -1)}}"
                                                                   data-removes="#lm_{{($currentIndex -1)}}"
                                                                   class="btn btn-xs btn-red pull-right">Remove</a>
                                                            </li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @else
                                            <div class="form-group">
                                                <label class="control-label">Applicants</label>
                                                <select class="form-control" data-var="applicants"
                                                        name="customPolicies[{{$customPolicy->policy_id}}][applicants]">
                                                    @foreach(['all','male','female'] as $opt)
                                                        <option value="{{$opt}}" {{($opt==$customPolicy->applicants)?"selected":""}}>{{ucfirst($opt)}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Service Level Agreement</label>
                                                <input type="number" class="form-control"
                                                       data-var="sla"
                                                       name="customPolicies[{{$customPolicy->policy_id}}][sla]"
                                                       placeholder="Service level agreement..."
                                                       value="{{$customPolicy->sla}}">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Available After</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control"
                                                           data-var="available-after"
                                                           name="customPolicies[{{$customPolicy->policy_id}}][available_after]"
                                                           placeholder="Available After.."
                                                           value="{{$customPolicy->available_after}}">
                                                    <div class="input-group-addon">
                                                        Months
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Line Managers</label>
                                                <div class="input-group">
                                                    <div class="input-group-addon">
                                                        Authority
                                                    </div>
                                                    <select data-contains="line-manager-authority" class="form-control">
                                                        <option value="approve">Approve</option>
                                                        <option value="review">Review</option>
                                                    </select>
                                                    <div class="input-group-btn">
                                                        <button type="button" role="button" class="btn btn-dark"
                                                                data-click="add-line-manager">Add
                                                        </button>
                                                    </div>
                                                </div>
                                                <ul data-contains="line-managers" class="list-group">
                                                    <?php $currentIndex = 1;?>
                                                    @foreach(explode(',',$customPolicy->line_managers) as $lineManager)
                                                        @if(in_array($lineManager,['hr_review','hr_approve']))
                                                            <li class="list-group-item">
                                                                <input name="customPolicies[{{$customPolicy->policy_id}}][line_managers][]"
                                                                       data-var="line-managers" value="{{$lineManager}}"
                                                                       type="hidden">
                                                        <span class="badge badge-active"
                                                              style="float:none;">{{$currentIndex++}}</span>
                                                                HR Administrator
                                                                <select data-changes="authority">
                                                                    <option value="review" {{($lineManager == 'hr_review')?"selected":""}}>
                                                                        Review
                                                                    </option>
                                                                    <option value="approve" {{($lineManager == 'hr_approve')?"selected":""}}>
                                                                        Approve
                                                                    </option>
                                                                </select>
                                                            </li>
                                                        @else
                                                            <li class="list-group-item">
                                                                <input name="customPolicies[{{$customPolicy->policy_id}}][line_managers][]"
                                                                       data-var="line-managers" value="{{$lineManager}}"
                                                                       type="hidden">
                                                        <span class="badge badge-active"
                                                              style="float:none;">{{ $currentIndex++ }}</span>
                                                                Line Manager: {{ $lineManager }}
                                                                <a id="lm_{{($currentIndex -1)}}"
                                                                   data-removes="#lm_{{($currentIndex -1)}}"
                                                                   class="btn btn-xs btn-red pull-right">Remove</a>
                                                            </li>
                                                        @endif
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif
                                    </div>
                                </li>

                            @endforeach

                        </ul>
                        <div class="form-actions">
                            <button type="submit" class="btn btn-green">
                                Update {{ $user->name }} Custom Policies
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection