@extends('layout')

@section('pageCss')
    <link rel="stylesheet" type="text/css" href="{{ URL::asset('assets/css/vendor/international.phones.css') }}">
    <script src="{{ URL::asset('assets/js/countries.js') }}" type="text/javascript"></script>
@endsection
@section('pageScripts')
    <script src="{{ URL::asset('assets/js/vendor/validate.min.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/validate.additional.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/bootstrap.wizard.min.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/international.phones.min.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/international.phones.utility.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/select2.min.js')}}" type="text/javascript"></script>
    <script src="http://maps.googleapis.com/maps/api/js?sensor=false&libraries=places"></script>
    <script src="{{ URL::asset('assets/js/vendor/geocomplete.js')}}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/user.wizard.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/utility.js') }}" type="text/javascript"></script>
    @include('admin.database.scripts.custom_policies')
    <script>
        $('.select2-choice').select2();
        $('input[type="tel"]').intlTelInput({
            separateDialCode: true
        });
    </script>
    <script>
        FormWizard.init();
        $("#handling_routines").sortable({
            snap: '.list-group-item',
            containment: '.contain_routines',
            update: function (event, ui) {
                $('#handling_routines li').each(function () {
                    $(this).children('span:first-child').html("Line Manager#: " + $(this).index())
                })
            }
        });
        function removeHandlingRoutine(id) {
            $("#handling_routine_" + id).remove();
        }
        function AddHandlingRoutine() {
            var id = parseInt($('#user_sel').val());
            var _index = $("#handling_routines > li").length;
            var list_items = $("#handling_routines li");
            var can_continue = true;
            list_items.each(function (idx, li) {
                if (id == $("input[name='handling_routine[" + idx + "][user_id]']").val()) can_continue = false;
            });
            $('#add_handler_error').remove();
            if (!can_continue) {
                $('#add_handling_routine_selections').append('<div id="add_handler_error" class="alert alert-danger display-hide" style="display: block;">' +
                        '<button class="close" data-close="alert"></button>' +
                        'The user is already added to the list.' +
                        '</div>');

                return;
            }
            else {
                $('#add_handler_error').remove();
            }

            $("#handling_routines").append(
                    '<li class="list-group-item" id="handling_routine_' + _index + '">' +
                    '<span class="label label-info">Line Manager#:' + _index + '</span>' +
                    '<span class="label label-primary">' + $("#user_sel option:selected").text() + '</span>' +
                    '<button role="button" type="button" class="btn pull-right btn-xs btn-danger" onclick="removeHandlingRoutine(' + _index + ')"><i class="fa fa-minus"></i> Remove</button> ' +
                    '<input type="hidden" name="handling_routine[' + _index + '][user_id]" value="' + id + '">' +
                    '<input type="hidden" name="handling_routine[' + _index + '][user_auth]" value="' + $('#user_auth').val() + '">' +
                    '</li>'
            );

        }
        $('.geo-current-map-canvas').height(300);
        $('.geo-home-map-canvas').height(300);
        $('.geo-current-country').geocomplete({
            map: $('.geo-current-map-canvas')
        });
        $('.geo-home-country').geocomplete({
            map: $('.geo-home-map-canvas')
        });
    </script>
@endsection
@section('title')
    <i class="icon icon-employees"></i> Employees
@endsection
@section('actions')
    <div class="btn-group">
        <button type="button" class="btn btn-dark dropdown-toggle" data-toggle="dropdown"
                data-hover="dropdown" data-delay="1000" data-close-others="true">
            Actions <i class="fa fa-angle-down"></i>
        </button>

        <ul class="dropdown-menu pull-right" role="menu">
            <li>
                @if($page->hasReligion && $page->hasLocation && count($page->groups) && count($page->departments))
                    <a href="#new_request_wizard" data-toggle="collapse">
                        <i class="fa fa-plus"></i>Add Users
                    </a>
                @endif

                <a onclick="$('#export_users').submit();">
                    <i class="fa fa-plus"></i>Export Users
                </a>
                @if($page->hasReligion && $page->hasLocation && count($page->groups) && count($page->departments))
                    <a href="#import_users_modal" data-toggle="modal">
                        <i class="fa fa-plus"></i>Import Users
                    </a>
                @endif
            </li>
        </ul>
    </div>
    <form method="post" id="export_users" action="{{ URL::action('ExchangeController@postExportUsers') }}">
        {!! csrf_field() !!}
    </form>
    @if($page->hasReligion && $page->hasLocation && count($page->groups) && count($page->departments))
        <div id="import_users_modal" class="modal fade">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-title">
                        Import from an Excel file
                    </div>
                    <div class="modal-body">
                        <div class="form">
                            <form method="post" enctype="multipart/form-data"
                                  action="{{ URL::action('ExchangeController@postImportUsers') }}">
                                {!! csrf_field() !!}
                                <div class="form-group">
                                    <label class="form-control">
                                        Select a file
                                    </label>
                                    <input type="file" name="file_excel">
                                </div>
                                <div class="form-actions">
                                    <button type="submit" class="btn btn-success">
                                        Import
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
@endsection
@section('content')
    <ul class="list-group center-block">
        <li class="list-group-item">
            <strong> You have {{$page->activeUsersCount}}/{{$page->companyUsersCapacity}} Active Employees,
                Total: {{ $page->totalUsersCount }} Employees </strong>
        </li>
        @if($page->hasLocation == false)
            <li class="list-group-item list-group-item-warning">
                 You need to setup at least 1 <strong>Location</strong> for your company to start adding employees
                ,you can do so from <a href="{{URL::action('LocationController@getAddLocation')}}">here</a>
            </li>
        @endif
        @if($page->hasReligion == false)
            <li class="list-group-item list-group-item-warning">
                 You need to setup at least 1 <strong>Religion</strong> for your company to start adding employees
                ,you can do so from <a href="{{URL::action('ReligionController@getAddReligion')}}">here</a>
            </li>
        @endif
        @if(count($page->groups) == 0)
            <li class="list-group-item list-group-item-warning">
                 You need to setup at least 1 <strong>Group</strong> for your company to start adding employees
                ,you can do so from <a href="{{URL::action('GroupsController@getCreate')}}">here</a>
            </li>
        @endif
        @if(count($page->departments) == 0)
            <li class="list-group-item list-group-item-warning">
                You need to setup at least 1 <strong>Department</strong> for your company to start adding employees
                ,you can do so from <a href="{{URL::action('DepartmentsController@getCreate')}}">here</a>
            </li>
        @endif
    </ul>
    @if($page->hasReligion && $page->hasLocation && count($page->groups) && count($page->departments))
        <div class="portal collapse" id="new_request_wizard">
            <div class="portal-title">
                <div class="caption">
                    <i class="fa fa-plus"></i> Add a new User
                </div>
                <div class="tools">
                    <a href="#new_request_wizard" data-toggle="collapse">
                        <i class="fa fa-close"></i>
                    </a>
                </div>
            </div>
            <div class="portal-body">
                <form action="{{ URL::action('UsersController@postCreateUser') }}" class="form-horizontal"
                      id="submit_form" method="POST">
                    {!! csrf_field() !!}
                    <div class="portal-form">
                        <div class="wizard-steps">
                            <ul class="nav nav-pills nav-justified ">
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" class="step" aria-expanded="true">
                                        <span class="number">1 </span>
                                        <span class="description">
                                        <i class="fa fa-check"></i>
                                        Account Details
                                    </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#tab2" data-toggle="tab" class="step">
                                        <span class="number">2 </span>
                                        <span class="description"><i class="fa fa-check"></i> Job Information </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#tab3" data-toggle="tab" class="step">
                                        <span class="number">3 </span>
                                        <span class="description"><i
                                                    class="fa fa-check"></i> Personal Information </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#tab4" data-toggle="tab" class="step">
                                        <span class="number">4 </span>
                                        <span class="description"><i class="fa fa-check"></i> Line Managers </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#tab5" data-toggle="tab" class="step">
                                        <span class="number">5 </span>
                                        <span class="description">
                                        <i class="fa fa-check"></i>
                                        Compensation & Benefits
                                    </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#tab6" data-toggle="tab" class="step">
                                        <span class="number">6 </span>
                                        <span class="description"><i class="fa fa-check"></i> Leave Balances </span>
                                    </a>
                                </li>
                                <li>
                                    <a href="#tab7" data-toggle="tab" class="step">
                                        <span class="number">7 </span>
                                        <span class="description"><i class="fa fa-check"></i> Custom Policies </span>
                                    </a>
                                </li>

                            </ul>
                        </div>
                        <div class="progress progress-striped wizard-bar" role="progressbar">
                            <div class="progress-bar progress-bar-success">
                            </div>
                        </div>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <h3 class="block">Provide the new Employee details
                                </h3>

                                <div class="form-group">
                                    <label class="control-label col-md-3">Name
                                        <span class="required" aria-required="true"> * </span>
                                    </label>

                                    <div class="input-group col-md-4">
                                        <input required type="text" class="form-control" name="name"
                                               placeholder="Employee Name...">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">Employee ID
                                        <span class="required" aria-required="true"> * </span>
                                    </label>

                                    <div class="input-group col-md-4">
                                        <input required type="text" class="form-control" name="employee_id"
                                               placeholder="Employee ID...">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="control-label col-md-3">Company Email (Used for Sign In)
                                        <span class="required" aria-required="true"> * </span>
                                    </label>

                                    <div class="input-group col-md-4">
                                        <input required type="email" class="form-control" name="email"
                                               placeholder="Company Email...">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="department_id" class="control-label col-md-3">Department
                                        <span class="required" aria-required="true"> * </span>
                                    </label>

                                    <div class="input-group col-md-4">
                                        <select id="department_id" class="form-control" name="department_id">
                                            @foreach($page->departments as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="group_id" class="control-label col-md-3">Group
                                        <span class="required" aria-required="true"> * </span>
                                    </label>

                                    <div class="input-group col-md-4">
                                        <select id="group_id" class="form-control" name="group_id">
                                            @foreach($page->groups as $item)
                                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2">
                                <h3 class="block">Kindly specify the Job Information for the Employee</h3>
                                <div class="form-group">
                                    <label class="control-label col-md-3">Title</label>

                                    <div class="col-md-4">
                                        <input type="text" name="title" class="form-control"
                                               placeholder="Employee title...">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">Join Date</label>

                                    <div class="col-md-4">
                                        <input type="text" name="join_date" class="form-control has-date-picker"
                                               placeholder="Join Date">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">Project/ Location</label>
                                    <div class="col-md-4">
                                        <select name="project" class="form-control">
                                            @foreach($page->locations as $sel_opt)
                                                <option value="{{$sel_opt->id}}">{{ $sel_opt->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab3">
                                <h3 class="block">Employee Personal Information</h3>

                                <div class="form-group">
                                    <label for="gender" class="control-label col-md-3">Gender
                                    </label>

                                    <div class="input-group col-md-4">
                                        <select class="form-control" name="gender" id="gender">
                                            <option value="male">Male</option>
                                            <option value="female">Female</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3"> Personal Email
                                    </label>

                                    <div class="input-group col-md-4">
                                        <input required type="email" class="form-control" name="personal_email"
                                               placeholder="Personal email...">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="religion" class="control-label col-md-3">Religion
                                    </label>

                                    <div class="input-group col-md-4">
                                        <select class="form-control" name="religion" id="religion">
                                            @foreach($page->religions as $sel_opt)
                                                <option value="{{$sel_opt->id}}">{{$sel_opt->name}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group geo-container">
                                    <label class="control-label col-md-3"> Current Address
                                    </label>

                                    <div class="input-group col-md-4">
                                        <input required type="text" class="form-control geo-current-country"
                                               name="current_address"
                                               placeholder="Current Address...">
                                    </div>
                                    <div class="col-md-4 col-md-push-3 geo-current-map-canvas"></div>
                                </div>
                                <div class="form-group geo-container">
                                    <label class="control-label col-md-3">Home Country Address
                                    </label>

                                    <div class="input-group col-md-4">
                                        <input required type="text" class="form-control geo-home-country"
                                               name="home_country_address"
                                               placeholder="Home country address...">
                                    </div>
                                    <div class="col-md-4 col-md-push-3 geo-home-map-canvas"></div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">
                                        Contact Number ( Mobile/ Landline )
                                    </label>
                                    <div class="input-group col-md-4">
                                        <input required type="tel" class="form-control" name="company_phone">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">P.O. Box</label>

                                    <div class="input-group col-md-4">
                                        <input type="text" class="form-control" name="company_po_box">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">Home Country Contact Number
                                    </label>

                                    <div class="col-md-4">
                                        <input required type="tel" class="form-control"
                                               name="original_phone">
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label class="control-label col-md-3">Home Country P.O. Box</label>
                                    <div class="col-md-4">
                                        <input type="text" class="form-control" name="original_po_box">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="nationality" class="control-label col-md-3">Nationality
                                    </label>

                                    <div class="input-group col-md-4">
                                        <select id="nationality" class="form-control" name="nationality">
                                        </select>
                                        <script>
                                            populateCountries('nationality');
                                        </script>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="martial_status" class="control-label col-md-3">Marital Status
                                    </label>

                                    <div class="input-group col-md-4">
                                        <select id="martial_status" class="form-control" name="marital_status">
                                            <option value="male">Single</option>
                                            <option value="female">Married</option>
                                            <option value="female">Separated</option>
                                            <option value="female">Divorced</option>
                                            <option value="female">Widowed</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">Visa Expiry Date</label>
                                    <div class="col-md-4">
                                        <input type="text" name="visa_expiry_date" class="form-control has-date-picker">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label col-md-3">Medical Insurance Expiry Date</label>
                                    <div class="col-md-4">
                                        <input type="text" name="medical_insurance_expiry_date"
                                               class="form-control has-date-picker">
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab4">
                                <h3 class="block">Specify the Line Managers for this Employee</h3>

                                <div class="form-group">
                                    <div class="col-md-6">
                                        <div class="panel panel-success">
                                            <div class="panel-heading">
                                                <h3 class="panel-title">Select an Employee</h3>
                                            </div>
                                            <div class="panel-body" id="add_handling_routine_selections">
                                                <label class="control-label">User</label>
                                                <label for="user_sel"></label><select class="form-control clearfix"
                                                                                      id="user_sel" name="user_sel">
                                                    @foreach($page->users as $item)
                                                        <option value="{{$item->id}}">{{$item->name}}</option>
                                                    @endforeach
                                                </select>
                                                <a href="#" onclick="AddHandlingRoutine();" style="margin-top:10px;"
                                                   class="btn btn-success" id="add_handling_routine">Add</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="panel panel-success contain_routines">
                                            <div class="panel-heading">
                                                <h3 class="panel-title">Manage Order</h3>
                                            </div>
                                            <div class="panel-body">
                                                <ul class="list-group">

                                                </ul>
                                                <ul class="list-group" id="handling_routines">
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="tab-pane" id="tab5">
                                <h3 class="block">Fill in the employee compensation and benefits</h3>
                                @foreach($compensations as $compensation)
                                    <div class="form-group">
                                        <label class="control-label col-md-3">{{$compensation->name}}</label>

                                        <div class="col-md-4">
                                            <input type="number" name="compensations[{{$compensation->id}}]"
                                                   class="form-control">
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="tab-pane" id="tab6">
                                <h3 class="block">Fill in the employee leave balance</h3>
                                @foreach($leaves as $leave)
                                    <div class="form-group">
                                        <label class="control-label col-md-3">{{$leave->name}}</label>
                                        <div class="col-md-4">
                                            <input type="number" name="leave_balances[{{$leave->id}}]"
                                                   class="form-control">
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="tab-pane" id="tab7">
                                <div class="form" data-contains="custom-policies">
                                    <!-- Select Specifics -->
                                    <div class="form-group">
                                        <select data-change="show-specifics" class="form-control">
                                            <option>Select</option>
                                            <optgroup label="HR Policies">
                                                @foreach($page->hrPolicies as $policy)
                                                    <option data-type="hr"
                                                            value="{{$policy->id}}">{{$policy->name}}</option>
                                                @endforeach
                                            </optgroup>
                                            <optgroup label="Leave Policies">
                                                @foreach($page->leavePolicies as $policy)
                                                    <option data-type="leave"
                                                            value="{{$policy->id}}">{{$policy->name}}</option>
                                                @endforeach
                                            </optgroup>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <!-- HR Specifics Holder -->
                                        <div class="collapse" data-contains="hr-specifics">
                                            <div class="form-group">
                                                <label class="control-label">Applicants</label>
                                                <select class="form-control" data-var="applicants">
                                                    <option value="all">All</option>
                                                    <option value="male">Male</option>
                                                    <option value="female">Female</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Service Level Agreement</label>
                                                <input type="number" class="form-control"
                                                       data-var="sla"
                                                       placeholder="Service level agreement...">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Available After</label>
                                                <div class="input-group">
                                                    <input type="number" class="form-control"
                                                           data-var="available-after"
                                                           placeholder="Available After..">
                                                    <div class="input-group-addon">
                                                        Months
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Line Managers</label>
                                                <div class="input-group">
                                                    <div class="input-group-addon">
                                                        Authority
                                                    </div>
                                                    <select data-contains="line-manager-authority" class="form-control">
                                                        <option value="approve">Approve</option>
                                                        <option value="review">Review</option>
                                                    </select>
                                                    <div class="input-group-btn">
                                                        <button type="button" role="button" class="btn btn-dark"
                                                                data-click="add-line-manager">Add
                                                        </button>
                                                    </div>
                                                </div>
                                                <ul data-contains="line-managers" class="list-group collapse">
                                                </ul>
                                            </div>
                                            <div class="form-group">
                                                <button type="button" role="button" data-click="add-specifics"
                                                        data-click-param="hr"
                                                        class="btn btn-dark">Add Policy
                                                </button>
                                            </div>
                                        </div>
                                        <!-- Leave Specifics Holder -->
                                        <div class="collapse" data-contains="leave-specifics">
                                            <div class="form-group">
                                                <label class="control-label">Applicants</label>
                                                <select class="form-control" data-var="applicants">
                                                    <option value="all">All</option>
                                                    <option value="male">Male</option>
                                                    <option value="female">Female</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Allowed Days</label>

                                                <input type="number" class="form-control"
                                                       data-var="allowed-days"
                                                       placeholder="Allowed days..">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Days Type</label>

                                                <select class="form-control" data-var="days-type">
                                                    <option value="calender" selected>Calender</option>
                                                    <option value="working">Working</option>
                                                </select>
                                            </div>
                                            <div class="form-group">
                                                <label for="deductible" class="control-label">Deductible</label>
                                                <input type="checkbox"
                                                       data-var="deductible">
                                            </div>
                                            <div class="form-group">
                                                <label for="hides_balance" class="control-label">Balance hidden in
                                                    profile</label>
                                                <input type="checkbox"
                                                       data-var="hides_balance">
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Available After</label>
                                                <div class="input-group">
                                                    <input type="number"
                                                           class="form-control"
                                                           data-var="available-after" placeholder="Available After..">
                                                    <div class="input-group-addon">
                                                        Months
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label class="control-label">Line Managers</label>
                                                <div class="input-group">
                                                    <div class="input-group-addon">
                                                        Authority
                                                    </div>
                                                    <select data-contains="line-manager-authority" class="form-control">
                                                        <option value="approve">Approve</option>
                                                        <option value="review">Review</option>
                                                    </select>
                                                    <div class="input-group-btn">
                                                        <button type="button" role="button" class="btn btn-dark"
                                                                data-click="add-line-manager">Add
                                                        </button>
                                                    </div>
                                                </div>
                                                <ul data-contains="line-managers" class="list-group collapse">
                                                </ul>
                                            </div>
                                            <div class="form-group">
                                                <button type="button" role="button" data-click="add-specifics"
                                                        data-click-param="leave"
                                                        class="btn btn-dark">Add Policy
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="alert alert-warning" data-contains="alarm" style="display:none;">
                                        This custom policy is already added.
                                    </div>
                                    <hr>
                                    <ul class="list-group" data-contains="specifics">
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="form-actions">
                            <div class="row">
                                <div class="col-md-offset-3 col-md-9">
                                    <a href="javascript:" class="btn btn-red button-previous">
                                        <i class="fa fa-arrow-left"></i> Back </a>
                                    <a href="javascript:" class="btn btn-green button-next">
                                        Continue <i class="fa fa-arrow-right"></i>
                                    </a>
                                    <button type="submit" class="btn btn-green button-submit">
                                        Submit <i class="fa fa-save"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    @endif
    @if(array_key_exists('importErrors',$page))
        <div class="center-block well">
            The following errors were encountered while importing your employees <br>
            Kindly fix them and attempt to import again.
            <br>
            <small><a data-toggle="collapse" href="#import_error_more_info">more information</a></small>
            <div class="collapse" id="import_error_more_info">
                HRFlo validates the integrity of the data you're importing using it's import method,<br>
                when there's wrong information that you might have entered, HRFlo notifies you.
                <br>
                It's always a good practice to export a sheet first, and attempt to import it after modifying it.
            </div>
        </div>
        <div class="list-group">
            @foreach($page->importErrors as $employeeId => $error_list)
                <a href="#{{$employeeId.'_errors'}}" data-toggle="collapse"
                   class="list-group-item list-group-item-danger">
                    Employee ID: <strong>{{$employeeId}}</strong>
                    , {{ count($error_list).' '.\Illuminate\Support\Str::plural('Error',count($error_list)) }},
                    <small>click to view</small>
                </a>
                <div id="{{$employeeId.'_errors'}}" class="collapse">
                    @foreach($error_list as $error_item)
                        <div class="list-group-item list-group-item-warning">{{$error_item}}</div>
                    @endforeach
                </div>
            @endforeach
        </div>
    @endif
    <div class="table-responsive">
        <table class="table hr-table table-hover">
            <thead>
            <tr>
                <th> #</th>
                <th> Name</th>
                <th> Employee ID</th>
                <th> Company Email</th>
                <th> Department</th>
                <th> Group</th>
                <th> Scope</th>
                <th> Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php $index = 1; ?>
            @foreach($page->users as $item)
                <tr>
                    <td> {{ $index++ }}</td>
                    <td> {{ $item->name }}</td>
                    <td> {{ $item->employee_id }}</td>
                    <td> {{ $item->company_email }}</td>
                    <td> {{ $item->department_name }}</td>
                    <td> {{ $item->group_name }}</td>
                    <td>
                    <span class="label label-{{$item->active?'success':'danger'}}" data-toggle="tooltip"
                          title="User is {{ $item->active? 'Active': 'Inactive' }}">{{ $item->active? 'A': 'D' }}</span>
                        <span class="label label-info" data-toggle="tooltip"
                              title="{{$item->role_id=='1'?'Employee':'HR Administrator'}}">{{ $item->role_id=='1'?'E':'H' }}</span>
                    </td>
                    <td>
                        <div class="btn-group">
                            <div class="dropdown">
                                <button class="btn btn-sm btn-dark dropdown-toggle" type="button"
                                        data-toggle="dropdown">
                                    Actions
                                    <span class="caret"></span>
                                </button>
                                <ul class="dropdown-menu" role="menu">
                                    @if($item->active)
                                        <li role="presentation">
                                            <a tabindex="-1"
                                               href="{{URL::action('UsersController@getEdit',['id'=>$item->id])}}">
                                                Details
                                            </a>
                                        </li>
                                        <li role="presentation">
                                            <a tabindex="-1" data-toggle="collapse"
                                               data-target="#user_edit_family_{{$item->id}}">
                                                Family
                                            </a>
                                        </li>
                                        @if($item->can_alter && $item->id != \Auth::user()->id)
                                            <li role="presentation">
                                                <a tabindex="-1" data-target="#change_user_role{{$item->id}}"
                                                   data-toggle="modal">
                                                    Change Role
                                                </a>
                                            </li>
                                        @endif
                                    @endif
                                    @if($item->can_alter && $item->id != \Auth::user()->id)
                                        <li role="presentation">
                                            <a data-target="#change_active_status{{$item->id}}" data-toggle="modal">
                                                {{ ($item->active)?"Deactivate":"Activate" }}
                                            </a>
                                        </li>
                                    @endif
                                </ul>
                            </div>

                        </div>
                    </td>
                    @if($item->can_alter &&$item->id != \Auth::user()->id)
                        <div class="modal fade" id="change_active_status{{$item->id}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <form style="display:none;" method="post"
                                              action="{{ URL::action('UsersController@postChangeActiveStatus') }}">
                                            {!! csrf_field() !!}
                                            <input type="hidden" value="{{$item->id}}" name="user_id">
                                            <input type="hidden" value="{{($item->active)?'true':'false'}}"
                                                   name="status">
                                            <div class="help-block">
                                                Are you sure you want to {{ ($item->active)?"deactivate":"activate" }}
                                                the
                                                user "{{ $item->name }}"
                                            </div>
                                            <div class="form-actions">
                                                <button type="submit"
                                                        class="btn btn-{{($item->active)?"red":"green" }}">
                                                    {{ ($item->active)?"Deactivate":"Activate" }}
                                                </button>
                                                <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                    Back to safety
                                                </button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                    @if($item->can_alter && $item->id != \Auth::user()->id && $item->active)
                        <div class="modal fade" id="change_user_role{{$item->id}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <form style="display:none;" method="post"
                                              action="{{ URL::action('UsersController@postChangeUserRole') }}">
                                            {!! csrf_field() !!}
                                            <input type="hidden" value="{{$item->id}}" name="user_id">
                                            <div class="help-block">
                                                Employee: {{ $item->name }}
                                                Current Role: {{ $item->role_id=='1'?'Employee': 'HR Administrator' }}
                                            </div>
                                            <div class="form-group">
                                                <label for="role{{$item->id}}" class="control-label">Select the new
                                                    Role</label>
                                                <select name="role" id="role{{$item->id}}" class="form-control">
                                                    <option value="Employee">Employee</option>
                                                    <option value="HR Administrator">HR Administrator</option>
                                                </select>
                                            </div>
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-dark">
                                                    Change Role
                                                </button>
                                                <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                    Cancel
                                                </button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endif
                </tr>
                @if($item->active)
                    <tr class="collapse" id="user_edit_family_{{$item->id}}">
                        <td colspan="9">
                            <div class="sub-table-wrapper">
                                @if($item->active)
                                    <form method="post" class="form-inline" style="margin-bottom:10px;"
                                          action="{{ URL::action('UsersController@postAddFamily') }}">
                                        {!! csrf_field() !!}
                                        <div class="help-block">Add a new family member</div>
                                        <input type="hidden" name="user_id" value="{{$item->id}}">
                                        <input type="text" name="name" placeholder="Name..."
                                               class="form-control">
                                        <div class="form-group">
                                            <select name="relation" class="form-control">
                                                @foreach(['husband','wife','son','daughter'] as $relation)
                                                    {!!
                                                    '
                                                    <option value="'.$relation.'">
                                                        '.\Illuminate\Support\Str::studly($relation).'
                                                    </option>
                                                    '
                                                    !!}
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="date_of_birth"
                                                   class="form-control has-date-picker"
                                                   placeholder="Birth Date">
                                        </div>
                                        <div class="form-group">
                                            <input type="text" name="visa_expiry_date"
                                                   class="form-control has-date-picker"
                                                   placeholder="Visa Expiry Date">
                                        </div>
                                        <button type="submit" class="btn btn-green">Add</button>
                                    </form>
                                @endif
                                @if(count($item->familyMembers)>0)
                                    <hr>
                                    <div class="help-block">Current family members</div>
                                    <table class="table hr-table">
                                        <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Relation</th>
                                            <th>Date Of Birth</th>
                                            <th>Visa Expiry Date</th>
                                            <th>Actions</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php $familyIndex = 1;?>
                                        @foreach($item->familyMembers as $family)
                                            <tr>
                                                <td>{{$familyIndex++}}</td>
                                                <td>{{$family->name}}</td>
                                                <td>{{$family->relation}}</td>
                                                <td>{{ $family->date_of_birth }}</td>
                                                <td>{{ $family->visa_expiry_date }}</td>
                                                <td>
                                                    @if($item->active)
                                                        <form method="post"
                                                              action="{{URL::action('UsersController@postRemoveFamily') }}">
                                                            {!! csrf_field() !!}
                                                            <input type="hidden" name="family_id"
                                                                   value="{{$family->id}}">
                                                            <div class="hr-actions-cell">
                                                                <button type="button" class="btn btn-dark"
                                                                        data-toggle="collapse"
                                                                        data-target="#family_{{$family->id}}">
                                                                    Edit
                                                                </button>
                                                                <button type="submit" class="btn btn-red">
                                                                    Delete
                                                                </button>
                                                            </div>
                                                        </form>
                                                    @endif
                                                </td>
                                            </tr>
                                            @if($item->active)
                                                <tr class="collapse" id="family_{{$family->id}}">
                                                    <td colspan="6">
                                                        <form method="post" class="form-inline"
                                                              action="{{ URL::action('UsersController@postEditFamily') }}">
                                                            {!! csrf_field() !!}
                                                            <input type="hidden" name="family_id"
                                                                   value="{{$family->id}}">
                                                            <div class="form-group">
                                                                <input type="text" name="name"
                                                                       value="{{ $family->name }}"
                                                                       class="form-control">
                                                            </div>
                                                            <div class="form-group">
                                                                <select name="relation" class="form-control">
                                                                    @foreach(['husband','wife','son','daughter'] as
                                                                    $relation)
                                                                        {!!
                                                                        ($family->relation == $relation)?
                                                                        '
                                                                        <option value="'.$relation.'" selected>
                                                                            '.\Illuminate\Support\Str::studly($relation).'
                                                                        </option>
                                                                        ':
                                                                        '
                                                                        <option value="'.$relation.'">
                                                                            '.\Illuminate\Support\Str::studly($relation).'
                                                                        </option>
                                                                        '
                                                                        !!}
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div class="form-group">
                                                                <input type="text" name="date_of_birth"
                                                                       value="{{$family->date_of_birth }}"
                                                                       class="form-control has-date-picker"
                                                                       placeholder="Birth Date">
                                                            </div>
                                                            <div class="form-group">Visa Expiry Date:
                                                                <input type="text" name="visa_expiry_date"
                                                                       value="{{$family->visa_expiry_date }}"
                                                                       class="form-control has-date-picker"
                                                                       placeholder="Visa Expiry Date">
                                                            </div>
                                                            <button type="submit" class="btn btn-green">Update</button>
                                                        </form>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach
                                        </tbody>
                                    </table>
                                @endif
                            </div>
                        </td>
                    </tr>
                @endif
            @endforeach
            </tbody>
        </table>
    </div>
@endsection