@extends('layout')
@section('pageScripts')
    <script type="text/javascript">
        $('.btn-export').click(function (e) {
            e.preventDefault();
            $('#logsForm').append($('<input>', {'type': 'hidden', 'value': 1, 'name': 'export', 'id': 'export'}));
            $('#logsForm').submit();
            $('#export').remove();
        })
    </script>
@endsection
@section('title')
    <i class="icon icon-database"></i> Logs
@endsection
@section('actions')
    <button class="btn btn-dark btn-export">Export</button>
@endsection
@section('content')
    <nav class="navbar navbar-default" role="navigation">
        <form id="logsForm" action="{{ URL::action('LogsController@getRequests') }}" class="navbar-form" role="search">
            <div class="form-group">
                <label for="userId" class="control-label">
                    Filter by User
                </label>
                <select name="userId" id="userId" class="form-control">
                    <option value="">Select</option>
                    @foreach($users as $user)
                        @if(Input::get('userId') == $user->id)
                            <option value="{{$user->id}}" selected>{{$user->name}}</option>
                        @else
                            <option value="{{$user->id}}">{{$user->name}}</option>
                        @endif
                    @endforeach/
                </select>
            </div>
            <div class="form-group">
                <label class="control-label">
                    Period
                </label>
                <input name="from" type="text" class="form-control input-sm has-date-picker"
                       {{ Input::get('from') ? 'value='.stripslashes(Input::get('from')):'' }} placeholder="From...">
                <input name="to" type="text" class="form-control input-sm has-date-picker"
                       {{ Input::get('from') ? 'value='.stripslashes(Input::get('to')):'' }} placeholder="To...">
            </div>
            <div class="form-group">
                <label class="control-label">
                    Per Page
                </label>
                <input type="number" class="form-control input-sm"
                       value="{{ Input::get('perPage')?Input::get('perPage'):10}}" name="perPage">
            </div>
            <button type="submit" class="btn btn-default">Submit</button>
        </form>
    </nav>
    <ul class="nav nav-tabs" role="tablist">
        <li class="active"><a href="#Table-View" role="tab" data-toggle="tab">Tabular View</a></li>
        <li><a href="#Descriptive-View" role="tab" data-toggle="tab">Descriptive View</a></li>
    </ul>
    <style scoped>
        table {
            border-collapse: collapse;
            table-layout: fixed;
            width:100%;
        }

        th {
            height: 40px;
            padding: 10px;
            text-align: left;
        }

        td {
            width:12.5%;
            padding: 10px;
            text-align: left;
            /* These are technically the same, but use both */
            overflow-wrap: break-word;
            word-wrap: break-word;

            -ms-word-break: break-all;
            /* Instead use this non-standard one: */
            word-break: normal;

            /* Adds a hyphen where the word breaks, if supported (No Blink) */
            -ms-hyphens: auto;
            -moz-hyphens: auto;
            -webkit-hyphens: auto;
            hyphens: auto;

        }
    </style>
    <!-- TAB CONTENT -->
    <div class="tab-content">
        <div class="active tab-pane fade in" id="Table-View">
            <div class="table-responsive">
                <table class="table hr-table table-hover">
                    <thead>
                    <tr>
                        <th> Employee ID</th>
                        <th> Employee Name</th>
                        <th> Action</th>
                        <th> Policy Type</th>
                        <th> Policy Name</th>
                        <th> Status</th>
                        <th> Date</th>
                        <th> Description</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($logs as $item)
                        <tr>
                            <td style="width: 10%"> {{ $item->employeeId }}</td>
                            <td> {{ $item->employeeName }}</td>
                            <td> {{ $item->action }}</td>
                            <td style="width: 10%"> {{ $item->policyType }}</td>
                            <td> {{ $item->policyName }}</td>
                            <td> {{ $item->status }}</td>
                            <td> {{ $item->date }}</td>
                            <td style="width: 17.5%"> {{ $item->description }}</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class=" tab-pane fade" id="Descriptive-View">
            <ul class="list-group">
                @foreach($logs as $item)
                    <li role="presentation" class="list-group-item">
                        {!! $item->log !!}
                    </li>
                @endforeach
            </ul>

        </div>
    </div>
    <ul class="pagination">
        @for($i=1;$i<$pagesCount;$i++)
            @if($page==$i)
                <li class="active"><a href="#">{{$i}}</a></li>
            @else
                <li><a href="{{URL::action('LogsController@getRequests',['userId'=>Input::get('userId'),
                'from'=>Input::get('from'),
                'to'=>Input::get('to'),
                'page'=>$i,
                'perPage'=>Input::get('perPage')])}}">{{$i}}</a></li>
            @endif
        @endfor
    </ul>
@endsection