@extends('layout')
@section('title')
    {{ $details->request->request }}
@endsection
@section('actions')
    <div class="button-group">
        <a href="{{ back() }}" class="btn btn-dark">
            <i class="fa fa-backward"></i> Back
        </a>
        <a href="{{ URL::action('UsersController@getEdit',['id'=>$details->request->user_id]) }}" class="btn btn-dark">
            <i class="fa fa-user"></i> Requester Profile
        </a>
    </div>
@endsection
@section('content')
    <div class="media">
        <div class="media-body">
            <h4 class="media-heading">Policy: {{ $details->request->request }}</h4>
            <br>
            <strong class="h4">Sender:@if(Auth::user()->id == $details->request->user_id)
                    You @else {{$details->request->name}} @endif</strong><br><br>
            <strong class="h4">Sent:</strong>
            <strong>{{ \Carbon\Carbon::parse($details->request->request_date)->diffForHumans() }}</strong><br><br>

            @if($details->request->type == 'leave')
                <span class="h4">From:</span> <strong>{{ $details->request->from_date }}</strong><br><br>
                <span class="h4">To:</span> <strong>{{ $details->request->to_date }}</strong><br><br>
            @endif
            @if($details->request->status != '')
                <span class="h4">Status:</span><strong>{{ $details->request->status }}</strong><br><br>
            @endif
            <span class="h4">Details:</span><br>
            <strong>{{$details->request->description}}</strong>
            @if($details->request->attachment)
                <div class="media">
                    <div class="media-body">
                        <h4 class="media-heading">Attachment</h4>
                        <a href="{{ URL::asset($details->request->attachment) }}" class="btn btn-green">Download
                            Attachments</a>
                    </div>
                </div>
            @endif
        </div>
    </div>
    <hr>
    <div class="h3">Status</div>
    @foreach($details->statusHistory as $status)
        <div class="announcement bg-dark">
            <div class="announcement-icon">
                <i class="icon icon-company-settings"></i>
            </div>
            <div class="details">
                {{ $status->name }} @if($status->title) | {{ $status->title }}@endif
                <br>
                Status: <strong>{{ ucfirst($status->status) }}</strong>
                <br>
                @if($status->comment != null)
                    <p class="comment">
                        Comment: {{ $status->comment }}
                    </p>
                @endif
            </div>
            <div class="time">
                On: {{ $status->date }}
            </div>
        </div>
    @endforeach
@endsection