@extends('layout')

@section('pageCss')
    <link href="{{ URL::asset('assets/css/vendor/select2.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/select2-bootstrap.css') }}" rel="stylesheet" type="text/css">
@endsection

@section('pageScripts')
    <script type="text/javascript" src="{{ URL::asset('assets/js/vendor/select2.min.js') }}"></script>
    <script type="text/javascript">
        $("#handling_routines").sortable({
            snap: '.list-group-item',
            update: function (event, ui) {
                updateHandlingRoutine();
            }
        });
        $('.select2-select-box').select2();

        function updateHandlingRoutine() {
            var foundHR = false
            $('#handling_routines li').each(function () {
                if ($(this).find('.label.label-info').text() == 'HR Administrator') {
                    foundHR = true
                    return
                }

                var Index = parseInt($(this).index() + 1)
                if (foundHR)
                    Index -= 1
                $(this).children('span:first-child').html("Line Manager#: " + Index)
            })
        }
        function removeHandlingRoutine(e) {
            $(e).closest('li').remove();
            updateHandlingRoutine();
        }
        function AddHandlingRoutine() {
            var _index = $("#handling_routines > li").length - 1;
            $("#handling_routines").append(
                    '<li class="list-group-item">' +
                    '<span class="label label-info">Line Manager#: ' + parseInt(_index + 1) + '</span>' +
                    '<span class="label label-primary">' + $("#user_auth option:selected").text() + '</span>' +
                    '<button role="button" type="button" class="btn pull-right btn-xs btn-danger" onclick="removeHandlingRoutine(this)"><i class="fa fa-minus"></i> Remove</button> ' +
                    '<input type="hidden" name="line_managers[]" value="' + $('#user_auth').val() + '">' +
                    '</li>'
            );
        }
        $('input[type="radio"][data-controls]').each(function (item) {
            var target = $(this).attr('data-controls');
            $(this).click(function () {
                if ($(this).val() == 'all' || $(this).val() == 'yes') {
                    $(target).prop('disabled', true);
                }
                else {
                    $(target).prop('disabled', false);
                }
            });
        });
    </script>
@endsection
@section('title')
    Create a new Policy
@endsection
@section('content')
    <form action="{{ URL::action('PolicyController@postCreate') }}" class="form-horizontal"
          id="submit_form" method="POST">
        {!! csrf_field() !!}
        <div class="form-group">
            <label class="control-label">
                Policy name
            </label>
            <input required type="text" class="form-control" name="name"
                   placeholder="Policy Name" value="{{old('name')}}">
        </div>
        <div class="form-group">
            <label class="control-label">Information
            </label>
            <textarea required class="form-control" name="information"
                      placeholder="Information...">{{old('information')}}</textarea>
        </div>
        <div class="form-group">
            <label class="control-label">
                Policy Details
            </label>
            <textarea required class="form-control" name="policy_information"
                      placeholder="Policy details...">{{old('policy_information')}}</textarea>
        </div>
        <div class="form-group">
            <label class="control-label">Requires attachments?</label>
            <input type="radio" name="requires_attachments" value="yes"> Yes
            <input type="radio" name="requires_attachments" value="no"> No
        </div>
        @if($page->type == 'hr')
            <input type="hidden" name="request_type" value="{{$page->type}}">
            <div class="form-group">
                <label class="control-label">Service Level Agreement</label>
                <input type="number" class="form-control" name="sla_agreement"
                       placeholder="Service level agreement..." value="{{old('sla_agreement')}}">
            </div>
        @elseif($page->type =='leave')
            <input type="hidden" name="request_type" value="{{$page->type}}">
            <div class="form-group">
                <label class="control-label">Deductible from annual balance?</label>
                <input data-controls="#allow_days" type="radio" name="deductible" value="yes" checked="checked"> Yes
                <input data-controls="#allow_days" type="radio" name="deductible" value="no"> No
            </div>
            <div class="form-group">
                <label class="control-label">Balance hidden from profiles?</label>
                <input type="radio" name="hides_balance" value="yes"> Yes
                <input type="radio" name="hides_balance" value="no" checked="checked"> No
            </div>
            <div class="form-group">
                <label class="control-label">Allowed Days</label>
                <input id="allow_days" type="number" class="form-control" name="allowed_days" disabled="disabled"
                       placeholder="Allowed days.." value="{{old('allowed_days')}}">
            </div>
            <div class="form-group">
                <label class="control-label">Days Type</label>
                <select class="form-control" name="days_type">
                    <option value="calender" selected>Calender</option>
                    <option value="working">Working</option>
                </select>
            </div>
        @endif
        <div class="form-group">
            <label class="control-label">Gender</label>
            <select class="form-control" name="applicants">
                <option value="all">All</option>
                <option value="male">Males</option>
                <option value="female">Females</option>
            </select>
        </div>
        <div class="form-group">
            <label class="control-label">Departments</label>
            <input type="radio" name="departments" value="all" data-controls="#departments_select_box"> All
            <input type="radio" name="departments" value="custom" data-controls="#departments_select_box" checked>
            Select
        </div>
        <!-- Departments -->
        <div class="form-group">
            <label class="control-label">Custom Departments</label>
            <select multiple="multiple" class="select2-select-box form-control" name="departments[]"
                    id="departments_select_box">
                @foreach($page->departments as $item)
                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                @endforeach
            </select>
        </div>
        <!-- ./Departments -->

        <!-- Groups -->
        <div class="form-group">
            <label class="control-label">Groups</label>
            <input type="radio" name="groups" value="all" data-controls="#groups_select_box"> All
            <input type="radio" name="groups" value="custom" data-controls="#groups_select_box" checked>
            Select
        </div>
        <div class="form-group">
            <label class="control-label">Custom Groups</label>
            <select multiple="multiple" class="select2-select-box form-control" name="groups[]"
                    id="groups_select_box">
                @foreach($page->groups as $item)
                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                @endforeach
            </select>
        </div>
        <!-- ./Groups -->
        @if($page->settings->require_religion)
            <div class="form-group">
                <label class="control-label">Religions</label>
                <input type="radio" name="religion" value="all" data-controls="#religions_select_box"> All
                <input type="radio" name="religion" value="custom" data-controls="#religions_select_box" checked> Custom
            </div>
            <div class="form-group">
                <label class="control-label">Custom Religions</label>
                <select multiple="multiple" class="select2-select-box form-control pull-right"
                        name="religion[]" id="religions_select_box">
                    @foreach($page->religions as $item)
                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                    @endforeach
                </select>
            </div>
        @endif
        <h3 class="block">Join Date Requirements</h3>

        <div class="form-group">
            <label class="control-lable">
                Available After
            </label>
            <div class="input-group">
                <input type="number" class="form-control"
                       value="{{old('available_after')}}" name="available_after">
                <div class="input-group-addon">
                    Months
                </div>
            </div>
        </div>
        <h3 class="block">Specify the Handling Routine for this Policy</h3>
        <div class="form-group">
            <div class="col-md-6">
                <div class="portal">
                    <div class="portal-title">
                        <div class="caption">
                            Line Managers Authority
                        </div>
                    </div>
                    <div class="portal-body">
                        <label class="control-label">Authority</label>
                        <label for="user_auth"></label>
                        <select class="form-control clearfix" id="user_auth" name="user_auth">
                            <option value="review" selected>Review</option>
                            <option value="approve">Approve</option>
                        </select>
                        <div class="form-actions">
                            <a href="#add_handling_routine" onclick="AddHandlingRoutine();"
                               class="btn btn-dark" id="add_handling_routine">
                                Add
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="portal">
                    <div class="portal-title">
                        <div class="caption">
                            Change Order
                        </div>
                    </div>
                    <div class="portal-body">
                        <ul class="list-group" id="handling_routines">
                            <li class="list-group-item">
                                <label class="label label-info">HR Administrator</label>
                                <label class="label label-primary">
                                    <select id="hr_auth_sel" style="color:#000;"
                                            onchange="$('#hr_auth').val($('#hr_auth_sel').val());">
                                        <option value="hr_review">review</option>
                                        <option value="hr_approve">approve</option>
                                    </select>
                                </label>
                                <input id="hr_auth" type="hidden" name="line_managers[]"
                                       value="hr_review">
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <hr>
        <div class="form-actions">
            <div class="text-center">
                <button type="submit" class=" btn btn-green">
                    Create Policy
                </button>
            </div>
        </div>
    </form>
@endsection