@extends('layout')

@section('pageCss')
    <link href="{{ URL::asset('assets/css/vendor/select2.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/select2-bootstrap.css') }}" rel="stylesheet" type="text/css">
@endsection

@section('pageScripts')
    <script type="text/javascript" src="{{ URL::asset('assets/js/vendor/select2.min.js') }}"></script>
    <script type="text/javascript">
        $("#handling_routines").sortable({
            snap: '.list-group-item',
            update: function (event, ui) {
                updateHandlingRoutine();
            }
        });
        $('.select2-select-box').select2();

        function updateHandlingRoutine() {
            var foundHR = false
            $('#handling_routines li').each(function () {
                if ($(this).find('.label.label-info').text() == 'HR Administrator') {
                    foundHR = true
                    return
                }

                var Index = parseInt($(this).index() + 1)
                if (foundHR)
                    Index -= 1
                $(this).children('span:first-child').html("Line Manager#: " + Index)
            })
        }
        function removeHandlingRoutine(e) {
            $(e).closest('li').remove();
            updateHandlingRoutine();
        }
        function AddHandlingRoutine() {
            var _index = $("#handling_routines > li").length - 1;
            $("#handling_routines").append(
                    '<li class="list-group-item">' +
                    '<span class="label label-info">Line Manager#: ' + parseInt(_index + 1) + '</span>' +
                    '<span class="label label-primary">' + $("#user_auth option:selected").text() + '</span>' +
                    '<button role="button" type="button" class="btn pull-right btn-xs btn-danger" onclick="removeHandlingRoutine(this)"><i class="fa fa-minus"></i> Remove</button> ' +
                    '<input type="hidden" name="line_managers[]" value="' + $('#user_auth').val() + '">' +
                    '</li>'
            );
        }
        $('input[type="radio"][data-controls]').each(function (item) {
            var target = $(this).attr('data-controls');
            $(this).click(function () {
                if ($(this).val() == 'all' || $(this).val() == 'yes') {
                    $(target).prop('disabled', true);
                }
                else {
                    $(target).prop('disabled', false);
                }
            });
        });
    </script>
@endsection
@section('title')
    Edit {{ $policy->name }}
@endsection
@section('content')
    <form action="{{ URL::action('PolicyController@postUpdatePolicy') }}" class="form-horizontal"
          id="submit_form" method="POST">
        {!! csrf_field() !!}
        <input type="hidden" name="policy_id" value="{{ $policy->id }}">
        <div class="form-group">
            <label class="control-label">
                Policy name
            </label>
            <input required type="text" class="form-control" name="name"
                   placeholder="Policy Name" value="{{$policy->name}}">
        </div>
        <div class="form-group">
            <label class="control-label">
                Information
            </label>
            <textarea required class="form-control" name="information"
                      placeholder="Information...">{{ $policy->information }}</textarea>
        </div>
        <div class="form-group">
            <label class="control-label">
                Policy Details
            </label>
            <textarea required class="form-control" name="policy_information"
                      placeholder="Policy details...">{{$policy->policy_information}}</textarea>
        </div>
        <div class="form-group">
            <label class="control-label">Requires attachment?</label>
            <input type="radio" name="requires_attachment" value="yes"
                   @if($policy->requires_attachment) checked @endif> Yes
            <input type="radio" name="requires_attachment" value="no"
                   @if(!$policy->requires_attachment) checked @endif> No
        </div>
        @if($page->type == 'hr')
            <input type="hidden" name="request_type" value="{{$page->type}}">
            <div class="form-group">
                <label class="control-label">Service Level Agreement</label>
                <input type="number" class="form-control" name="sla"
                       placeholder="Service level agreement..." value="{{$policy->sla}}">
            </div>
        @elseif($page->type='leave')
            <input type="hidden" name="request_type" value="{{$page->type}}">
            <div class="form-group">
                <label class="control-label">Deductible from annual balance?</label>

                <input data-controls="#allowed_days" type="radio" name="deductible" value="yes"
                       @if($policy->deductible) checked="checked" @endif> Yes
                <input data-controls="#allowed_days" type="radio" name="deductible" value="no"
                       @if(!$policy->deductible) checked="checked" @endif> No
            </div>
            <div class="form-group">
                <label class="control-label">Balance hidden from profiles?</label>
                <input type="radio" name="hides_balance" value="yes"
                       @if($policy->hides_balance) checked="checked" @endif> Yes
                <input type="radio" name="hides_balance" value="no"
                       @if(!$policy->hides_balance) checked="checked" @endif> No
            </div>
            <div class="form-group">
                <label class="control-label">Allowed Days</label>
                <input id="allowed_days" type="number" class="form-control" name="allowed_days"
                       @if($policy->deductible) disabled="disabled" @endif
                       placeholder="Days.." value="{{$policy->days}}">
            </div>
            <div class="form-group">
                <label class="control-label">Days Type</label>

                <select class="form-control" name="days_type">
                    <option value="calender" @if($policy->days_type == 'calender') selected @endif>
                        Calender
                    </option>
                    <option value="working" @if($policy->days_type == 'working') selected @endif>
                        Working
                    </option>
                </select>
            </div>
        @endif
        <div class="form-group">
            <label class="control-label">Gender</label>
            <select class="form-control" name="applicants">
                <option value="all" @if($policy->applicants == 'all') selected @endif>All</option>
                <option value="male" @if($policy->applicants == 'male') selected @endif>Males</option>
                <option value="female" @if($policy->applicants == 'female') selected @endif>Females
                </option>
            </select>
        </div>
        <div class="form-group">
            <label class="control-label">Departments</label>
            <input type="radio"
                   name="departments" value="all" data-controls="#departments_select_box"> All Departments
            <input type="radio" name="departments"
                   value="custom" checked data-controls="#departments_select_box"> Custom
        </div>
        <div class="form-group">
            <label class="control-label">Custom Departments</label>
            <select multiple="multiple" class="select2-select-box form-control pull-right"
                    name="departments[]" id="departments_select_box">
                @foreach($page->departments as $item)
                    @if(in_array($item->id,$policy->departments))
                        <option value="{{ $item->id }}" selected>{{ $item->name }}</option>
                    @else
                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                    @endif
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <label class="control-label">Groups</label>
            <input type="radio"
                   name="groups" value="all" data-controls="#groups_select_box"> All Groups
            <input type="radio" name="groups"
                   value="custom" checked data-controls="#groups_select_box"> Custom
        </div>
        <div class="form-group">
            <label class="control-label">Custom Departments</label>
            <select multiple="multiple" class="select2-select-box form-control"
                    name="groups[]" id="groups_select_box">
                @foreach($page->groups as $item)
                    @if(in_array($item->id,$policy->groups))
                        <option value="{{ $item->id }}" selected>{{ $item->name }}</option>
                    @else
                        <option value="{{ $item->id }}">{{ $item->name }}</option>
                    @endif
                @endforeach
            </select>
        </div>
        @if($page->settings->require_religion)
            <div class="form-group">
                <label class="control-label">Religions</label>
                <input type="radio" name="religion" value="all" data-controls="#religions_select_box"> All Religions
                <input type="radio" name="religion" value="custom" data-controls="#religions_select_box" checked> Custom
            </div>
            <div class="form-group">
                <label class="control-label">Custom Religions</label>
                <select multiple="multiple" class="select2-select-box form-control pull-right"
                        name="religion[]" id="religions_select_box">
                    @foreach($page->religions as $item)
                        @if(in_array($item->id,$policy->religions))
                            <option value="{{ $item->id }}" selected>{{ $item->name }}</option>
                        @else
                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                        @endif
                    @endforeach
                </select>
            </div>
        @endif
        <div class="form-group">
            <label class="control-lable">
                Available After
            </label>
            <div class="input-group">
                <input type="number" class="form-control"
                       value="{{ $policy->available_after }}" name="available_after">
                <div class="input-group-addon">
                    Months
                </div>
            </div>
        </div>
        <div class="form-group">
            <div class="col-md-6">
                <div class="portal">
                    <div class="portal-title">
                        <div class="caption">
                            Line Managers Authority
                        </div>
                    </div>
                    <div class="portal-body">
                        <label class="control-label">Authority</label>
                        <label for="user_auth"></label>
                        <select class="form-control clearfix" id="user_auth" name="user_auth">
                            <option value="review" selected>Review</option>
                            <option value="approve">Approve</option>
                        </select>
                        <div class="form-actions">
                            <a href="#add_handling_routine" onclick="AddHandlingRoutine();" class="btn btn-green"
                               id="add_handling_routine">
                                Add
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="portal">
                    <div class="portal-title">
                        <div class="caption">
                            Manage Order
                        </div>
                    </div>
                    <div class="portal-body">
                        <ul class="list-group" id="handling_routines">
                            <?php $i = 0;?>
                            @foreach(str_getcsv($policy->line_managers,',') as $line)
                                @if($line != '')
                                    <li class="list-group-item">
                                        @if($line == 'approve' || $line == 'review')
                                            <span class="label label-info">Line Manager#: {{ ($i + 1) }}</span>
                                            <span class="label label-primary">{{ucfirst($line)}}</span>
                                            <button role="button" type="button"
                                                    class="btn pull-right btn-xs btn-danger"
                                                    onclick="removeHandlingRoutine(this)"><i
                                                        class="fa fa-minus"></i> Remove
                                            </button>
                                            <input type="hidden"
                                                   name="line_managers[]"
                                                   value="{{$line}}">
                                            <?php $i++;?>
                                        @else
                                            <span class="label label-info">HR Administrator</span>
                                            <label class="label label-primary">
                                                <select id="hr_auth_sel" style="color:#000;"
                                                        onchange="$('#hr_auth').val($('#hr_auth_sel').val());">
                                                    <option value="hr_review"
                                                            @if($line == "hr_review") selected @endif>
                                                        review
                                                    </option>
                                                    <option value="hr_approve"
                                                            @if($line == "hr_approve") selected @endif>
                                                        approve
                                                    </option>
                                                </select>
                                            </label>
                                            <input id="hr_auth" type="hidden"
                                                   name="line_managers[]"
                                                   value="{{$line}}">
                                        @endif

                                    </li>
                                @endif
                            @endforeach
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-actions text-center">
            <button type="submit" class=" btn btn-green">
                Update {{ $policy->name }}
            </button>
        </div>
    </form>
@endsection
