@extends('layout')
@section('actions')
    <div class="btn-group">
        <a href="{{URL::action('PolicyController@getCreate',['type'=>$type])}}" class="btn btn-dark">
            Add a {{ strtoupper($type) }} Policy
        </a>
    </div>
@endsection
@section('title')
    <i class="icon icon-policies"></i> {{ \Illuminate\Support\Str::upper($type) }} Policies Control
@endsection
@section('content')
    <div class="table-responsive">
        <table class="table hr-table table-hover">
            <thead>
            <tr>
                <th> #</th>
                <th> Name</th>
                <th> Scope</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            <?php $index = 1; ?>
            @foreach($policies as $item)
                <tr>
                    <td>
                        {{ $index++ }}
                    </td>
                    <td> {{ $item->name }}</td>
                    <td>
                    <span class="label label-default" data-toggle="tooltip"
                          title="Applies to: {{ucfirst($item->applicants_type).($item->applicants_type != 'all'?'s':'')}}">{{strtoupper(substr($item->applicants_type,0,1))}}</span>
                        @if($type == 'leave')
                            @if($item->deductible)
                                <span data-toggle="tooltip" title="Deducts from the annual leave balance"
                                      class="label label-success">D</span>
                            @else
                                <span data-toggle="tooltip"
                                      title="Deducts from it's own leave balance, allowed days: {{$item->days}}"
                                      class="label label-success">ND: {{$item->days}}</span>
                            @endif
                            <span class="label label-warning" data-toggle="tooltip"
                                  title="Deduction is based on {{$item->days_type}} days">{{ $item->days_type=="calender"?"C":"W" }}</span>
                            @if($item->hides_balance)
                                <span data-toggle="tooltip"
                                      title="Leave Balance is hidden in user profiles"
                                      class="label label-danger">HB</span>
                            @endif
                        @else
                            <span class="label label-warning" data-toggle="tooltip"
                                  title="Service Level Agreement: {{$item->sla}}">S: {{$item->sla}}</span>
                        @endif
                        <span class="label label-info" data-toggle="tooltip"
                              title="Available after: {{ $item->available_after }} months from joining date">M: {{$item->available_after}}</span>
                    </td>
                    <td>
                        <div class="hr-actions-cell">
                            @if($item->active)
                                <a class="btn btn-dark"
                                   href="{{ URL::action('PolicyController@getUpdatePolicy',['id'=>$item->id,'type'=>$type]) }}">
                                    Edit
                                </a>
                            @endif
                            <a class="btn btn-{{($item->active)?'red':'green'}}"
                               data-target="#change_active_status{{$item->id}}"
                               data-toggle="modal">
                                {{ ($item->active)?"Deactivate":"Activate" }}
                            </a>
                        </div>

                    </td>
                    <div class="modal fade" id="change_active_status{{$item->id}}">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <form id="deactivate_policy_{{$item->id}}" method="post"
                                          action="{{ URL::action('PolicyController@postActivatePolicy') }}">
                                        {!! csrf_field() !!}
                                        <input type="hidden" name="policy_id" value="{{$item->id}}">
                                        <input type="hidden" name="type"
                                               value="{{($item->active)?'deactivate':'activate'}}">
                                        <input type="hidden" name="request_type" value="{{$type}}">
                                        <div class="help-block">
                                            Are you sure you want to {{ ($item->active)?"deactivate":"activate" }} the
                                            policy "{{ $item->name }}"
                                        </div>
                                        <div class="form-actions">
                                            <button type="submit" class="btn btn-{{($item->active)?"red":"green" }}">
                                                {{ ($item->active)?"Deactivate":"Activate" }}
                                            </button>
                                            <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                Back
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection