@extends('layout')
@section('pageCss')
    <link href="{{ URL::asset('assets/css/vendor/select2.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/select2-bootstrap.css') }}" rel="stylesheet" type="text/css"/>
@endsection
@section('pageScripts')
    <script src="{{ URL::asset('assets/js/vendor/select2.min.js')}}" type="text/javascript"></script>
    <script type="text/javascript">
        $('input[data-controls]').change(function () {
            $('.select2-choice').prop('disabled', true);
            var target = $(this).attr('data-controls');
            if (this.checked) {
                $(target).removeAttr('disabled');
            }
        });
        $('.select2-choice').select2()
    </script>
@endsection
@section('actions')
    <div class="btn-group">
        <button type="button" class="btn btn-dark" data-toggle="collapse" data-target="#new_announcement">
            Add an Announcement
        </button>
    </div>
@endsection
@section('title')
    <i class="icon icon-announcements"></i> Announcements Control
@endsection
@section('content')
    <div class="portal collapse" id="new_announcement">
        <div class="portal-title">
            <div class="caption">
                <i class="fa fa-plus"></i> Add a new Announcement
            </div>
            <div class="tools">
                <a href="#new_announcement" data-toggle="collapse">
                    <i class="fa fa-close"></i>
                </a>
            </div>
        </div>
        <div class="portal-body">
            <form enctype="multipart/form-data" action="{{ URL::action('AnnouncementController@postAddAnnouncement') }}"
                  class="form-horizontal"
                  id="submit_form" method="POST">
                <div class="portal-form">
                    {!! csrf_field() !!}
                    <h3 class="help-block">Provide the Announcement Details</h3>
                    <div class="form-group">
                        <label class="control-label">Title</label>
                        <input type="text" name="title" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="control-label">Details</label>
                        <textarea name="details" class="form-control"></textarea>
                    </div>
                    <div class="form-group">
                        <label class="control-label">Attachments</label>
                        <input type="file" name="attachment" class="form-control">
                    </div>
                    <div class="form-group">
                        <label class="control-label">Starting date</label>
                        <input type="text" name="date_from" class="form-control has-date-picker">
                    </div>
                    <div class="form-group">
                        <label class="control-label">Ending date</label>
                        <input type="text" name="date_to" class="form-control has-date-picker">
                    </div>
                    <div class="form-group">
                        <label class="control-label">Target</label>
                    </div>
                    <div class="form-group">
                        <div class="radio">
                            <label>
                                <input type="radio" name="target" value="all">
                                Everyone
                            </label>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="radio">
                            <label>
                                <input type="radio" data-controls="#targetDepartments" name="target" value="department">
                                Departments
                            </label>
                        </div>
                        <select class="form-control select2-choice" id="targetDepartments" multiple disabled="disabled"
                                name="targets[]">
                            @foreach($page->departments as $item)
                                <option value="{{$item->id}}">{{$item->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <div class="radio">
                            <label>
                                <input type="radio" data-controls="#targetGroups" name="target" value="group">
                                Groups
                            </label>
                        </div>
                        <select class="form-control select2-choice" id="targetGroups" multiple disabled="disabled"
                                name="targets[]">
                            @foreach($page->groups as $item)
                                <option value="{{$item->id}}">{{$item->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <div class="radio">
                            <label>
                                <input type="radio" data-controls="#targetUsers" name="target" value="user">
                                Users
                            </label>
                        </div>
                        <select class="form-control select2-choice" id="targetUsers" multiple disabled="disabled"
                                name="targets[]">
                            @foreach($page->users as $item)
                                <option value="{{$item->id}}">{{$item->name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-actions bg-dark">
                        <button type="submit" class="btn btn-green center-block">
                            <i class="fa fa-bullhorn"></i> Broadcast
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table hr-table table-hover">
            <thead>
            <tr>
                <th> #</th>
                <th> Title</th>
                <th> Details</th>
                <th> Created</th>
                <th> Start Date</th>
                <th> End Date</th>
                <th> Target</th>
                <th> Attachments</th>
            </tr>
            </thead>
            <tbody>
            <?php $index = 1; ?>
            @foreach($page->announcements as $item)
                <tr>
                    <td> {{ $index++ }}</td>
                    <td> {{ $item->title }}</td>
                    <td> {{ $item->details }}</td>
                    <td> {{ \Carbon\Carbon::parse($item->created_at)->diffForHumans() }}</td>
                    <td> {{ \Carbon\Carbon::parse($item->date_from)->toDateString() }}</td>
                    <td> {{ \Carbon\Carbon::parse($item->date_to)->toDateString() }}</td>
                    <td> {{ $item->target=='all' ? 'All' : \Illuminate\Support\Str::plural(ucfirst($item->target)) }}</td>
                    <td>
                        @if($item->attachment  != '')
                            <a class="text-center center-block" href="{{ URL::asset($item->attachment) }}">
                                Download
                            </a>
                        @else
                            <span class="text-center center-block">No Attachment</span>
                        @endif
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
    <div class="col-xs-12">
        {!! $page->announcements->render() !!}
    </div>
@endsection
