@extends('layout')

@section('actions')

    <a class="btn btn-dark" href="{{URL::action('CompensationController@getAddCompensation')}}">
        <i class="fa fa-plus"></i> Add Compensation & Benefit
    </a>

@endsection
@section('title')
    <i class="icon icon-compensation"></i> Compensation & Benefits
@endsection
@section('content')
    <div class="table-responsive">
        <table class="table hr-table table-hover">
            <thead>
            <tr>
                <th> Name</th>
                <th> Details</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>
            @foreach($compensations as $item)
                <tr>
                    <td> {{ $item->name }}</td>
                    <td> {{ $item->details }}</td>
                    <td>
                        <div class="hr-actions-cell">
                            <a href="{{ URL::action('CompensationController@getEditCompensation',['id'=>$item->id]) }}"
                               class="btn btn-dark">
                                Edit
                            </a>
                            <a href="#delete_compensation_{{$item->id}}" data-toggle="modal"
                               class="btn btn-red">
                                Delete
                            </a>
                        </div>
                        <div class="modal fade" id="delete_compensation_{{$item->id}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <form class="form" method="post"
                                              action="{{ URL::action('CompensationController@postDeleteCompensation') }}">
                                            {!! csrf_field() !!}
                                            <div class="help-block">
                                                Are you sure you want to delete the Compensation & Benefits
                                                "{{ $item->name }}"
                                            </div>
                                            <input type="hidden" name="compensation_id" value="{{$item->id}}">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-red">
                                                    Delete
                                                </button>
                                                <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                    Back
                                                </button>
                                            </div>

                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection
