@extends('layout')

@section('pageScripts')
    <script src="{{ URL::asset('assets/js/vendor/timezones.full.min.js') }}"></script>
    <script type="text/javascript">
        $('#timeZone').timezones()
        $('#timeZone').find('option[value="{{$settings->time_zone}}"]').prop('selected','selected');
    </script>
@endsection
@section('title')
    <i class="icon icon-company-settings"></i> General Settings
@endsection
@section('content')
    <div class="col-xs-12">
        <form method="post" action="{{ action("SettingsController@postUpdate") }}">
            {!! csrf_field() !!}
            <div class="form-group">
                <div class="input-group">
                    <div class="input-group-addon">
                        <label for="currency" class="control-label">
                            Currency
                        </label>
                    </div>
                    <select name="currency" id="currency" class="form-control">
                        @foreach(\App\Util::getCurrencies() as $opt)
                            @if($opt == $settings->currency)
                                <option selected value="{{$opt}}">{{$opt}}</option>
                            @else
                                <option value="{{$opt}}">{{$opt}}</option>
                            @endif
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group">
                <div class="input-group">
                    <div class="input-group-addon">
                        <label for="timeZone" class="control-label">
                            Time Zone
                        </label>
                    </div>
                    <select name="time_zone" id="timeZone" class="form-control">
                    </select>
                </div>
            </div>
            <div class="form-group">
                <div class="input-group">
                    <div class="input-group-addon">
                        <input @if($settings->send_welcome_email_upon_creation) checked="checked" @endif type="checkbox" value="on" name="send_welcome_email_upon_creation" id="sendWelcomeEmailUponCreation">
                    </div>
                    <input type="text" class="form-control disabled" value="Send welcome Email on creating/ importing a new employee" readonly/>
                </div>
            </div>
            <div class="form-group">
                <div class="input-group">
                    <div class="input-group-addon">
                        <input @if($settings->require_personal_email) checked="checked" @endif type="checkbox" value="on" name="require_personal_email" id="requirePersonalEmail">
                    </div>
                    <input type="text" class="form-control disabled" value="Require the employee personal email on creating/ importing an employee" readonly/>
                </div>
            </div>
            <div class="form-group">
                <div class="input-group">
                    <div class="input-group-addon">
                        <input @if($settings->require_religion) checked="checked" @endif type="checkbox" value="on" name="require_religion" id="requireReligion">
                    </div>
                    <input type="text" class="form-control disabled" value="Require the employee religion on creating/ importing an employee and reflect the policies applied according to it" readonly/>
                </div>
            </div>
            <div class="form-group">
                <div class="input-group">
                    <div class="input-group-addon">
                        <input @if($settings->require_home_country_phone) checked="checked" @endif type="checkbox" value="on" name="require_home_country_phone" id="requireHomeCountryPhone">
                    </div>
                    <input type="text" class="form-control disabled" value="Require the employee home country phone number on creating/ importing an employee" readonly/>
                </div>
            </div>
            <div class="form-group">
                <div class="input-group">
                    <div class="input-group-addon">
                        <input @if($settings->require_home_country_po_box) checked="checked" @endif type="checkbox" value="on" name="require_home_country_po_box" id="requireHomeCountryPoBox">
                    </div>
                    <input type="text" class="form-control disabled" value="Require the employee home country po box on creating/ importing an employee" readonly/>
                </div>
            </div>
            <button class="btn btn-green">
                Save Settings
            </button>
        </form>
    </div>
@endsection
