@extends('layout')
@section('pageCss')
    <link href="{{ URL::asset('assets/css/vendor/select2.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/select2-bootstrap.css') }}" rel="stylesheet" type="text/css">
@endsection

@section('pageScripts')
    <script type="text/javascript" src="{{ URL::asset('assets/js/vendor/select2.min.js') }}"></script>
    <script type="text/javascript">
        $('.select2-choice').select2();
    </script>
@endsection
@section('title')
    Create a new Location
@endsection
@section('content')
    <form action="{{ URL::action('LocationController@postAddLocation') }}" method="POST">
        {!! csrf_field() !!}
        <div class="form-group">
            <label>Name</label>
            <input type="text" class="form-control" name="name">
        </div>
        <div class="form-group">
            <label>Working days</label>
            <select class="select2-choice form-control" multiple="multiple" name="working_days[]">
                @foreach(['Saturday',
                    'Sunday',
                    'Monday',
                    'Tuesday',
                    'Wednesday',
                    'Thursday',
                    'Friday'] as $day)
                    <option value="{{ $day }}">{{$day}}</option>
                @endforeach
            </select>
        </div>
        <div class="form-actions text-center">
            <button type="submit" class=" btn btn-green">
                Create Location
            </button>
        </div>
    </form>
@endsection
