@extends('layout')

@section('pageCss')
    <link href="{{ URL::asset('assets/css/vendor/select2.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/select2-bootstrap.css') }}" rel="stylesheet" type="text/css"/>
@endsection
@section('pageScripts')
    <script type="text/javascript" src="{{ URL::asset('assets/js/vendor/select2.min.js') }}"></script>
    <script type="text/javascript">
        $('.select2-choice').select2();
    </script>
@endsection
@section('title')
    Edit {{$location->name}}
@endsection
@section('content')
    <form action="{{ URL::action('LocationController@postEditLocation') }}" method="POST">
        {!! csrf_field() !!}
        <input type="hidden" name="location_id" value="{{$location->id}}">
        <div class="form-group">
            <label>Name</label>
            <input type="text" class="form-control" name="name" value="{{ $location->name }}">
        </div>
        <div class="form-group">
            <label>Working days</label>
            <select class="select2-choice form-control" multiple="multiple" name="working_days[]">
                <?php
                $selected_days = str_getcsv($location->working_days, ',');
                $selected_days = array_filter($selected_days, function ($value) {
                    if ($value == '' || $value == null)
                        return false;
                    return true;
                });
                ?>
                @foreach(['Saturday','Sunday','Monday','Tuesday','Wednesday','Thursday','Friday'] as $day)
                    @if(in_array($day,$selected_days))
                        <option value="{{ $day }}" selected>{{$day}}</option>
                    @else
                        <option value="{{ $day }}">{{$day}}</option>
                    @endif
                @endforeach
            </select>
        </div>
        <div class="form-actions text-center">
            <button type="submit" class=" btn btn-success">
                Update {{ $location->name }}
            </button>
        </div>
    </form>
@endsection
