@extends('layout')
@section('actions')
    <div class="btn-group">
        <a href="{{URL::action('LocationController@getAddLocation')}}" type="button" class="btn btn-dark">
            Add a Location
        </a>
    </div>
@endsection
@section('title')
    <i class="icon icon-location"></i> Locations
@endsection
@section('content')
    <div class="table-responsive">
        <table class="table hr-table table-hover">
            <thead>
            <tr>
                <th> Name</th>
                <th> Working Days</th>
                <th>Actions</th>
            </tr>
            </thead>
            <tbody>

            @foreach($locations as $item)
                <tr>
                    <td> {{ $item->name }}</td>
                    <td> {{ $item->working_days }}</td>
                    <td>
                        <div class="hr-actions-cell">
                            <a href="{{ URL::action('LocationController@getEditLocation',['id'=>$item->id]) }}"
                               class="btn btn-dark">
                                Edit
                            </a>
                            <a href="#delete_location_{{$item->id}}" data-toggle="modal"
                               class="btn btn-red">
                                Delete
                            </a>
                        </div>
                        <div class="modal fade" id="delete_location_{{$item->id}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <form class="form" method="post"
                                              action="{{ URL::action('LocationController@postDeleteLocation') }}">
                                            {!! csrf_field() !!}
                                            <label class="control-label">Are you sure you want to delete the
                                                Location "{{ $item->name }}"</label>
                                            <input type="hidden" name="location_id" value="{{$item->id}}">
                                            <button type="submit" class="btn btn-red">Delete</button>
                                            <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                Back to safety
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection