@extends('layout')

@section('actions')
    <div class="btn-group">
        <a href="{{URL::action('ReligionController@getAddReligion')}}" type="button" class="btn btn-dark">
            Add a Religion
        </a>
    </div>
@endsection
@section('title')
    <i class="icon icon-religion"></i> Religions
@endsection
@section('content')
    <div class="table-responsive">
        <table class="table hr-table table-hover">
            <thead>
            <tr>
                <th> Name</th>
                <th> Actions</th>
            </tr>
            </thead>
            <tbody>

            @foreach($religions as $item)
                <tr>
                    <td> {{ $item->name }}</td>
                    <td>
                        <div class="hr-actions-cell">
                            <a href="{{ URL::action('ReligionController@getEditReligion',['id'=>$item->id]) }}"
                               class="btn btn-dark">
                                Edit
                            </a>
                            <a href="#delete_religion_{{$item->id}}" data-toggle="modal"
                               class="btn btn-red">
                                Delete
                            </a>
                        </div>
                        <div class="modal fade" id="delete_religion_{{$item->id}}">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-body">
                                        <form class="form" method="post"
                                              action="{{ URL::action('ReligionController@postDeleteReligion') }}">
                                            {!! csrf_field() !!}
                                            <div class="help-block">
                                                Are you sure you want to delete the Religion "{{ $item->name }}"
                                            </div>
                                            <input type="hidden" name="religion_id" value="{{$item->id}}">
                                            <div class="form-actions">
                                                <button type="submit" class="btn btn-red">
                                                    Delete
                                                </button>
                                                <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                    Back to safety
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection