@extends('layout')
@section('title')
    <i class="icon icon-announcements"></i> Welcome <strong>{{ $page['companyName'] }}</strong>
@endsection
@section('content')
    @if(count($announcements) !=0)
        <div class="col-xs-12" style="margin-bottom: 60px;">
            @foreach($announcements as $announcement)
                <div class="announcement bg-dark">
                    <div class="announcement-icon">
                        <i class="icon icon-announcements"></i>
                    </div>
                    <div class="details">
                        <strong>{{ $announcement->title }}</strong><br>
                        {{ $announcement->details }}
                    </div>
                    @if($announcement->attachment != null)
                        <div class="attachment">
                            <a href="{{ URL::asset($announcement->attachment) }}"
                               class="btn btn-green">
                                Download
                            </a>
                        </div>
                    @endif
                    <div class="time">
                       {{ $announcement->created_at }}
                    </div>
                </div>
            @endforeach
                {!! $announcements->render() !!}
        </div>
    @else
        <div class="col-xs-12">
            <div class="announcement bg-dark">
                <div class="announcement-icon">
                    <i class="icon icon-announcements"></i>
                </div>
                <div class="details">
                    No New Announcements
                </div>
            </div>
        </div>
    @endif
@endsection