@extends('layout')
@section('extra_css')
    <link href="{{ URL::asset('assets/global/css/components.css')}}" id="style_components" rel="stylesheet"
          type="text/css"/>
    <link href="{{ URL::asset('assets/global/css/plugins.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/admin/layout/css/layout.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/admin/layout/css/custom.css')}}" rel="stylesheet" type="text/css"/>
@endsection

@section('extra_js')
    <script src="{{ URL::asset('assets/global/scripts/metronic.js')}}" type="text/javascript"></script>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-xs-12">
                <div class="lead" style="color:#646464;">
                    Compensation and Benefits
                </div>
            </div>
            <div class="col-xs-12">
                <hr>
            </div>
            <div class="col-xs-12">
                <?php $compensations = Auth::user()->compensations()->get();?>
                <table class="table table-hover table-bordered">
                    <thead>
                    <tr>
                        <th>Compensation & Benefit</th>
                        <th>Current</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($compensations as $compensation)
                        @if($compensation->current_value != 0)
                            <tr>
                                <td>{{$compensation->parent->name}}</td>
                                <td>{{$compensation->current_value}}</td>
                            </tr>
                        @endif
                    @endforeach
                    </tbody>
                </table>
            </div>

            <div class="col-xs-12">
                {{--{!! $compensations->render() !!}--}}
            </div>
        </div>
    </div>
@endsection