@extends('layout')
@section('title')
    <i class="icon icon-incoming-requests"></i> Incoming {{ strtoupper($type) }} Requests
@endsection
@section('content')
    <ul class="nav nav-tabs nav-justified" role="tablist">
        <li class="active"><a href="#pending" role="tab" data-toggle="tab">Pending</a></li>
        <li><a href="#history" role="tab" data-toggle="tab">History</a></li>
    </ul>
    <!-- TAB CONTENT -->
    <div class="tab-content">
        <div class="active tab-pane fade in" id="pending">
            <div class="table-responsive">
                <table class="table hr-table table-hover">
                    <thead>
                    <tr>
                        <th> #</th>
                        <th> Request</th>
                        <th> From</th>
                        <th> Received</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $index = 1; ?>
                    @foreach($incoming_requests as $incoming)
                        @if($incoming->type == $type && $incoming->status == 'pending')
                            <tr>
                                <td> {{ $index++ }}</td>
                                <td>
                                    <a href="{{ URL::action('UserController@getRequestDetails',['id'=>$incoming->id]) }}"> {{ $incoming->request }} </a>
                                </td>
                                <td> {{ $incoming->sender }}</td>
                                <td> {{ \Carbon\Carbon::parse($incoming->request_date)->diffForHumans() }}</td>
                            </tr>
                        @endif
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="tab-pane fade" id="history">
            <div class="table-responsive">
                <table class="table hr-table table-hover">
                    <thead>
                    <tr>
                        <th> #</th>
                        <th> Request</th>
                        <th> From</th>
                        <th> Received</th>
                        <th> Status</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $index = 1; ?>
                    @foreach($incoming_requests as $incoming)
                        @if($incoming->type == $type && $incoming->status != 'pending')
                            <tr>
                                <td> {{ $index++ }}</td>
                                <td>
                                    <a href="{{ URL::action('UserController@getRequestDetails',['id'=>$incoming->id]) }}"> {{ $incoming->request }} </a>
                                </td>
                                <td> {{ $incoming->sender }}</td>
                                <td> {{ \Carbon\Carbon::parse($incoming->request_date)->diffForHumans() }}</td>
                                <td> {{ $incoming->status }}</td>
                            </tr>
                        @endif
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
