@extends('layout')
@section('title')
    Submit a {{ $policy->name }} Request
@endsection
@section('content')
    <form enctype="multipart/form-data" method="post"
          action="{{ URL::action('UserController@postSaveRequest') }}">
        {!! csrf_field() !!}
        <div class="form-group">
            <div class="well-sm jumbotron h4">
                Policy:<br>
                {{ $policy->information }}
            </div>
        </div>
        @if($policy->type == 'leave')
            <div class="form-group">
                <div class="help-block">
                    You currently have: {{$policy->leave_days}} Leave days
                </div>
            </div>
            <div class="form-group">
                <label for="from_date" class="control-label">
                    From
                </label>
                <input id="from_date" type="text" name="from_date" value="{{ old('from_date') }}"
                       class="form-control has-date-picker">
            </div>
            <div class="form-group">
                <label for="to_date" class="control-label">
                    To
                </label>
                <input id="to_date" type="text" name="to_date" value="{{ old('to_date') }}"
                       class="form-control has-date-picker">
            </div>
        @endif
        <div class="form-group">
            <label for="description" class="control-label">
                Add a Comment:
                <label class="required" aria-required="true">
                    *
                </label>
            </label>

            <textarea name="description" class="form-control" id="description">{{ old('description') }}</textarea>
        </div>
        @if($policy->requires_attachment)
            <div class="lead">
                Supply Documents:
            </div>
            <div class="form-group">
                <input name="files_attachment[]" type="file" class="form-control" id="files_attachment">
                <input name="files_attachment[]" type="file" class="form-control" id="files_attachment">
                <input name="files_attachment[]" type="file" class="form-control" id="files_attachment">
            </div>
        @endif
        <div class="form-actions text-center">
            <button type="submit" class="btn btn-green">
                Submit Request
            </button>
            <a href="{{ URL::action('UserController@getMyRequests') }}" class="btn btn-dark">
                Cancel
            </a>
        </div>
    </form>
@endsection