@extends('layout')
@section('title')
    <i class="icon icon-outgoing-requests"></i> My Requests
@endsection
@section('actions')
    <div class="btn-group">
        <a href="#add_request" data-toggle="collapse" type="button" class="btn btn-dark">
            New Request
        </a>
    </div>
@endsection

@section('content')
    <div class="portal collapse" id="add_request">
        <div class="portal-title">
            <div class="caption">
                <i class="fa fa-ticket"></i>New Request
            </div>
        </div>
        <div class="portal-body">
            <div id="action_request" class="row" style="margin:10px 0;">
                <div class="hr-actions-cell text-center">
                    <button class="btn btn-dark"
                            data-target="#leave_requests" data-toggle="collapse"
                            onclick="$('#action_request').toggleClass('collapse');">
                        <strong>Leave Requests</strong>
                    </button>
                    <button class="btn btn-dark"
                            data-target="#hr_requests" data-toggle="collapse"
                            onclick="$('#action_request').toggleClass('collapse');">
                        <strong>HR Requests</strong>
                    </button>
                </div>
            </div>
            <div id="leave_requests" class="collapse">
                <div class="help-block h3 text-center">Leave Requests</div>
                <div class="list-group">
                    @foreach($leave_policies as $policy)
                        <a href="{{ URL::action('UserController@getAddRequest',['id'=>$policy->policy_id]) }}"
                           class="list-group-item">
                            <i class="fa fa-circle-o-notch" style="color:green;"></i>
                            <strong>{{ $policy->name }}</strong>
                            <i class="fa fa-arrow-right pull-right"></i>
                        </a>
                    @endforeach
                </div>
                <button data-target="#leave_requests" data-toggle="collapse" style="margin:15px;"
                        class="btn btn-success" onclick="$('#action_request').toggleClass('collapse');">
                    Back
                </button>
            </div>
            <div id="hr_requests" class="collapse">
                <div class="help-block h3 text-center">HR Requests</div>
                <div class="list-group">
                    @foreach($hr_policies as $policy)
                        <a href="{{ URL::action('UserController@getAddRequest',['id'=>$policy->policy_id]) }}"
                           class="list-group-item">
                            <i class="fa fa-circle-o-notch" style="color:green;"></i>
                            <strong>{{ $policy->name }}</strong>
                            <i class="fa fa-arrow-right pull-right"></i>
                        </a>
                    @endforeach
                </div>
                <button data-target="#hr_requests" data-toggle="collapse" style="margin:15px;"
                        class="btn btn-green" onclick="$('#action_request').toggleClass('collapse');">
                    Back
                </button>
            </div>
        </div>
    </div>
    <ul class="nav nav-tabs nav-justified" role="tablist">
        <li class="active"><a href="#hr-table" role="tab" data-toggle="tab">HR Requests</a></li>
        <li><a href="#leave-table" role="tab" data-toggle="tab">Leave Requests</a></li>
    </ul>
    <div class="tab-content">
        <div class="active tab-pane fade in" id="hr-table">
            <div class="table-responsive">
                <table class="table hr-table table-hover">
                    <thead>
                    <tr>
                        <th> #</th>
                        <th> Request</th>
                        <th> Sent</th>
                        <th> Status</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $index = 1;?>

                    @foreach($requests as $request)
                        @if($request->type == 'hr')
                            <?php
                            $color = 'warning';
                            if ($request->status == 'denied')
                                $color = 'danger';
                            elseif ($request->status == 'accepted')
                                $color = 'success';
                            elseif ($request->status == 'reviewed')
                                $color = 'info';
                            ?>
                            <tr class="bg-{{$color}}">
                                <td> {{ $index++ }}</td>
                                <td>
                                    <a href="{{ URL::action('UserController@getRequestDetails',['id'=>$request->id]) }}">
                                        {{ $request->request }}
                                    </a>
                                </td>
                                <td> {{ \Carbon\Carbon::parse($request->request_date)->diffForHumans() }}</td>
                                <td>
                                    <strong>
                                        {{ \Illuminate\Support\Str::studly($request->status) }}
                                    </strong>
                                </td>
                            </tr>
                        @endif
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>

        <div class="tab-pane fade" id="leave-table">
            <div class="table-responsive">
                <table class="table hr-table table-hover">
                    <thead>
                    <tr>
                        <th> #</th>
                        <th> Request</th>
                        <th> Sent</th>
                        <th> From</th>
                        <th> To</th>
                        <th> Status</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $index = 1;?>

                    @foreach($requests as $request)
                        @if($request->type == 'leave')
                            <?php
                            $color = 'warning';
                            if ($request->status == 'denied')
                                $color = 'danger';
                            elseif ($request->status == 'accepted')
                                $color = 'success';
                            elseif ($request->status == 'reviewed')
                                $color = 'info';
                            ?>
                            <tr class="bg-{{$color}}">
                                <td> {{ $index++ }}</td>
                                <td>
                                    <a href="{{ URL::action('UserController@getRequestDetails',['id'=>$request->id]) }}">
                                        {{ $request->request }}
                                    </a>
                                </td>
                                <td> {{ \Carbon\Carbon::parse($request->request_date)->diffForHumans() }}</td>
                                <td>{{ $request->from_date }}</td>
                                <td>{{ $request->to_date }}</td>
                                <td>
                                    <strong>
                                        {{ \Illuminate\Support\Str::studly($request->status) }}
                                    </strong>
                                </td>
                            </tr>
                        @endif
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection