@extends('layout')
@section('title')
    {{ $details->request->request }}
@endsection
@section('content')
    <div class="media">
        <div class="media-body">
            <h4 class="media-heading">Policy: {{ $details->request->request }}</h4>
            <br>
            <strong class="h4">Sender:@if(Auth::user()->id == $details->request->user_id)
                    You @else {{$details->request->name}} @endif</strong><br><br>
            <strong class="h4">Sent:</strong>
            <strong>{{ \Carbon\Carbon::parse($details->request->request_date)->diffForHumans() }}</strong><br><br>

            @if($details->request->type == 'leave')
                <span class="h4">From:</span> <strong>{{ $details->request->from_date }}</strong><br><br>
                <span class="h4">To:</span> <strong>{{ $details->request->to_date }}</strong><br><br>
            @endif
            @if($details->request->status != '')
                <span class="h4">Status:</span><strong>{{ $details->request->status }}</strong><br><br>
            @endif
            <span class="h4">Details:</span><br>

            <strong>{{$details->request->description}}</strong>
            @if($details->request->attachment || count($details->request->attachments))
                <hr>
                <strong class="h4">Attachments: </strong>
            @endif
            <?php $count = 1;?>
            {{-- oldAPI: This section exists to support the old Attachment API --}}
            @if($details->request->attachment)
                <a href="{{ URL::asset($details->request->attachment) }}" class="btn btn-green"> Download [#{{$count}}
                    ] </a>
                <?php $count++; ?>
            @endif
            {{-- ./oldAPI --}}
            @if($details->request->attachments)
                @foreach($details->request->attachments as $attachment)
                    <a href="{{ $attachment }}" class="btn btn-green"> <i class="fa fa-download"></i> Download
                        [#{{$count}}] </a>
                    <?php $count++ ?>
                @endforeach
            @endif
        </div>
    </div>
    <hr>
    <div class="h3">Status</div>
    @foreach($details->statusHistory as $status)
        <div class="announcement bg-dark">
            <div class="announcement-icon">
                <i class="icon icon-company-settings"></i>
            </div>
            <div class="details">
                {{ $status->name }} @if($status->title)| {{ $status->title }}@endif
                <br>
                Status: <strong>{{ ucfirst($status->status) }}</strong>
                <br>
                @if($status->comment != null)
                    <p class="comment">
                        Comment: {{ $status->comment }}
                    </p>
                @endif
            </div>
            <div class="time">
                On: {{ $status->date }}
            </div>
        </div>
    @endforeach
    <div class="form-actions">
        @if(isset($details->currentCycle) && $details->request->status == 'pending'
        && ($details->currentCycle->current_user_id == \Auth::user()->id ||
        ($details->currentCycle->current_user_id == null && \Auth::user()->getRole()=="HRAdmin")))
            <?php $request_cycle = $details->currentCycle; ?>
            @if($request_cycle->approval_type == "review")
                <div class="btn-group btn-group-justified">
                    <a data-toggle="modal"
                       href="#review_modal"
                       class="btn btn-green">
                        Review
                    </a>
                    <a href="{{ URL::previous() }}" class="btn btn-dark">
                        Later
                    </a>
                </div>
                <div class="modal" id="review_modal">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-body">
                                <form method="post"
                                      action="{{ URL::action('UserController@postRequestAction') }}">
                                    <input type="hidden" name="requestId"
                                           value="{{ $details->request->id }}">
                                    {!! csrf_field() !!}
                                    <input type="hidden" name="response" value="reviewed">

                                    <div class="form-group">
                                        <label class="control-label">
                                            Add a comment
                                        </label>
                                        <textarea name="comment" class="form-control"></textarea>
                                    </div>
                                    <div class="form-actions">
                                        <button class="btn btn-green">
                                            Review
                                        </button>
                                        <button data-target="#review_modal"
                                                class="btn btn-dark" data-dismiss="modal">
                                            Cancel
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            @else
                <div class="btn-group btn-group-justified">
                    <a class="btn btn-green"
                       href="#accept_modal"
                       data-toggle="modal">
                        <i class="fa fa-thumbs-up"></i> Accept
                    </a>
                    <a class="btn btn-red"
                       href="#reject_modal"
                       data-toggle="modal">
                        <i class="fa fa-thumbs-down"></i> Reject
                    </a>
                    <a href="{{ URL::previous() }}" class="btn btn-dark">
                        Later
                    </a>
                </div>

                <div class="modal" id="accept_modal">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-body">
                                <form method="post"
                                      action="{{ URL::action('UserController@postRequestAction') }}">
                                    <input type="hidden" name="requestId"
                                           value="{{ $details->request->id }}">
                                    {!! csrf_field() !!}
                                    <input type="hidden" name="response" value="accepted">

                                    <div class="form-group">
                                        <label class="control-label">
                                            Add a comment
                                        </label>
                                        <textarea name="comment" class="form-control"></textarea>
                                    </div>
                                    <div class="form-actions">
                                        <button class="btn btn-green">
                                            Accept
                                        </button>
                                        <button data-target="#accept_modal"
                                                class="btn btn-dark" data-dismiss="modal">
                                            Cancel
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal" id="reject_modal">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-body">
                                <form method="post"
                                      action="{{ URL::action('UserController@postRequestAction') }}">
                                    <input type="hidden" name="requestId"
                                           value="{{ $details->request->id }}">
                                    {!! csrf_field() !!}
                                    <input type="hidden" name="response" value="denied">

                                    <div class="form-group">
                                        <label class="control-label">
                                            Add a comment
                                        </label>
                                        <textarea name="comment" class="form-control"></textarea>
                                    </div>
                                    <div class="form-actions">
                                        <button class="btn btn-red">
                                            Reject
                                        </button>
                                        <button data-target="#reject_modal"
                                                class="btn btn-dark" data-dismiss="modal">
                                            Cancel
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        @endif
        @if($details->request->user_id == Auth::user()->id)
            @if($details->request->status == 'pending')
                <form method="post"
                      action="{{ URL::action('UserController@postCancelRequest')}}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="request_id" value="{{$details->request->id}}">
                    <button type="submit" class="btn btn-red btn-block" style="margin-top:5px;">Cancel</button>
                </form>
            @endif
        @endif
    </div>
@endsection