@extends('layout')
@section('pageCss')
    <link rel="stylesheet" type="text/css" href="{{ URL::asset('assets/css/vendor/international.phones.css') }}">
    <script src="{{ URL::asset('assets/js/countries.js') }}" type="text/javascript"></script>
@endsection
@section('pageScripts')
    <script type="text/javascript"
            src="{{ URL::asset('assets/js/vendor/validate.min.js') }}"></script>
    <script type="text/javascript"
            src="{{ URL::asset('assets/js/vendor/validate.additional.js') }}"></script>
    <script src="{{ URL::asset('assets/js/vendor/international.phones.min.js') }}"></script>

    <script src="{{ URL::asset('assets/js/vendor/international.phones.utility.js') }}"></script>
    <script src="http://maps.googleapis.com/maps/api/js?sensor=false&libraries=places"></script>
    <script src="{{ URL::asset('assets/js/vendor/geocomplete.js') }}"></script>
    <script>
        $('input[type="tel"]').intlTelInput();
        var homeMap =$('.geo-home-map-canvas');
        var currentMap =$('.geo-current-map-canvas');
        homeMap.height(300);
        currentMap.height(300);
        $('#geo-current-country').geocomplete({
            map: currentMap,
            location: '{{$user->current_address}}'
        });
        $('#geo-home-country').geocomplete({
            map: homeMap,
            location: '{{$user->home_country_address}}'
        });
    </script>
@endsection
@section('title')
    <i class="icon icon-profile"></i> {{$user->name}}
@endsection
@section('content')
    <div class="row">
        <div class="col-md-3">
            <ul class="nav nav-pills-stacked margin-bottom-10">
                <li class="active">
                    <a data-toggle="tab" href="#tab_2-2">
                        <i class="fa fa-picture-o"></i> Personal Information</a>
                </li>
                <li>
                    <a data-toggle="tab" href="#tab_1-1">
                        <i class="fa fa-cog"></i> Employee Details </a>
												<span class="after">
												</span>
                </li>
                <li>
                    <a data-toggle="tab" href="#tab_3-3">
                        <i class="fa fa-lock"></i> Job Information </a>
                </li>
                <li>
                    <a data-toggle="tab" href="#tab_4-4">
                        <i class="fa fa-eye"></i> Line Managers </a>
                </li>
                <li>
                    <a data-toggle="tab" href="#tab_6-6">
                        <i class="fa fa-eye"></i> Compensation and Benefits </a>
                </li>
                <li>
                    <a data-toggle="tab" href="#tab_5-5">
                        <i class="fa fa-eye"></i> Leave Balances </a>
                </li>
            </ul>
        </div>
        <div class="col-md-9">
            <style>
                .dd-left > dt {
                    text-align: left;
                }
            </style>
            <div class="tab-content">
                <div id="tab_1-1" class="tab-pane">
                    <ul class="list-group">
                        <li class="list-group-item">Name: {{ $user->name }}</li>
                        <li class="list-group-item">Employee ID: {{ $user->employee_id }}</li>
                        <li class="list-group-item">Company Email: {{ $user->company_email }}</li>
                        <li class="list-group-item">Company Contact Number: {{ $user->company_phone }}</li>
                        <li class="list-group-item">Company P.O. Box: {{ $user->company_po_box }}</li>
                    </ul>
                </div>
                <div id="tab_2-2" class="tab-pane active">
                    <ul class="list-group">
                        <li class="list-group-item">Gender: {{ $user->gender }}</li>
                        <li class="list-group-item">Email: {{ $user->email }}</li>
                        <li class="list-group-item">Religion: {{ $user->religion }}</li>
                        <li class="list-group-item">Current Address: {{ $user->current_address }}<br>
                            <input type="hidden" id="geo-current-country" value="{{$user->current_address}}">
                            <div class="geo-current-map-canvas"></div>
                        </li>
                        <li class="list-group-item">Home Country Address: {{ $user->home_country_address }}<br>
                            <input type="hidden" id="geo-home-country" value="{{$user->home_country_address}}">
                            <div class="geo-home-map-canvas"></div>
                        </li>
                        <li class="list-group-item">Home Country Contact
                            Number: {{ $user->home_country_contact_number }}</li>
                        <li class="list-group-item">Home Country P.O. Box: {{ $user->original_po_box }}</li>
                        <li class="list-group-item">Nationality: {{ $user->nationality }}</li>
                        <li class="list-group-item">Marital Status: {{ $user->marital_status }}</li>
                        <li class="list-group-item">Visa Expiry Date: {{ $user->visa_expiry_date }}</li>
                        <li class="list-group-item">Medical Insurance Expiry
                            Date: {{ $user->medical_insurance_expiry_date }}</li>
                    </ul>
                </div>
                <div id="tab_3-3" class="tab-pane">
                    <ul class="list-group">
                        <li class="list-group-item">Department: {{ $user->department or 'Not Assigned' }}</li>
                        <li class="list-group-item">Group: {{ $user->group or 'Not Assigned' }}</li>
                        <li class="list-group-item">Title: {{ $user->title }}</li>
                        <li class="list-group-item">Join Date: {{ $user->join_date }}</li>
                        <li class="list-group-item">Project/ Location: {{ $user->location }}</li>
                    </ul>
                </div>
                <div id="tab_4-4" class="tab-pane">
                    <ul class="list-group">
                        @if(is_array($user->managers))
                            <li class="list-group-item">
                                Line Managers
                            </li>
                            <?php $i = 1; ?>
                            @foreach($user->managers as $manager)
                                <li class="list-group-item">
                                    <span class="label label-info">Line Manager#:{{ $i++ }} </span>
                                    <span class="label label-primary"> {{ $manager->name }}</span>
                                </li>
                            @endforeach
                        @endif
                    </ul>
                </div>
                <div id="tab_5-5" class="tab-pane">
                    <div class="form form-horizontal">
                        <ul class="list-group">
                            <li class="list-group-item">
                                Leave Balance
                            </li>
                            <table class="table hr-table">
                                <thead>
                                <tr>
                                    <th>Leave</th>
                                    <th>Balance</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($user->leaves_balance as $leave)
                                    <tr>
                                        <td>
                                            {{$leave->name}}
                                        </td>
                                        <td>
                                            {{$leave->value.' '.\Illuminate\Support\Str::plural('Day', $leave->value)}}
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>
                        </ul>
                    </div>
                </div>
                <div id="tab_6-6" class="tab-pane">
                    <div class="form form-horizontal">
                        <ul class="list-group">
                            <li class="list-group-item">
                                Compensation and Benefits
                            </li>
                            <table class="table hr-table">
                                <thead>
                                <tr>
                                    <th>Compensation/ Benefit</th>
                                    <th>Value</th>
                                </tr>
                                </thead>
                                <tbody>
                                @foreach($user->compensations as $compensation)
                                    <tr>
                                        <td>
                                            {{$compensation->name}}
                                        </td>
                                        <td>
                                            {{$compensation->value.' '.$user->currency}}
                                        </td>
                                    </tr>
                                @endforeach
                                </tbody>
                            </table>

                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <!--end col-md-9-->
    </div>

@endsection