<!DOCTYPE html>
<html lang="en">
<!-- BEGIN HEAD -->
<head>
    <script type="text/javascript" id="sessionCheck">
        var xmlHttp;
        if (window.XMLHttpRequest) {
            // code for IE7+, Firefox, Chrome, Opera, Safari
            xmlHttp = new XMLHttpRequest();
        } else {
            // code for IE6, IE5
            xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
        }
        xmlHttp.onreadystatechange = function () {
            if (xmlHttp.readyState == XMLHttpRequest.DONE) {
                if (xmlHttp.status == 200) {
                    if (xmlHttp.response == 0)
                        document.location.href = "{!! URL::to('session-expired') !!}";
                }
            }
        }
        xmlHttp.open("POST", "{{ URL::to('secure') }}", false);
        xmlHttp.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
        xmlHttp.send();
        //Removing this after the check

    </script>
    <meta charset="utf-8"/>
    <title>HRFlo</title>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <meta http-equiv="Content-type" content="text/html; charset=utf-8">
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:400,300,600,700&subset=all" rel="stylesheet"
          type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/font-awesome.min.css')}}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/bootstrap.min.css')}}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/bootstrap-datepicker.css')}}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ URL::asset('assets/css/vendor/metisMenu.css')}}" rel="stylesheet"
          type="text/css"/>
    <link href="{{ URL::asset('assets/css/site.css')}}" type="text/css" rel="stylesheet"/>
    @yield('pageCss')

    <script>
        (function (i, s, o, g, r, a, m) {
            i['GoogleAnalyticsObject'] = r;
            i[r] = i[r] || function () {
                        (i[r].q = i[r].q || []).push(arguments)
                    }, i[r].l = 1 * new Date();
            a = s.createElement(o),
                    m = s.getElementsByTagName(o)[0];
            a.async = 1;
            a.src = g;
            m.parentNode.insertBefore(a, m)
        })(window, document, 'script', 'https://www.google-analytics.com/analytics.js', 'ga');

        ga('create', 'UA-77743369-3', 'auto');
        ga('send', 'pageview');

    </script>
</head>
<!-- END HEAD -->

<!-- BEGIN BODY -->
<body class="bash @if(!\Session::has('SuperMode')) bg-dark @endif">
<!-- BEGIN FULL SCREEN LOADER -->
<div id="loader-wrapper">
    <div id="loader">
    </div>
    <div class="hrflo-title">
        HRFlo
    </div>
</div>
<!-- END FULL SCREEN LOADER -->

<!-- INCLUDE MAIN NAVIGATION AND SIDEBAR HEADER -->
@include('header')
@if(\Session::has('SuperMode'))
    <div class="container">
        <div class="row">
            <div class="col-xs-12">
                @include('partials.page_header')
            </div>
            <div class="col-md-12">
                @if(\Session::has('system_message'))
                    <div class="alert alert-success">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <strong>Notice:</strong> {{ \Session::get('system_message') }}
                    </div>
                @endif
                {{-- Content --}}
                @yield('content')
                {{-- ./Content --}}
            </div>
        </div>
    </div>
@else
    <div class="page-wrapper">
        <!-- INCLUDE PAGE HEADER -->
        @include('partials.page_header')
        <div class="row">
            <div class="col-md-12">
                @if(\Session::has('system_message'))
                    <div class="alert alert-success">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                        <strong>Notice:</strong> {{ \Session::get('system_message') }}
                    </div>
                @endif
                {{-- Content --}}
                @yield('content')
                {{-- ./Content --}}
            </div>
        </div>
    </div>
    @endif
            <!-- Default required JS -->
    <script src="{{ URL::asset('assets/js/vendor/jquery.min.js')}}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/jquery-ui.min.js')}}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/bootstrap.min.js')}}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/metisMenu.js')}}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/hrflo.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/bootstrap-datepicker.min.js')}}" type="text/javascript"></script>
    <!-- Page Specific JS -->
    @yield('pageScripts')
    <script>
        HRFlo.init();
    </script>
</body>
</html>