<!-- BEGIN SIDEBAR -->
<div class="navbar-default sidebar bg-dark" role="navigation">
    <div class="sidebar-nav navbar-collapse">
        <ul class="nav">
            @if($admin)
                <li class="@if(Request::is('dashboard')) active @endif">
                    <a href="{{URL::to('dashboard')}}">
                        <i class="icon icon-dashboard"></i>
                        Dashboard
                    </a>
                </li>
                <li class="@if(Request::is('dashboard/database*') && !Request::is('dashboard/database/policies*')) active @endif">
                    <a href="#">
                        <i class="icon icon-database"></i>
                        <span class="title">Database</span>
                        <span class="arrow"></span>
                    </a>
                    <ul class="nav nav-second-level bg-dark">
                        <li class="@if(Request::is('dashboard/database/users*')) active highlight @endif">
                            <a href="{{ URL::action('UsersController@getList') }}">
                                <i class="icon icon-employees"></i>
                                Employees
                            </a>
                        </li>
                        <li class="@if(Request::is('dashboard/database/departments*')) active highlight @endif">
                            <a href="{{ URL::action('DepartmentsController@getList') }}">
                                <i class="icon icon-department"></i>
                                Departments
                            </a>
                        </li>
                        <li class="@if(Request::is('dashboard/database/groups*')) active highlight @endif">
                            <a href="{{ URL::action('GroupsController@getList') }}">
                                <i class="icon icon-house"></i>
                                Groups
                            </a>
                        </li>
                    </ul>
                </li>
                <li class="@if(Request::is('dashboard/user-settings*') || Request::is('dashboard/database/policies*')) active @endif bg-dark">
                    <a href="#">
                        <i class="icon icon-company-settings"></i>
                        <span class="title">Settings</span>
                        <span class="arrow "></span>
                    </a>
                    <ul class="nav nav-second-level bg-dark">
                        <li class="@if(Request::is('dashboard/user-settings/compensation*')) active highlight @endif">
                            <a href="{{ URL::action('SettingsController@getIndex') }}">
                                <i class="icon icon-company-settings"></i>
                                General
                            </a>
                        </li>
                        <li class="@if(Request::is('dashboard/database/policies*')) active @endif">
                            <a href="#">
                                <i class="icon icon-hand"></i>
                                <span class="title">Policies</span>
                                <span class="arrow "></span>
                            </a>
                            <ul class="nav nav-third-level bg-dark">
                                <li class="@if(Request::is('dashboard/database/policies/*/leave*')) active highlight @endif">
                                    <a href="{{ URL::action('PolicyController@get',['type'=>'leave']) }}">
                                        <i class="icon icon-policies"></i>
                                        Leave Policies</a>
                                </li>
                                <li class="@if(Request::is('dashboard/database/policies/*/hr*')) active highlight @endif">
                                    <a href="{{URL::action('PolicyController@get',['type'=>'hr'])}}">
                                        <i class="icon icon-policies"></i>
                                        HR Policies
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li class="@if(Request::is('dashboard/user-settings/compensation*')) active highlight @endif">
                            <a href="{{ URL::action('CompensationController@getList') }}">
                                <i class="icon icon-compensation"></i>
                                Compensations</a>
                        </li>
                        <li class="@if(Request::is('dashboard/settings/announcements*')) active highlight @endif">
                            <a href="{{ URL::to('dashboard/settings/announcements/list') }}">
                                <i class="icon icon-announcements"></i>
                                Announcements</a>
                        </li>
                        <li class="@if(Request::is('dashboard/user-settings/religion*')) active highlight @endif">
                            <a href="{{ URL::action('ReligionController@getList') }}">
                                <i class="icon icon-religion"></i>
                                Religions</a>
                        </li>
                        <li class="@if(Request::is('dashboard/user-settings/location*')) active highlight @endif">
                            <a href="{{ URL::action('LocationController@getList') }}">
                                <i class="icon icon-location"></i>
                                Locations</a>
                        </li>
                    </ul>
                </li>
                <li class="@if(Request::is('dashboard/database*') && !Request::is('dashboard/database/policies*')) active @endif">
                    <a href="#">
                        <i class="icon icon-database"></i>
                        <span class="title">Logs</span>
                        <span class="arrow"></span>
                    </a>
                    <ul class="nav nav-second-level bg-dark">
                        <li class="@if(Request::is('dashboard/logs/requests*')) active highlight @endif">
                            <a href="{{ URL::route('logs.requests',['userId'=>Input::get('userId'),
                'from'=>Input::get('from'),
                'to'=>Input::get('to'),
                'page'=>1,
                'perPage'=>10],false) }}">
                                <i class="icon icon-employees"></i>
                                Requests
                            </a>
                        </li>
                    </ul>
                </li>
            @elseif($super)
                <li>
                    <a href="{{URL::action('CompaniesController@getList')}}">
                        <i class="icon icon-company-settings"></i>
                        Companies
                    </a>
                </li>
            @else
                <li class="@if(Request::is(URL::action('UserController@getProfile'))) active @endif">
                    <a href="{{ URL::action('UserController@getProfile') }}">
                        <i class="icon icon-profile"></i>
                        Profile</a>
                </li>
                <li class="@if(Request::is('dashboard/announcements*')) active @endif">
                    <a href="{{ URL::to('dashboard/announcements') }}">
                        <i class="icon icon-announcements"></i>
                        Announcements</a>
                </li>
                <li class="@if(Request::is(URL::action('UserController@getIncomingRequests',['type'=>'hr']))) active @endif">
                    <a href="{{ URL::action('UserController@getIncomingRequests',['type'=>'hr']) }}">
                        <i class="icon icon-incoming-requests"></i>
                        Incoming HR Requests
                        <label class="badge badge-active">{{--{{ Auth::user()->getIncomingRequestsCount('hr') }}--}}</label>
                    </a>
                </li>
                <li class="@if(Request::is(URL::action('UserController@getIncomingRequests',['type'=>'leave']))) active @endif">

                    <a href="{{ URL::action('UserController@getIncomingRequests',['type'=>'leave']) }}">
                        <i class="icon icon-incoming-requests"></i>
                        Incoming Leave Requests
                        <label class="badge badge-active">{{--{{ Auth::user()->getIncomingRequestsCount('leave') }}--}}</label>
                    </a>
                </li>
                <li class="@if(Request::is('dashboard/my/requests*')) active @endif">
                    <a href="{{ URL::action('UserController@getMyRequests') }}">
                        <i class="icon icon-outgoing-requests"></i>
                        My Requests
                    </a>
                </li>
            @endif
        </ul>
    </div>
    <!-- END SIDEBAR MENU -->
</div>
<!-- END SIDEBAR -->
