@extends('layout')
@section('title')
    Add a new Company
@endsection
@section('pageCss')
    <link rel="stylesheet" type="text/css" href="{{ URL::asset('assets/css/vendor/international.phones.css') }}">
@endsection
@section('pageScripts')
    <script src="http://maps.googleapis.com/maps/api/js?sensor=false&libraries=places"></script>
    <script src="{{ URL::asset('assets/js/vendor/geocomplete.js')}}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/international.phones.min.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/js/vendor/international.phones.utility.js') }}" type="text/javascript"></script>
    <script>
        $('input[type="tel"]').intlTelInput({
            separateDialCode: true
        })
        $('.geo-location').geocomplete()
    </script>
@endsection
@section('content')
    <form action="{{ URL::action('CompaniesController@postCreate') }}" method="POST">
        {!! csrf_field() !!}
        <div class="lead">Company Information</div>
        <div class="form-group">
            <label for="company_name" class="control-label"> Name </label>
            <input id="company_name" type="text" class="form-control" name="company[name]"
                   value="{{old('company.name')}}" placeholder="Name...">
        </div>
        <div class="form-group">
            <label for="company_domain" class="control-label"> Domain </label>
            <div class="input-group">
                <input id="company_domain" type="text" class="form-control" name="company[domain]"
                       value="{{old('company.domain')}}" placeholder="Domain...">
                <div class="input-group-addon">
                    .{{env('DOMAIN')}}
                </div>
            </div>
        </div>
        <div class="form-group">
            <label for="company_free_user_capacity" class="control-label"> Free Users Capacity </label>
            <input id="company_free_user_capacity" type="number" class="form-control" name="company[free_user_capacity]"
                   value="{{old('company.free_user_capacity')}}" placeholder="Free Users Capacity...">
        </div>
        <div class="form-group">
            <label for="location" class="control-label">Location</label>
            <input id="location" name="company[location]" value="{{old('company.location')}}"
                   class="form-control geo-location">
        </div>
        <div class="form-group">
            <label for="industry" class="control-label">Industry</label>
            <input id="industry" name="company[industry]" value="{{old('company.industry')}}" class="form-control"
                   placeholder="Industry...">
        </div>
        <div class="form-group">
            <label for="hr_capacity" class="control-label">HR Administrators Capacity</label>
            <input type="number" min="1" id="hr_capacity" name="company[hr_capacity]"
                   value="{{old('company.hr_capacity') or 1}}" class="form-control"
                   placeholder="HR Administrators Capacity...">
        </div>
        <hr class="hr">
        <div class="lead">Contact Information</div>
        <div class="form-group">
            <label class="control-label" for="contact_name"> Name </label>
            <input type="text" class="form-control" id="contact_name" value="{{old('contact.name')}}"
                   name="contact[name]" placeholder="Name...">
        </div>
        <div class="form-group">
            <label class="control-label" for="contact_email"> Email </label>
            <input type="text" class="form-control" name="contact[email]" value="{{old('contact.email')}}"
                   id="contact_email" placeholder="Email...">
        </div>
        <div class="form-group">
            <label class="control-label" for="contact_mobile_number"> Mobile Number </label>
            <input type="tel" class="form-control" id="contact_mobile_number" value="{{old('contact.mobile')}}"
                   name="contact[mobile]">
        </div>
        <hr class="hr">
        <div class="lead">Registration Transaction</div>
        <div class="form-group">
            <label>User Capacity</label>
            <input id="capacity" type="number" class="form-control" value="{{old('transaction.capacity') or 5}}"
                   name="transaction[capacity]" min="5">
        </div>
        <div class="form-group">
            <label for="fees" class="control-label">Registration Fees</label>
            <input id="fees" type="text" class="form-control" value="{{old('transaction.fees')}}"
                   name="transaction[fees]">
        </div>
        <div class="form-group">
            <label for="currency" class="control-label">Currency</label>
            <select id="currency" name="transaction[currency]" class="form-control">
                @foreach(\App\Util::getCurrencies() as $opt)
                    <option value="{{$opt}}">{{$opt}}</option>
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <label for="details" class="control-label">Details</label>
            <textarea name="transaction[details]" id="details" cols="30" rows="10"
                      class="form-control">{{old('transaction.details')}}</textarea>
        </div>
        <div class="form-group">
            <label for="transaction_status" class="control-label">Status</label>
            <select name="transaction[status]" id="transaction_status" class="form-control">
                <option value="pending">Pending</option>
                <option value="closed">Closed</option>
            </select>
        </div>
        <div class="form-actions">
            <a href="{{URL::action('CompaniesController@getList')}}" class="btn btn-dark">
                Cancel
            </a>
            <button type="submit" class="btn btn-green">
                Save
            </button>
        </div>
    </form>
@endsection