@extends('layout')
@section('title')
    Edit {{$company->name}}
@endsection
@section('pageScripts')
    <script src="http://maps.googleapis.com/maps/api/js?sensor=false&libraries=places"></script>
    <script src="{{ URL::asset('assets/js/vendor/geocomplete.js')}}" type="text/javascript"></script>
    <script>
        $('.geo-location').geocomplete()
    </script>
@endsection
@section('actions')
    <div class="btn-group">
        <a class="btn btn-{{($company->active)?"red":"green" }}"
           data-target="#change_active_status{{$company->id}}" data-toggle="modal">
            {{ ($company->active)?"Deactivate":"Activate" }}
        </a>
    </div>
    <div class="modal fade" id="change_active_status{{$company->id}}">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body">
                    <form method="post"
                          action="{{ URL::action('CompaniesController@postChangeActiveStatus') }}">
                        {!! csrf_field() !!}
                        <input type="hidden" value="{{$company->id}}" name="company_id">
                        <input type="hidden" value="{{($company->active)?'true':'false'}}"
                               name="status">
                        <div class="help-block">Are you sure you want
                            to {{ ($company->active)?"deactivate":"activate" }} the
                            company "{{ $company->name }}"
                        </div>
                        <div class="form-actions">
                            <button type="submit" class="btn btn-{{($company->active)?"red":"green" }}">
                                {{ ($company->active)?"Deactivate":"Activate" }}
                            </button>
                            <button type="button" data-dismiss="modal" class="btn btn-dark">
                                Back to safety
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('content')
    <div class="col-xs-12 col-md-3">
        <ul class="nav nav-pills-stacked">
            <li class="active">
                <a data-toggle="tab" href="#tab_information">
                    <i class="fa fa-info"></i> Information</a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab_contact">
                    <i class="fa fa-info"></i> Contact</a>
            </li>
            <li>
                <a data-toggle="tab" href="#tab_transactions">
                    <i class="fa fa-money"></i> Transactions </a>
            </li>
        </ul>
    </div>
    <div class="col-xs-12 col-md-9">
        <div class="tab-content">
            <div class="active tab-pane fade in" id="tab_information">
                <form action="{{ URL::action('CompaniesController@postUpdateDetails') }}" method="POST">
                    {!! csrf_field() !!}
                    <input type="hidden" name="company_id" value="{{$company->id}}">
                    <div class="lead">Company Information</div>
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-addon">
                                Name
                            </div>
                            <input title="Name" type="text" class="form-control" name="company[name]"
                                   placeholder="Name..." value="{{$company->name}}">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-addon">
                                Domain
                            </div>
                            <input title="Domain" type="text" class="form-control" name="company[domain]"
                                   placeholder="Domain..." value="{{$company->domain}}">
                            <div class="input-group-addon">
                                .{{env('DOMAIN')}}
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-addon">
                                Free Users Capacity
                            </div>
                            <input title="Free Users Capacity" type="number" class="form-control"
                                   name="company[free_user_capacity]"
                                   placeholder="Free User Capacity..." value="{{$company->free_user_capacity}}">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-addon">
                                Location
                            </div>
                            <input title="Location" name="company[location]" class="form-control geo-location"
                                   value="{{$company->location}}">
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-addon">
                                Industry
                            </div>
                            <input title="industry" name="company[industry]" class="form-control"
                                   placeholder="Industry..."
                                   value="{{$company->industry}}">
                        </div>
                    </div>
                    <div class="form-actions">
                        <button type="submit" class="btn btn-green">
                            Update {{$company->name}}
                        </button>
                    </div>
                </form>
                <hr>
                <form method="post" action="{{ URL::action('CompaniesController@postUpdateHRAdminCapacity') }}">
                    {!! csrf_field() !!}
                    <input type="hidden" name="company[id]" value="{{$company->id}}">
                    <div class="form-group">
                        <div class="input-group">
                            <div class="input-group-addon">
                                HR Administrators Capacity
                            </div>
                            <input type="number" class="form-control" name="company[hr_capacity]"
                                   title="HR Administratiors Capacity"
                                   placeholder="HR Administrators Capacity" value="{{$company->hr_capacity}}">
                            <div class="input-group-btn">
                                <button class="btn btn-green">
                                    <i class="fa fa-refresh"></i>
                                    Update HR Capacity
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="form-group">
                    <div class="input-group">
                        <div class="input-group-addon">Total Employees Capacity</div>
                        <input title="Employees Capacity" class="form-control form-control-static"
                               value="{{$company->capacity}}" disabled>
                    </div>
                </div>
                @if(!$company->verified)
                    <form action="{{ URL::action('CompaniesController@postResendActivationEmail') }}" method="post">
                        {!! csrf_field() !!}
                        <input type="hidden" name="company[id]" value="{{$company->id}}">
                        @endif
                        <div class="form-group">
                            <div class="input-group">
                                <div class="input-group-addon">
                                    Activation Email Status
                                </div>

                                @if($company->verified)
                                    <input id="company_verified" class="form-control form-control-static"
                                           value="Email sent successfully" disabled>
                                @else
                                    <input type="text" class="form-control form-control-static" id="company_verified"
                                           placeholder="HR Administrators Capacity"
                                           value="There was a problem sending the Activation Email" disabled>
                                    <div class="input-group-btn">
                                        <button class="btn btn-green" type="submit">
                                            <i class="fa fa-refresh"></i>
                                            Resend Activation Email
                                        </button>
                                    </div>
                                @endif
                            </div>
                        </div>
                        @if(!$company->verified)
                    </form>
                @endif
                <div class="form-group">
                    <div class="input-group">
                        <div class="input-group-addon">
                            Currency
                        </div>
                        <input id="company_capacity" class="form-control form-control-static"
                               value="{{$company->currency}}" disabled>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade" id="tab_contact">

                <div class="lead">Contact Information</div>
                <div class="form-group">
                    <label class="control-label" for="contact_name"> Name </label>
                    <input type="text" class="form-control form-control-static" id="contact_name" disabled
                           value="{{$company->user_name}}">
                </div>
                <form action="{{ URL::action('CompaniesController@postUpdateEmail') }}" method="POST">
                    {!! csrf_field() !!}
                    <input type="hidden" name="company[id]" value="{{$company->id}}">
                    <div class="form-group">
                        <label class="control-label" for="contact_email"> Email </label>
                        <div class="input-group">
                            <input type="text" class="form-control" name="company[email]" id="contact_email"
                                   placeholder="Email..." value="{{$company->user_email}}">
                            <div class="input-group-btn">
                                <button class="btn btn-green">
                                    <i class="fa fa-refresh"></i>
                                    Update Email
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="form-group">
                    <label class="control-label" for="contact_mobile_number"> Mobile Number </label>
                    <input type="tel" class="form-control form-control-static" disabled id="contact_mobile_number"
                           value="{{$company->user_company_phone}}">
                </div>
            </div>
            <div class="tab-pane fade" id="tab_transactions">
                <div class="lead">Transactions
                    @if($registered)
                        <a href="{{URL::action('CompaniesController@getAddTransaction',['id'=>$company->id])}}"
                           type="button" class=" btn btn-dark pull-right">
                            Add a Transaction
                        </a>
                    @endif
                </div>
                @if(!$registered)
                    <div class="help-block">
                        You can't add another transaction until you set the Registration Transaction status to Closed.
                    </div>
                @endif
                <div class="table-responsive">
                    <table class="table hr-table table-hover">
                        <thead>
                        <tr>
                            <th> #</th>
                            <th> Amount</th>
                            <th> Status</th>
                            <th> Type</th>
                            <th> Details</th>
                            <th> Created</th>
                            <th> Updated</th>
                            <th> Expires</th>
                            <th> Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $index = 1; ?>
                        @foreach($transactions as $item)
                            <tr>
                                <td> {{ $index++ }}</td>
                                <td> {{ $item->amount." (".$item->currency.")" }}</td>
                                <td> {{ $item->status }}</td>
                                <td> {{ $item->type }}</td>
                                <td> {{ $item->details }}</td>
                                <td> {{ $item->created_at }}</td>
                                <td> {{ $item->updated_at? $item->updated_at: 'Never' }}</td>
                                <td> {{ $item->expires_at? $item->expires_at: 'Not Specified' }}</td>
                                <td>
                                    <div class="hr-actions-cell">
                                        <a href="{{ URL::action('CompaniesController@getEditTransaction',['id'=>$item->id]) }}"
                                           class="btn btn-dark">
                                            Edit
                                        </a>
                                        @if($item->type != 'Registration Transaction')
                                            <a href="#delete_transaction_{{$item->id}}"
                                               class="btn btn-red" data-toggle="modal">
                                                Delete
                                            </a>
                                        @endif
                                    </div>
                                </td>
                                @if($item->type != 'Registration Transaction')
                                    <div class="modal fade" id="delete_transaction_{{$item->id}}">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-body">
                                                    <form method="post"
                                                          action="{{ URL::action('CompaniesController@postDeleteTransaction') }}">
                                                        {!! csrf_field() !!}
                                                        <input type="hidden" value="{{$item->id}}"
                                                               name="transaction_id">
                                                        {!! csrf_field() !!}
                                                        <div class="help-block">
                                                            Are you sure you want to Delete the transaction
                                                            #{{ $item->id }}
                                                        </div>
                                                        <div class="form-actions">
                                                            <button type="submit" class="btn btn-red">
                                                                Delete
                                                            </button>
                                                            <button type="button" data-dismiss="modal"
                                                                    class="btn btn-dark">
                                                                Back to safety
                                                            </button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

@endsection