@extends('layout')
@section('actions')
    <div class="btn-group">
        <a href="{{URL::action('CompaniesController@getAddCompany')}}" type="button" class="btn btn-dark">
            New Company
        </a>
    </div>
@endsection
@section('title')
    <i class="icon icon-company-settings"></i> Companies
@endsection
@section('content')
    <div class="table-responsive">
        <table class="table hr-table hr-table2 table-hover">
            <thead>
            <tr>
                <th> Company</th>
                <th> Domain</th>
                <th> Contact</th>
                <th> Email</th>
                <th> Capacity</th>
                <th> Activation Date</th>
                <th> Last Deactivation Date</th>
                <th> Actions</th>
            </tr>
            </thead>
            <tbody>
            @foreach($companies as $item)
                <tr>
                    <td> {{ $item->name }}</td>
                    <td><a href="http://{{ $item->domain }}.{{env('DOMAIN')}}"> {{ $item->domain }}.{{env('DOMAIN')}}</a></td>
                    <td> {{ $item->user_name }}</td>
                    <td> {{ $item->user_email }}</td>
                    <td> {{ $item->capacity }}</td>
                    <td> {{ $item->activated_at }}</td>
                    <td> {{ $item->deactivated_at }}</td>
                    <td>
                        <div class="hr-actions-cell">
                            <a href="{{ URL::action('CompaniesController@getDetails',['id'=>$item->id],false) }}"
                               class="btn btn-dark">
                                Details
                            </a>
                            {{--<a href="{{ URL::action('CompaniesController@getTransactions',['id'=>$item->id]) }}"--}}
                            {{--class="btn btn-dark">--}}
                            {{--Transactions--}}
                            {{--</a>--}}
                            <a class="btn btn-{{($item->active)?"red":"green" }}"
                               data-target="#change_active_status{{$item->id}}" data-toggle="modal">
                                {{ ($item->active)?"Deactivate":"Activate" }}
                            </a>
                            <a  href="{{ URL::action('CompaniesController@getAccessAsAdmin',['id'=>$item->id]) }}" class="btn btn-info">
                                Access
                            </a>
                        </div>
                    </td>

                    <div class="modal fade" id="change_active_status{{$item->id}}">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-body">
                                    <form method="post"
                                          action="{{ URL::action('CompaniesController@postChangeActiveStatus') }}">
                                        {!! csrf_field() !!}
                                        <input type="hidden" value="{{$item->id}}" name="company_id">
                                        <input type="hidden" value="{{($item->active)?'true':'false'}}"
                                               name="status">
                                        <div class="help-block">Are you sure you want
                                            to {{ ($item->active)?"deactivate":"activate" }} the
                                            company "{{ $item->name }}"
                                        </div>
                                        <div class="form-actions">
                                            <button type="submit" class="btn btn-{{($item->active)?"red":"green" }}">
                                                {{ ($item->active)?"Deactivate":"Activate" }}
                                            </button>
                                            <button type="button" data-dismiss="modal" class="btn btn-dark">
                                                Back to safety
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
@endsection