@extends('layout')
@section('title')
    Add a new Transaction
@endsection
@section('pageScripts')
    <script type="text/javascript">
        function updateCapacityInput(enabled, label) {
            if (enabled)
            {
                $('#expiry_holder').hide();
                $('#capacity_holder').show();
            }
            else
                $('#capacity_holder').hide();
            $('label[for="capacity"]').text(label);
        }
        $('#type').on('change', function () {
            if ($(this).val() == 'increase') {
                updateCapacityInput(true, 'Increase User Capacity By');
            }
            else if ($(this).val() == 'decrease') {
                updateCapacityInput(true, 'Decrease User Capacity By');
            }
            else if ($(this).val() == 'charge') {
                updateCapacityInput(false, '');
                $('#expiry_holder').show();
            }
            else {
                updateCapacityInput(false, '');
                $('#expiry_holder').hide();
            }
        })
    </script>
@endsection
@section('content')
    <form action="{{ URL::action('CompaniesController@postCreateTransaction') }}" method="POST">
        <input type="hidden" value="{{$company_id}}" name="company_id">
        {!! csrf_field() !!}
        <div class="form-group">
            <label for="type" class="control-label">Transaction Type</label>
            <select id="type" name="transaction[type]" class="form-control">
                <option value="increase">Increase User Capacity</option>
                <option value="decrease">Decrease User Capacity</option>
                <option value="charge">Charge</option>
                <option value="other">Other</option>
            </select>
        </div>
        <div class="form-group" id="capacity_holder">
            <label for="capacity">Increase User Capacity by</label>
            <input id="capacity" type="number" class="form-control" name="transaction[capacity]" value="5" min="1">
        </div>
        <div class="form-group">
            <label for="fees" class="control-label">Fees</label>
            <input id="fees" type="text" class="form-control" name="transaction[fees]">
        </div>
        <div class="form-group" id="expiry_holder" style="display: none;">
            <label for="expiry">Expiry Date</label>
            <input type="text" class="form-control has-date-picker" name="transaction[expires_at]">
        </div>
        <div class="form-group">
            <label for="currency" class="control-label">Currency</label>
            <select id="currency" name="transaction[currency]" class="form-control">
                @foreach(\App\Util::getCurrencies() as $opt)
                    <option value="{{$opt}}">{{$opt}}</option>
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <label for="details" class="control-label">Details</label>
            <textarea name="transaction[details]" id="details" cols="30" rows="10" class="form-control"></textarea>
        </div>
        <div class="form-group">
            <label for="transaction_status" class="control-label">Status</label>
            <select name="transaction[status]" id="transaction_status" class="form-control">
                <option value="pending">Pending</option>
                <option value="closed">Closed</option>
            </select>
        </div>
        <div class="form-actions">
            <a href="{{ URL::action('CompaniesController@getDetails',['id'=>$company_id]) }}" class="btn btn-dark">
                Cancel
            </a>
            <button type="submit" class="btn btn-green">
                Save
            </button>
        </div>
    </form>
@endsection