@extends('layout')
@section('title')
    Edit Transaction #{{$transaction->id}}
@endsection
@section('pageScripts')
    <script type="text/javascript">
        function updateCapacityInput(enabled, label) {
            if (enabled)
            {
                $('#expiry_holder').hide();
                $('#capacity_holder').show();
            }
            else
                $('#capacity_holder').hide();
            $('label[for="capacity"]').text(label);
        }
        $('#type').on('change', function () {
            if ($(this).val() == 'increase') {
                updateCapacityInput(true, 'Increase User Capacity By');
            }
            else if ($(this).val() == 'decrease') {
                updateCapacityInput(true, 'Decrease User Capacity By');
            }
            else if ($(this).val() == 'charge') {
                updateCapacityInput(false, '');
                $('#expiry_holder').show();
            }
            else {
                updateCapacityInput(false, '');
                $('#expiry_holder').hide();
            }
        })
    </script>
@endsection
@section('content')
    <form action="{{ URL::action('CompaniesController@postUpdateTransaction') }}" method="POST">
        <input type="hidden" value="{{$transaction->id}}" name="transaction_id">
        <input type="hidden" value="{{$transaction->company_id}}" name="company_id">
        {!! csrf_field() !!}
        <div class="form-group">
            <label for="type" class="control-label">Transaction Type</label>
            @if($transaction->type == "Registration Transaction")
                <input type="text" class="form-control form-control-static"
                value="Registration Transaction" disabled>
                <input type="hidden" name="transaction[type]" value="Registration Transaction">
            @else
                <select id="type" name="transaction[type]" class="form-control">
                    @foreach([
                    'increase'=>'Increase User Capacity',
                    'decrease'=>'Decrease User Capacity',
                    'charge'=>'Charge',
                    'other'=>'Other'
                    ] as $key=>$value)
                        @if($transaction->type == $value)
                            <option value="{{$key}}" selected>{{$value}}</option>
                        @else
                            <option value="{{$key}}">{{$value}}</option>
                        @endif
                    @endforeach
                </select>
            @endif
        </div>
        <div class="form-group" id="capacity_holder"
             @if(!in_array($transaction->type,['Increase User Capacity','Decrease User Capacity','Registration Transaction']))
             style="display: none;"
                @endif>
            @if($transaction->type != 'Registration Transaction')
                <label for="capacity">{{$transaction->type}} by</label>
            @else
                <label for="capacity">User Capacity</label>
            @endif
            <input id="capacity" type="number" class="form-control" name="transaction[capacity]"
                   value="{{$transaction->capacity}}" min="1">
        </div>
        <div class="form-group">
            <label for="fees" class="control-label">Fees</label>
            <input id="fees" type="text" class="form-control" name="transaction[fees]" value="{{$transaction->amount}}">
        </div>
        <div class="form-group" id="expiry_holder" @if($transaction->type != 'Charge') style="display: none;" @endif>
            <label for="expiry">Expiry Date</label>
            <input type="text" class="form-control has-date-picker" name="transaction[expires_at]" value="{{ $transaction->expires_at }}">
        </div>
        <div class="form-group">
            <label for="currency" class="control-label">Currency</label>
            <select id="currency" name="transaction[currency]" class="form-control">
                @foreach(\App\Util::getCurrencies() as $opt)
                    @if($transaction->currency == $opt)
                        <option value="{{$opt}}" selected>{{$opt}}</option>
                    @else
                        <option value="{{$opt}}">{{$opt}}</option>
                    @endif
                @endforeach
            </select>
        </div>
        <div class="form-group">
            <label for="details" class="control-label">Details</label>
            <textarea name="transaction[details]" id="details" cols="30" rows="10"
                      class="form-control">{{$transaction->details}}</textarea>
        </div>
        <div class="form-group">
            <label for="transaction_status" class="control-label">Status</label>
            <select name="transaction[status]" id="transaction_status" class="form-control">
                @foreach(['pending','closed'] as $opt)
                    @if($transaction->status == $opt)
                        <option value="{{$opt}}" selected>{{ucfirst($opt)}}</option>
                    @else
                        <option value="{{$opt}}">{{ucfirst($opt)}}</option>
                    @endif
                @endforeach
            </select>
        </div>
        <div class="form-actions">
            <a href="{{ URL::action('CompaniesController@getDetails',['id'=>$transaction->company_id]) }}"
               class="btn btn-dark">
                Cancel
            </a>
            <button type="submit" class="btn btn-green">
                Update
            </button>
        </div>
    </form>
@endsection