@extends('layout')
zzz
@section('content')
    <div class="portlet light">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-plus"></i> Edit {{$compensation->name}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="form">
                <form action="{{ URL::action('CompensationController@postEditCompensation') }}" class="form-horizontal"
                      id="submit_form" method="POST">
                    {!! csrf_field() !!}
                    <div class="form-body">
                        <input type="hidden" name="compensation_id" value="{{$compensation->id}}">
                        <h3 class="block">Adjust {{$compensation->name}} Details</h3>

                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" class="form-control" name="name" value="{{ $compensation->name }}">
                        </div>
                        <div class="form-group">
                            <label>Details</label>
                            <textarea class="form-control" name="details">{{ $compensation->details }}</textarea>
                        </div>
                        <div class="form-group">
                            <label>Default Value</label>
                            <input type="number" class="form-control" name="default_value" value="{{ $compensation->default_value }}">
                        </div>
                        <div class="form-actions">
                            <div class="row">
                                <div class="center-block col-md-9">
                                    <button type="reset" class=" btn btn-primary">
                                        Reset <i class="m-icon-swapright m-icon-white"></i>
                                    </button>
                                    <button type="submit" class=" btn btn-success">
                                        Save <i class="m-icon-swapright m-icon-white"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection