@extends('layout')

@section('extra_css')
    <link href="{{ URL::asset('assets/global/css/components.css') }}" id="style_components" rel="stylesheet"
          type="text/css"/>
    <link href="{{ URL::asset('assets/global/css/plugins.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/admin/layout/css/layout.css') }}" rel="stylesheet" type="text/css"/>
    <link href="{{ URL::asset('assets/admin/layout/css/custom.css') }}" rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" type="text/css" href="{{ URL::asset('assets/global/plugins/select2/select2.css') }}">
@endsection

@section('extra_js')
    <script type="text/javascript"
            src="{{ URL::asset('assets/global/plugins/jquery-validation/js/jquery.validate.min.js') }}"></script>
    <script type="text/javascript"
            src="{{ URL::asset('assets/global/plugins/jquery-validation/js/additional-methods.min.js') }}"></script>
    <script type="text/javascript"
            src="{{ URL::asset('assets/global/plugins/bootstrap-wizard/jquery.bootstrap.wizard.min.js') }}"></script>
    <script type="text/javascript" src="{{ URL::asset('assets/global/plugins/select2/select2.min.js') }}"></script>
    <!-- END PAGE LEVEL PLUGINS -->
    <!-- BEGIN PAGE LEVEL SCRIPTS -->
    <script src="{{ URL::asset('assets/global/scripts/metronic.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/admin/layout/scripts/layout.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/admin/layout/scripts/quick-sidebar.js') }}" type="text/javascript"></script>
    <script src="{{ URL::asset('assets/admin/pages/scripts/form-wizard-request.js') }}" type="text/javascript"></script>

@endsection

@section('decent_scripts')

@endsection

@section('actions')
    <div class="btn-group">
        <a href="{{URL::action('CompensationController@getAddCompensation')}}" type="button" class="btn btn-success">
            <i class="fa fa-plus"></i> Add Compensation & Benefit
        </a>
        <button type="button" class="btn btn-primary" onclick="$('#apply_compensations').submit();">
            <i class="fa fa-gears"></i> Apply Compensations
        </button>
        <form id="apply_compensations" method="post" action="{{ URL::action('CompensationController@postApplyCompensations') }}">
            {!! csrf_field() !!}
        </form>
    </div>
@endsection

@section('content')
    <div class="portlet box green">
        <div class="portlet-title">
            <div class="caption">
                <i class="fa fa-group"></i>Compensation Control
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-hover">
                    <thead>
                    <tr>
                        <th> Name</th>
                        <th> Default</th>
                        <th> Details</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    @foreach(\App\Compensation::all() as $item)
                        <tr>
                            <td> {{ $item->name }}</td>
                            <td> {{ $item->default_value }}</td>
                            <td> {{ $item->details }}</td>
                            <td>
                                <a href="{{ URL::action('CompensationController@getEditCompensation',['id'=>$item->id]) }}"
                                   class="btn btn-icon-only blue">
                                    <i class="fa fa-edit"></i>
                                </a>
                                <button type="submit" class="btn btn-icon-only red">
                                    <i class="fa fa-remove"></i>
                                </button>
                                <form method="post" class="form-inline"
                                      action="{{ URL::action('CompensationController@postDeleteCompensation') }}">
                                    {!! csrf_field() !!}
                                    <input type="hidden" name="compensation_id" value="{{$item->id}}">

                                </form>

                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection